#include "qfle3f.h"
#include "qfle3f_version.h"

/*
 *  Dump the Contents of a buffer into the CoreDump file.
 *  @string	: buffer
 *  @size	: Size of the buffer
 *
 *  Note: Should not be invoked with a lock held.
 */
static void dump_to_file(const char *string, int size) {
	if(string != NULL)
		vmk_DumpRange(qfle3fDriverInfo.dumpHandler,
				(vmk_VA) string, size);
}

VMK_ReturnStatus qfle3fDumpCallback(void *cookie, vmk_Bool liveDump)
{
	struct qfle3fHBA *hba;
	int dump_size = 1024;
	vmk_ListLinks *currentAdapter;
	char *buffer = qfle3f_alloc(dump_size);

	vmk_StringFormat(buffer, 80, NULL, "Driver Version =%s",
				QFLE3F_VERSION);
	dump_to_file(buffer, vmk_Strnlen(buffer, 80));

	if (vmk_ListIsEmpty(&qfle3fDriverInfo.qfle3fHostList)) {
		vmk_AlertMessage("%s: %d: No Host found !\n",
			__func__, __LINE__);
		return VMK_OK;
	} else {
		VMK_LIST_FORALL(&qfle3fDriverInfo.qfle3fHostList, currentAdapter) {
			hba = VMK_LIST_ENTRY(currentAdapter, struct qfle3fHBA, link);

			vmk_StringFormat(buffer, 80, NULL, "qfle3fHBA=%p, ql_fcoe_adapter=%p\n",
				hba, hba->qlfcoeAdapter);
			dump_to_file(buffer, vmk_Strnlen(buffer, 80));

		}
	}

	qfle3f_free(buffer);

	return VMK_OK;
}
