/*******************************************************************************
 * See COPYRIGHT.txt & LICENSE.txt for copyright and licensing details.
 *******************************************************************************/

/*
 * qfle3f_debug.h: QLogic 10 Gigabit ESX Ethernet FCoE offload driver.
 *
 * This file contains helper routines that handle debug control.
 */

#ifndef __QFLE3F_DEBUG__
#define __QFLE3F_DEBUG__

#include "qfle3f.h"

/* Log level bit mask */
#define LOG_IOERR		0x00000001	/* scsi cmd error, cleanup */
#define LOG_SESS		0x00000002	/* Session setup, cleanup, etc' */
#define LOG_DEV_EVT		0x00000004	/* Device events, link, mtu, etc' */
#define LOG_SCSI_TM		0x00000008	/* SCSI Task Mgmt */
#define LOG_LPORT		0x00000010	/* lport related */
#define LOG_RPORT		0x00000020	/* rport related */
#define LOG_ELS			0x00000040	/* ELS logs */
#define LOG_FRAME_ERR		0x00000080	/* fip/fcoe L2 frame error logs*/
#define LOG_INIT		0x00000100	/* Init logs */
#define LOG_DISCO		0x00000200	/* Link discovery events */
#define LOG_TIMER		0x00000400	/* Timer events */
#define LOG_FRAME		0x00000800	/* fip/fcoe L2 frame info logs */
#define LOG_MP_REQ		0x00001000	/* Middle Path (MP) related */
#define LOG_ERROR		0x00002000	/* log non-fatal errors */
#define LOG_UNSOL		0x00004000	/* unsolicited event */
#define LOG_NPIV		0x00008000	/* npiv path logs */
#define LOG_FCP_ERR		0x00010000	/* log fcp errors */
#define LOG_VLAN		0x00020000	/* log vlan info */
#define LOG_APP			0x00040000	/* log ioctl info */
#define LOG_INITV		0x10000000	/* Init logs */
#define LOG_SESSV		0x20000000	/* Session setup, cleanup, etc' */
#define LOG_INFO		0x80000000	/* Warning: Be aware that this will fill up logs extremely fast */
#define LOG_ALL			0xffffffff	/* LOG all messages */


extern unsigned long qfle3f_debug_level;

/* Prints for corresponding debug level enabled */
#define qfle3f_log(sh_or_fn, mask, format, ...) \
	{ \
		if (VMK_UNLIKELY((mask) & qfle3f_debug_level)) { \
			if ((sh_or_fn != NULL) && (sh_or_fn->scsiAdapter != NULL)) { \
				if (!vmk_Strcmp(vmk_ScsiGetAdapterName(sh_or_fn->scsiAdapter), "Invalid")) { \
					vmk_LogMessage("%s:(%hx:%hx.%hx): %s:%d: " format, \
					QFLE3F_DRIVER_NAME,  \
					sh_or_fn->vmk_pci_addr.bus, \
					sh_or_fn->vmk_pci_addr.dev, sh_or_fn->vmk_pci_addr.fn, \
					__func__, __LINE__, ##__VA_ARGS__); \
				} else { \
					vmk_LogMessage("%s:%s: %s:%d: " format, \
					QFLE3F_DRIVER_NAME, \
					vmk_ScsiGetAdapterName(sh_or_fn->scsiAdapter), \
					__func__, __LINE__, ##__VA_ARGS__); \
				} \
			} else { \
				vmk_LogMessage("%s:%s:%d: " format,		\
					QFLE3F_DRIVER_NAME, \
					__func__, __LINE__,			\
					##__VA_ARGS__);				\
			} \
		} \
	}

/* Prints unconditionally, for errors */
#define qfle3f_err(sh_or_fn, format, ...) \
	{ \
		if ((sh_or_fn != NULL) && (sh_or_fn->scsiAdapter != NULL)) { \
			if (!vmk_Strcmp(vmk_ScsiGetAdapterName(sh_or_fn->scsiAdapter), "Invalid")) { \
				vmk_LogMessage("%s:(%hx:%hx.%hx): %s:%d:Error: " format, \
				QFLE3F_DRIVER_NAME,  \
				sh_or_fn->vmk_pci_addr.bus, \
				sh_or_fn->vmk_pci_addr.dev, sh_or_fn->vmk_pci_addr.fn, \
				__func__, __LINE__, ##__VA_ARGS__); \
			} else { \
				vmk_LogMessage("%s:%s:%s:%d:Error: " format, \
				QFLE3F_DRIVER_NAME, \
				vmk_ScsiGetAdapterName(sh_or_fn->scsiAdapter), \
				__func__, __LINE__, ##__VA_ARGS__); \
			} \
		} else { \
			vmk_LogMessage("%s:%s:%d:Error: " format,		\
				QFLE3F_DRIVER_NAME, \
				__func__, __LINE__,			\
				##__VA_ARGS__);				\
		} \
	}

/* Prints unconditionally, for notice */
#define qfle3f_notice(sh_or_fn, format, ...) \
	{ \
		if ((sh_or_fn != NULL) && (sh_or_fn->scsiAdapter != NULL)) { \
			if (!vmk_Strcmp(vmk_ScsiGetAdapterName(sh_or_fn->scsiAdapter), "Invalid")) { \
				vmk_LogMessage("%s:(%hx:%hx.%hx): %s:%d:Info: " format, \
				QFLE3F_DRIVER_NAME,  \
				sh_or_fn->vmk_pci_addr.bus, \
				sh_or_fn->vmk_pci_addr.dev, sh_or_fn->vmk_pci_addr.fn, \
				__func__, __LINE__, ##__VA_ARGS__); \
			} else { \
				vmk_LogMessage("%s:%s:%s:%d:Info: " format, \
				QFLE3F_DRIVER_NAME, \
				vmk_ScsiGetAdapterName(sh_or_fn->scsiAdapter), \
				__func__, __LINE__, ##__VA_ARGS__); \
			} \
		} else { \
			vmk_LogMessage("%s:%s:%d:Info: " format,		\
				QFLE3F_DRIVER_NAME, \
				__func__, __LINE__,			\
				##__VA_ARGS__);				\
		} \
	}

/* Prints unconditionally. Use when something bad might happen */
/* Note: Should never print ininitiatorPortIDe loops */
#define qfle3f_warning(sh_or_fn, format, ...) \
	{ \
		if ((sh_or_fn != NULL) && (sh_or_fn->scsiAdapter != NULL)) { \
			if (!vmk_Strcmp(vmk_ScsiGetAdapterName(sh_or_fn->scsiAdapter), "Invalid")) { \
				vmk_WarningMessage("%s:(%hx:%hx.%hx): %s:%d: " format, \
				QFLE3F_DRIVER_NAME,\
				sh_or_fn->vmk_pci_addr.bus, \
				sh_or_fn->vmk_pci_addr.dev, sh_or_fn->vmk_pci_addr.fn, \
				__func__, __LINE__, ##__VA_ARGS__); \
			} else { \
				vmk_WarningMessage("%s:%s:%s:%d: " format, \
				QFLE3F_DRIVER_NAME, \
				vmk_ScsiGetAdapterName(sh_or_fn->scsiAdapter), \
				__func__, __LINE__, ##__VA_ARGS__); \
			} \
		} else { \
			vmk_WarningMessage("%s: %s:%d: " format,		\
				QFLE3F_DRIVER_NAME,\
				__func__, __LINE__,			\
				##__VA_ARGS__);				\
		} \
	}

/* Prints unconditionally. Use when Administrator needs to be notified */
#define qfle3f_alert(sh_or_fn, format, ...) \
	{ \
		if ((sh_or_fn != NULL) && (sh_or_fn->scsiAdapter != NULL)) { \
			if (!vmk_Strcmp(vmk_ScsiGetAdapterName(sh_or_fn->scsiAdapter), "Invalid")) { \
				vmk_AlertMessage("%s:(%hx:%hx.%hx): %s:%d: " format, \
				QFLE3F_DRIVER_NAME,\
				sh_or_fn->vmk_pci_addr.bus, \
				sh_or_fn->vmk_pci_addr.dev, sh_or_fn->vmk_pci_addr.fn, \
				__func__, __LINE__, ##__VA_ARGS__); \
			} else { \
				vmk_AlertMessage("%s:%s: %s:%d: " format, \
				QFLE3F_DRIVER_NAME, \
				vmk_ScsiGetAdapterName(sh_or_fn->scsiAdapter), \
				__func__, __LINE__, ##__VA_ARGS__); \
			} \
		} else { \
			vmk_AlertMessage("%s:%s:%d: " format,		\
				QFLE3F_DRIVER_NAME,\
				__func__, __LINE__,			\
				##__VA_ARGS__);				\
		} \
	}

#define	QFLE3F_LINK_NAME		"link_port"
#define	QFLE3F_FUNC_NAME 	"func"
#define	QFLE3F_SHOST_NAME	"shost"
#define	QFLE3F_RPORT_NAME	"rport"

#define	QFLE3F_LINK_ST_SIZE	(64 * 8)
#define	QFLE3F_FUNC_ST_SIZE	(256 * 8)
#define	QFLE3F_SHOST_ST_SIZE	(16 * 256 * 8)
#define	QFLE3F_RPORT_ST_SIZE	(64 * 256 * 8)

struct qfle3f_dump {
	char driver_name[8];
	char qfle3f_driver_version[40];
	char end[4];
};

#endif

