/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.api.Transformer;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.CleanupAction;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.CacheVersionMapping;
import org.gradle.cache.internal.CompositeCleanupAction;
import org.gradle.cache.internal.FilesFinder;
import org.gradle.cache.internal.LeastRecentlyUsedCacheCleanup;
import org.gradle.cache.internal.SingleDepthFilesFinder;
import org.gradle.cache.internal.UnusedVersionsCacheCleanup;
import org.gradle.cache.internal.UsedGradleVersions;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.internal.Factories;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classpath.CachedClasspathTransformer;
import org.gradle.internal.classpath.CachedJarFileStore;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.file.FileAccessTimeJournal;
import org.gradle.internal.file.JarCache;
import org.gradle.internal.resource.local.FileAccessTracker;
import org.gradle.internal.resource.local.SingleDepthFileAccessTracker;
import org.gradle.util.CollectionUtils;

public class DefaultCachedClasspathTransformer
implements CachedClasspathTransformer,
Closeable {
    public static final CacheVersionMapping CACHE_VERSION_MAPPING = CacheVersionMapping.introducedIn((String)"3.1-rc-1").incrementedIn("3.2-rc-1").incrementedIn("3.5-rc-1").build();
    public static final String CACHE_NAME = "jars";
    public static final String CACHE_KEY = "jars-" + CACHE_VERSION_MAPPING.getLatestVersion();
    private static final int FILE_TREE_DEPTH_TO_TRACK_AND_CLEANUP = 1;
    private final PersistentCache cache;
    private final Transformer<File, File> jarFileTransformer;

    public DefaultCachedClasspathTransformer(CacheRepository cacheRepository, JarCache jarCache, FileAccessTimeJournal fileAccessTimeJournal, List<CachedJarFileStore> fileStores, UsedGradleVersions usedGradleVersions) {
        this.cache = cacheRepository.cache(CACHE_KEY).withDisplayName(CACHE_NAME).withCrossVersionCache(CacheBuilder.LockTarget.DefaultTarget).withLockOptions((LockOptions)LockOptionsBuilder.mode((FileLockManager.LockMode)FileLockManager.LockMode.None)).withCleanup((CleanupAction)CompositeCleanupAction.builder().add(new CleanupAction[]{UnusedVersionsCacheCleanup.create((String)CACHE_NAME, (CacheVersionMapping)CACHE_VERSION_MAPPING, (UsedGradleVersions)usedGradleVersions)}).add(new CleanupAction[]{new LeastRecentlyUsedCacheCleanup((FilesFinder)new SingleDepthFilesFinder(1), fileAccessTimeJournal, 7L)}).build()).open();
        SingleDepthFileAccessTracker fileAccessTracker = new SingleDepthFileAccessTracker(fileAccessTimeJournal, this.cache.getBaseDir(), 1);
        this.jarFileTransformer = new FileAccessTrackingJarFileTransformer(new CachedJarFileTransformer(jarCache, fileStores), (FileAccessTracker)fileAccessTracker);
    }

    @Override
    public ClassPath transform(ClassPath classPath) {
        return DefaultClassPath.of((Collection)CollectionUtils.collect((Iterable)classPath.getAsFiles(), this.jarFileTransformer));
    }

    @Override
    public Collection<URL> transform(Collection<URL> urls) {
        return CollectionUtils.collect(urls, (Transformer)new Transformer<URL, URL>(){

            public URL transform(URL url) {
                if (url.getProtocol().equals("file")) {
                    try {
                        return ((File)DefaultCachedClasspathTransformer.this.jarFileTransformer.transform((Object)new File(url.toURI()))).toURI().toURL();
                    }
                    catch (URISyntaxException e) {
                        throw UncheckedException.throwAsUncheckedException((Throwable)e);
                    }
                    catch (MalformedURLException e) {
                        throw UncheckedException.throwAsUncheckedException((Throwable)e);
                    }
                }
                return url;
            }
        });
    }

    @Override
    public void close() throws IOException {
        this.cache.close();
    }

    private class FileAccessTrackingJarFileTransformer
    implements Transformer<File, File> {
        private final Transformer<File, File> delegate;
        private final FileAccessTracker fileAccessTracker;

        FileAccessTrackingJarFileTransformer(Transformer<File, File> delegate, FileAccessTracker fileAccessTracker) {
            this.delegate = delegate;
            this.fileAccessTracker = fileAccessTracker;
        }

        public File transform(File file) {
            File result = (File)this.delegate.transform((Object)file);
            this.fileAccessTracker.markAccessed(result);
            return result;
        }
    }

    private class CachedJarFileTransformer
    implements Transformer<File, File> {
        private final JarCache jarCache;
        private final Factory<File> baseDir;
        private final List<String> prefixes;

        CachedJarFileTransformer(JarCache jarCache, List<CachedJarFileStore> fileStores) {
            this.jarCache = jarCache;
            this.baseDir = Factories.constant((Object)DefaultCachedClasspathTransformer.this.cache.getBaseDir());
            this.prefixes = new ArrayList<String>(fileStores.size() + 1);
            this.prefixes.add(this.directoryPrefix(DefaultCachedClasspathTransformer.this.cache.getBaseDir()));
            for (CachedJarFileStore fileStore : fileStores) {
                for (File rootDir : fileStore.getFileStoreRoots()) {
                    this.prefixes.add(this.directoryPrefix(rootDir));
                }
            }
        }

        private String directoryPrefix(File dir) {
            return dir.getAbsolutePath() + File.separator;
        }

        public File transform(final File original) {
            if (this.shouldUseFromCache(original)) {
                return (File)DefaultCachedClasspathTransformer.this.cache.useCache((Factory)new Factory<File>(){

                    public File create() {
                        return CachedJarFileTransformer.this.jarCache.getCachedJar(original, (Factory<File>)CachedJarFileTransformer.this.baseDir);
                    }
                });
            }
            return original;
        }

        private boolean shouldUseFromCache(File original) {
            if (!original.isFile()) {
                return false;
            }
            String absolutePath = original.getAbsolutePath();
            for (String prefix : this.prefixes) {
                if (!absolutePath.startsWith(prefix)) continue;
                return false;
            }
            return true;
        }
    }
}

