//
//  Downloader.h
//  Cosmic Debris
//
//  Created by John Schilling on 11/22/04.
//  Copyright 2004 John Schilling. All rights reserved.
//

#import <Cocoa/Cocoa.h>


@interface Downloader : NSObject {
        
        id                                  _delegate;
        NSURLConnection                     *_download;
        NSMutableData                       *_data;
        NSMutableString                     *_URL;
        
        int                                 _bytesReceived;
        int                                 _expectedLength;
        BOOL                                _isDownloading;
        
}

- (id)initWithURL:(NSString *)URL delegate:(id)delegate;
- (void)cleanup;

- (void)setURL:(NSString *)URL;

- (void)downloadDataWithTimeoutInterval:(float)timeoutInterval;
- (void)cancelDownloading;
- (void)resetDownload;
- (void)resetSyncDownload;
- (BOOL)isDownloading;

@end

@interface NSObject (DownloaderDelegate)
// delegate methods
- (void)downloaderDidBegin:(Downloader *)downloader;
- (void)downloaderDidConnect:(Downloader *)downloader expectedLength:(int)expectedLength;
- (void)downloaderDidFailWithError:(Downloader *)downloader error:(NSString *)error;
- (void)downloaderDidReceiveData:(Downloader *)downloader bytesReceived:(int)bytesReceived expectedLength:(int)expectedLength;
- (void)downloaderDidFinishWithData:(Downloader *)downloader data:(NSData *)data;
- (void)downloaderDidReset:(Downloader *)downloader;
@end
