//
//  LANController.m
//  BwanaDik
//
//  Created by John Schilling on 9/8/06.
//  Copyright 2006 John Schilling. All rights reserved.
//

#import "LANController.h"
#import "NSStringExtras.h"

@implementation LANController

#pragma mark
#pragma mark PRIVATE INSTANCE METHODS
#pragma mark


- (id)init
{
    if( ![super init] ) return nil;
    
        _currentAddress     = [[NSMutableString alloc] initWithString:@""];
        _previousAddress    = [[NSMutableString alloc] initWithString:@""];
        
        _interfaceAddresses = [[NSMutableArray alloc] init];

    return self;
}

- (void)awakeFromNib
{

}

- (void)dealloc
{
    [_currentAddress     release];
    [_previousAddress    release];
    [_interfaceAddresses removeAllObjects];
    [_interfaceAddresses release];
    
    [super dealloc];
}


- (void)setDelegate:(id)delegate
{
    _delegate = delegate;
}



#pragma mark
#pragma mark ACCESS TO STATE VARIABLES
#pragma mark

- (int)numWiredInterfaces
{
    return( _wiredCount );
}

- (NSString *)currentLANAddress
{
    return _currentAddress;
}

- (NSString *)previousLANAddress
{
    return _previousAddress;
}

- (NSString *)interfaceAddressForIndex:(int)index
{
    if( [_interfaceAddresses count] > index )
    {
        return( [_interfaceAddresses objectAtIndex: index] );
    }
    return( @" " );
}




#pragma mark
#pragma mark CORE LAN FETCHING PARSING METHODS
#pragma mark

- (NSArray *)ExecuteShellScript: (NSString *)script
{
    NSAppleScript *pScript;
    NSString      *pScriptCode;
    NSArray       *pResult;
    int            i;
    
    pScriptCode = [NSString stringWithFormat: @"set theResult to do shell script (\" %@  \") as string", script];
    pScript     = [[[NSAppleScript alloc] initWithSource: pScriptCode] autorelease];
    
    pResult = [[[pScript executeAndReturnError: nil] stringValue] componentsSeparatedByString: @"\r"];
    
    if( (pResult == nil) || ([pResult count] < 1) )
    {
        return( nil );
    }
    
    for( i = 0; i < [pResult count]; ++i )
    {
        NSString *pLine = [[pResult objectAtIndex: 0] stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceCharacterSet]];
        if( [pLine length] > 0 )
        {
            return( pResult );
        }
    }
    
    return( nil );
}

- (int)getWiredInterfaceCount
{
    NSString *aeString;
    int       wiredCount = 0;
  	
    aeString = @"ifconfig -a | grep 'en.:\\\\|fw.:' | awk '{print $1}'";
    NSArray *interfaces = [self ExecuteShellScript: aeString];
    if( interfaces == nil )
    {
        return;
    }
    
    int i;
    for( i = 0; i < [interfaces count]; ++i )
    {
        NSString *LANIP = [[interfaces objectAtIndex: i] stringByTrimmingCharactersInSet:[NSCharacterSet punctuationCharacterSet]];
        
        aeString = [NSString stringWithFormat: @"ifconfig %@ | grep '0baseT' | awk '{print $1}'", LANIP];
        NSArray *ethData = [self ExecuteShellScript: aeString];
        if( ethData != nil )
        {
            NSString *result = [[ethData objectAtIndex: 0] stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceCharacterSet]];
            if( [result length] > 0 )
            {
                wiredCount++;
            }
        }
    }
    
    return( wiredCount );
}

- (void)getCurrentLANAddresses
{
    int idx;
    
    _wiredCount = [self getWiredInterfaceCount];
    
    NSString *LANIP = [self currentLANAddressForInterface:-1]; //get whatever is current
    
    if (LANIP && [LANIP isValidAddress]) {	
        [_currentAddress setString:LANIP];
    } else {
        [_currentAddress setString: @""];
    }
    
    [_interfaceAddresses removeAllObjects];
    /*
    ** Add interface addresses. Use +2 because we also want to get airport and firewire
    */
    for( idx = 0; idx < _wiredCount + 2; ++idx )
    {
        [_interfaceAddresses addObject: [[self currentLANAddressForInterface: idx] copy]];
    }
    
    if ([_delegate respondsToSelector:@selector(LANCheckFinished)]) [_delegate LANCheckFinished];
    
    [self checkLANaddressChanged];
}

- (NSString *)currentLANAddressForInterface:(int)interface
{
    NSString *aeString;
  	
    /*
    ** Are we trying to get firewire?
    */
    if( interface >= (_wiredCount + 1) )
    {
        aeString = @"ifconfig fw0 | grep inet | grep -v inet6 | awk '{print $2}'";
    }
    /*
    ** Maybe we want a list of all interfaces?
    */
    else if( interface < 0 )
    {
        aeString = @"ifconfig -a | grep 'inet ' | grep -v '127' | grep 'netmask' | awk '{print $2}'";
    }
    /*
    ** OK, the rest are all labelled 'en?', so build as appropriate.
    */
    else
    {
        aeString = [NSString stringWithFormat: @"ifconfig en%d | grep inet | grep -v inet6 | awk '{print $2}'", interface];
    }
    
    NSArray *interfaces = [self ExecuteShellScript: aeString];
    if( interfaces == nil )
    {
        return( @"" );
    }
    
    NSString *LANIP = [interfaces objectAtIndex:0];
    
    if (LANIP && [LANIP isValidAddress])
    {
        return [LANIP stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceAndNewlineCharacterSet]];
    } else {
        return @"";
    }
}

- (void)checkLANaddressChanged
{
    // Okay, if the LAN changed, update the interface and get new WAN:
    if (![_currentAddress isEqualToString:_previousAddress])
    {
        
        if ([_delegate respondsToSelector:@selector(LANAddressChangedFrom:to:)])
        {
            [_delegate LANAddressChangedFrom:_previousAddress to:_currentAddress];
        }
        
        [_previousAddress setString:_currentAddress];
    }
}


@end
