//
//  CLMonthNameView.m
//  DateLine
//
//  Created by Alex Clarke on 20/05/05.
//  Copyright 2005 CocoaLab. All rights reserved.
//

#import "CLMonthNameView.h"
#import "NSBezierPath+CLExtensions.h"
#import "CLMonth.h"


@implementation CLMonthNameView

//Draw the graphics view
- (void)drawRect:(NSRect)rect
{	
	NSRect myBounds = [self bounds];
	
	// Some useful attributes
	double left = NSMinX(myBounds);
	double top = NSMaxY(myBounds);
	
	/* Draw elements */
	// Draw from left to right
	NSArray * graphicsArray = [self graphics];
	NSEnumerator *graphicsEnumerator = [graphicsArray objectEnumerator];
	id graphic;
	while (graphic = [graphicsEnumerator nextObject])
	{
		float yOffset = top;
		float xOffset = left; //left align
		[graphic setYLoc:yOffset];
		[graphic setXLoc:xOffset];
		[graphic drawInView:self];	//draw the element!
	}
}

- (void)mouseDown:(NSEvent *)event
{
	[super mouseDown:event];
	
	/* Fairly simple just to illustrate the point */
	NSNotificationCenter * centre = [NSNotificationCenter defaultCenter];
	
	// find out if we hit anything
	NSPoint p = [self convertPoint:[event locationInWindow] fromView:nil];
	NSEnumerator *gEnum = [[self graphics] reverseObjectEnumerator];
	id aGraphic;
	while (aGraphic = [gEnum nextObject])
	{
		if ([aGraphic hitTest:p isSelected:NO])
		{
			break;
		}
	}
	
	// if no graphic hit, then if extending selection do nothing
	// else set selection to nil
	if (aGraphic == nil)
	{
		if (!([event modifierFlags] & NSShiftKeyMask))
		{
			[selectionIndexesContainer setValue:nil forKeyPath:selectionIndexesKeyPath];
		}
		return;
	}
	
	// graphic hit
	// if not extending selection (Shift key down) then set
	// selection to this graphic
	// if extending selection, then:
	// - if graphic in selection remove it
	// - if not in selection add it
	NSIndexSet *selection = nil;
	unsigned int graphicIndex = [[self graphics] indexOfObject:aGraphic];
	
	if (!([event modifierFlags] & NSShiftKeyMask))
	{
		selection = [NSIndexSet indexSetWithIndex:graphicIndex];
		if ([event clickCount] == 2) //If it's a double click
		{
			NSCalendarDate * aDate = [NSCalendarDate date]; //  Todays date will do...
			[centre postNotificationName:@"selectMonthNotification" object:aDate];
			return;
		}		
	}
	else
	{
		if ([[self selectionIndexes] containsIndex:graphicIndex])
		{
			selection = [[[self selectionIndexes] mutableCopy] autorelease];
			[(NSMutableIndexSet *)selection removeIndex:graphicIndex];
		}
		else
		{
			selection = [[[self selectionIndexes] mutableCopy] autorelease];
			[(NSMutableIndexSet *)selection addIndex:graphicIndex];
		}
	}
	[selectionIndexesContainer setValue:selection forKeyPath:selectionIndexesKeyPath];
}

+ (Class)class
{
	return [super class];
}

-(BOOL)isOpaque
{
	return NO;
}

-(void) dealloc
{
	[super dealloc];	
}


@end
