/*
 * Decompiled with CFR 0.152.
 */
package auto;

import java.io.File;
import java.util.HashSet;
import shared.CryptHashes;
import shared.FileUtils;
import shared.Flt;
import shared.GetResource;
import shared.Timestamp;
import shared.b;
import shared.m;
import uru.vault.Node;
import uru.vault.Nodes;
import uru.vault.nodetype;
import uru.vault.vaultdatfile;
import uru.vault.vfile;

public class vaultAutomation {
    public static String xmlize(String s) {
        String result = s == null ? "" : s;
        result = result.replace("&", "&amp;");
        result = result.replace("<", "&lt;");
        result = result.replace(">", "&gt;");
        result = result.replace("\"", "&quot;");
        result = result.replace("'", "&apos;");
        return result;
    }

    private static void saveFile(String outfolder, StringBuilder xml2) {
        String xmls = xml2.toString();
        byte[] data = b.StringToBytes(xmls);
        String sha1 = b.BytesToHexString(CryptHashes.GetHash(data, CryptHashes.Hashtype.sha1));
        String filename = sha1 + ".mem.xml";
        FileUtils.WriteFile(outfolder + "/" + filename, data);
    }

    public static void saveImages(String infolder, String outfolder) {
        Nodes nodes;
        String vaultDotDat = infolder + "/vault.dat";
        if (FileUtils.Exists(vaultDotDat)) {
            nodes = Nodes.createFromNodeVector(vaultdatfile.createFromFilename((String)vaultDotDat).nodes);
        } else if (FileUtils.FindAllFiles(infolder, ".v", false).size() != 0) {
            nodes = vaultAutomation.readFolder(infolder);
        } else {
            m.err("The input folder must have either 'vault.dat' or some number of '.v' files.");
            return;
        }
        File of = new File(outfolder);
        if (!of.exists()) {
            m.err("You must select an output folder that already exists.");
            return;
        }
        if (!of.isDirectory()) {
            m.err("You must select an Output folder.");
            return;
        }
        m.status("Getting data...");
        StringBuilder xml2 = new StringBuilder();
        xml2.append("<?xml version='1.0' encoding='ISO-8859-1'?>");
        xml2.append("<?xml-stylesheet type='text/xsl' href='memories.xsl'?>");
        xml2.append("<memories>");
        HashSet dates = new HashSet();
        for (Node n : nodes.nodes) {
            StringBuilder xml22;
            Timestamp ts = n.age_time;
            if (n.type == nodetype.ImageNode) {
                byte[] data = n.ImageNode_GetImageData();
                String sha1 = b.BytesToHexString(CryptHashes.GetHash(data, CryptHashes.Hashtype.sha1));
                String filename = sha1 + ".jpg";
                FileUtils.WriteFile(outfolder + "/" + filename, data);
                StringBuilder xml23 = new StringBuilder();
                xml23.append("<imagenode>");
                xml23.append("<creationtime>" + vaultAutomation.xmlize(n.crt_time.toLongString()) + "</creationtime>");
                xml23.append("<agetime>" + vaultAutomation.xmlize(n.age_time.toLongString()) + "</agetime>");
                xml23.append("<modtime>" + vaultAutomation.xmlize(n.mod_time.toLongString()) + "</modtime>");
                xml23.append("<owner>" + vaultAutomation.xmlize(nodes.getAvatarName(n.owner)) + "</owner>");
                xml23.append("<agename>" + vaultAutomation.xmlize(n.ImageNode_GetAgeName()) + "</agename>");
                xml23.append("<caption>" + vaultAutomation.xmlize(n.ImageNode_GetCaption()) + "</caption>");
                xml23.append("<imagesha1>" + sha1 + "</imagesha1>");
                xml23.append("</imagenode>");
                vaultAutomation.saveFile(outfolder, xml23);
                continue;
            }
            if (n.type == nodetype.TextNoteNode) {
                xml22 = new StringBuilder();
                xml22.append("<textnotenode>");
                xml22.append("<creationtime>" + vaultAutomation.xmlize(n.crt_time.toLongString()) + "</creationtime>");
                xml22.append("<agetime>" + vaultAutomation.xmlize(n.age_time.toLongString()) + "</agetime>");
                xml22.append("<modtime>" + vaultAutomation.xmlize(n.mod_time.toLongString()) + "</modtime>");
                xml22.append("<owner>" + vaultAutomation.xmlize(nodes.getAvatarName(n.owner)) + "</owner>");
                xml22.append("<agename>" + vaultAutomation.xmlize(n.ImageNode_GetAgeName()) + "</agename>");
                xml22.append("<title>" + vaultAutomation.xmlize(n.TextNoteNode_GetTitle()) + "</title>");
                xml22.append("<text>" + vaultAutomation.xmlize(n.TextNoteNode_GetText()) + "</text>");
                xml22.append("</textnotenode>");
                vaultAutomation.saveFile(outfolder, xml22);
                continue;
            }
            if (n.type != nodetype.MarkerListNode) continue;
            xml22 = new StringBuilder();
            xml22.append("<markerlistnode>");
            xml22.append("<creationtime>" + vaultAutomation.xmlize(n.crt_time.toLongString()) + "</creationtime>");
            xml22.append("<agetime>" + vaultAutomation.xmlize(n.age_time.toLongString()) + "</agetime>");
            xml22.append("<modtime>" + vaultAutomation.xmlize(n.mod_time.toLongString()) + "</modtime>");
            xml22.append("<owner>" + vaultAutomation.xmlize(nodes.getAvatarName(n.owner)) + "</owner>");
            xml22.append("<agename>" + vaultAutomation.xmlize(n.ImageNode_GetAgeName()) + "</agename>");
            xml22.append("<gamename>" + vaultAutomation.xmlize(n.xu20.toString()) + "</gamename>");
            for (Node mn : nodes.getMarkers(n.owner, n.age_name.toString(), n.blob1)) {
                xml22.append("<marker>");
                Flt f16 = Flt.createFromData(mn.xu16);
                Flt f17 = Flt.createFromData(mn.xu17);
                Flt f18 = Flt.createFromData(mn.xu18);
                xml22.append("<text>" + mn.xu28.toString() + "</text>");
                xml22.append("<x>" + f16.toString() + "</x>");
                xml22.append("<y>" + f16.toString() + "</y>");
                xml22.append("<z>" + f16.toString() + "</z>");
                xml22.append("</marker>");
            }
            xml22.append("</markerlistnode>");
            vaultAutomation.saveFile(outfolder, xml22);
        }
        for (File f : FileUtils.FindAllFiles(outfolder, ".mem.xml", false)) {
            xml2.append(b.BytesToString(FileUtils.ReadFile(f)));
        }
        xml2.append("</memories>");
        FileUtils.WriteFile(outfolder + "/memories.xml", b.StringToBytes(xml2.toString()));
        FileUtils.WriteFile(outfolder + "/memories.xsl", GetResource.getResourceAsBytes("/files/memories.xsl"));
        FileUtils.WriteFile(outfolder + "/jquery.js", GetResource.getResourceAsBytes("/files/jquery-1.3.2.min.js"));
        m.status("In the output folder, there will be a file called 'memories.xml'; open it with your web-browser to view the memories.");
        m.status("Finished creating Memories files!");
    }

    public static Nodes readFolder(String infolder) {
        Nodes result = new Nodes();
        File folder = new File(infolder);
        for (File child : folder.listFiles()) {
            if (!child.getName().endsWith(".v")) continue;
            vfile vf = vfile.createFromFilename(child.getAbsolutePath());
            result.add(vf.node);
        }
        return result;
    }
}

