/*
 * Decompiled with CFR 0.152.
 */
package moulserver;

import java.util.Queue;
import moulserver.Comm;
import moulserver.ConnectionState;
import moulserver.Manager;
import moulserver.Server;
import shared.Concurrent;
import shared.Format;
import shared.IBytedeque;
import shared.IBytestream;
import shared.Str;
import shared.m;
import shared.uncaughtexception;
import uru.Bytedeque;

public class GateServer
extends Thread {
    public static final int kCli2GateKeeper_PingRequest = 0;
    public static final int kCli2GateKeeper_FileSrvIpAddressRequest = 1;
    public static final int kCli2GateKeeper_AuthSrvIpAddressRequest = 2;
    public static final int kCli2GateKeeper_LastMessage = 3;
    public static final int kGateKeeper2Cli_PingReply = 0;
    public static final int kGateKeeper2Cli_FileSrvIpAddressReply = 1;
    public static final int kGateKeeper2Cli_AuthSrvIpAddressReply = 2;
    public static final int kGateKeeper2Cli_LastMessage = 3;
    Queue<Comm.CommItem> items = Concurrent.getConcurrentQueue();
    Manager manager;

    public void HandleMessage(Object msg, ConnectionState connstate) {
        Class<?> klass = msg.getClass();
        if (klass == FileSrvIpAddressRequest.class) {
            m.msg("GateServer_FileSrvIpAddressRequest");
            FileSrvIpAddressRequest request = (FileSrvIpAddressRequest)msg;
            FileSrvIpAddressReply reply = new FileSrvIpAddressReply();
            reply.transId = request.transId;
            String domainname = this.manager.settings.getDomainName();
            reply.address = new Str(domainname);
            GateServer.SendMsg(connstate, reply);
        } else {
            m.throwUncaughtException("Unhandled GateServer msg: " + klass.getSimpleName());
        }
    }

    public GateServer(Manager manager) {
        this.manager = manager;
    }

    public void run() {
        m.msg("Starting GateServer...");
        while (true) {
            Comm.CommItem item;
            if ((item = this.items.poll()) != null) {
                if (item.type == Comm.CommItemType.HandleMessage) {
                    this.HandleMessage(item.msg, item.connstate);
                    continue;
                }
                m.throwUncaughtException("unhandled");
                continue;
            }
            try {
                Thread.sleep(4L);
            }
            catch (Exception exception) {
            }
        }
    }

    public static GateServerMsg ReadMessage(IBytestream c, boolean isServer) {
        short type = c.readShort();
        if (isServer) {
            switch (type) {
                case 1: {
                    return new FileSrvIpAddressRequest(c);
                }
                case 2: {
                    return new AuthSrvIpAddressRequest(c);
                }
            }
            throw new uncaughtexception("Unread GateServer msg: " + Short.toString(type));
        }
        switch (type) {
            case 1: {
                return new FileSrvIpAddressReply(c);
            }
            case 2: {
                return new AuthSrvIpAddressReply(c);
            }
        }
        throw new uncaughtexception("Unread GateServer msg: " + Short.toString(type));
    }

    public static void SendMsg(ConnectionState connstate, GateServerMsg msg) {
        Bytedeque c = new Bytedeque(Format.moul);
        ((IBytedeque)c).writeShort(msg.type());
        msg.write(c);
        byte[] data = ((IBytedeque)c).getAllBytes();
        connstate.sendMsgBytes(data);
    }

    public static class AuthSrvIpAddressReply
    extends GateServerMsg {
        int transId;
        Str address;

        public AuthSrvIpAddressReply() {
        }

        public AuthSrvIpAddressReply(IBytestream c) {
            this.transId = c.readInt();
            this.address = Str.readAsUtf16Sized16(c);
        }

        public void write(IBytedeque c) {
            c.writeInt(this.transId);
            this.address.writeAsUtf16Sized16(c);
        }

        public short type() {
            return 2;
        }

        public Integer transid() {
            return this.transId;
        }
    }

    public static class AuthSrvIpAddressRequest
    extends GateServerMsg {
        int transId;

        public AuthSrvIpAddressRequest() {
        }

        public AuthSrvIpAddressRequest(IBytestream c) {
            this.transId = c.readInt();
        }

        public void write(IBytedeque c) {
            c.writeInt(this.transId);
        }

        public short type() {
            return 2;
        }

        public Integer transid() {
            return this.transId;
        }
    }

    public static class FileSrvIpAddressRequest
    extends GateServerMsg {
        int transId;
        byte u1;

        public FileSrvIpAddressRequest() {
        }

        public FileSrvIpAddressRequest(IBytestream c) {
            this.transId = c.readInt();
            this.u1 = c.readByte();
        }

        public void write(IBytedeque c) {
            c.writeInt(this.transId);
            c.writeByte(this.u1);
        }

        public short type() {
            return 1;
        }

        public Integer transid() {
            return this.transId;
        }
    }

    public static class FileSrvIpAddressReply
    extends GateServerMsg {
        int transId;
        Str address;

        public FileSrvIpAddressReply() {
        }

        public FileSrvIpAddressReply(IBytestream c) {
            this.transId = c.readInt();
            this.address = Str.readAsUtf16Sized16(c);
        }

        public void write(IBytedeque c) {
            c.writeInt(this.transId);
            this.address.writeAsUtf16Sized16(c);
        }

        public short type() {
            return 1;
        }

        public Integer transid() {
            return this.transId;
        }
    }

    public static abstract class GateServerMsg
    extends Server.ServerMsg {
        public abstract short type();

        public byte[] GetMsgBytes() {
            Bytedeque c = new Bytedeque(Format.moul);
            ((IBytedeque)c).writeShort(this.type());
            this.write(c);
            byte[] data = ((IBytedeque)c).getAllBytes();
            return data;
        }
    }
}

