/*
 * Decompiled with CFR 0.152.
 */
package uam;

import auto.AllGames;
import auto.ageLists;
import gui.Main;
import gui.UamGui;
import java.io.File;
import java.util.HashMap;
import java.util.Vector;
import prpobjects.Pageid;
import prpobjects.PrpHeader;
import prpobjects.pakfile;
import prpobjects.sumfile;
import prpobjects.textfile;
import shared.CryptHashes;
import shared.Exec;
import shared.FileUtils;
import shared.GuiUtils;
import shared.IBytestream;
import shared.RandomUtils;
import shared.SerialBytestream;
import shared.State.AllStates;
import shared.b;
import shared.generic;
import shared.m;
import shared.sevenzip;
import uam.UamConfigNew;
import uru.UruCrypt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Uam {
    public static UamConfigNew ageList;
    public static InstallInfo installInfo;
    public static final String ageArchivesFolder = "/agearchives/";
    public static final String versionSep = "--";
    public static final String statusFilename = "uam.status.xml";

    public static boolean HasPermissions(String foldername) {
        boolean hasperms = FileUtils.HasPermissions2(foldername, false);
        if (!hasperms) {
            m.err("You appear to be running Windows Vista or Windows Seven.  Uru has a bug that will require a workaround, see http://dusty.homeunix.net/wiki/Drizzle#Vista_and_above for details.");
        }
        return hasperms;
    }

    public static void CheckForProblems(boolean doDetailedCheck) {
        String pathToFile = Uam.getPotsFolder() + "/Python/system/_socket.pyd";
        if (FileUtils.Exists(pathToFile)) {
            m.warn("There is a privacy/security/persistency risk.  It is strongly recommended that you either: a) install the 'Network Access' with version '(disabled)', or b) manually delete the following file: ", pathToFile, " Either way, this warning should not be displayed afterwards.");
        }
    }

    public static void ClearSumFiles() {
        if (!AllGames.getPots().isFolderX(Uam.getPotsFolder())) {
            return;
        }
        if (!Uam.HasPermissions(Uam.getPotsFolder())) {
            return;
        }
        m.status("Clearing all .sum files...");
        byte[] sumdata = sumfile.createEmptySumfile().getByteArray();
        for (File sumfile2 : FileUtils.FindAllFiles(Uam.getPotsFolder() + "/dat/", ".sum", false)) {
            FileUtils.WriteFile(sumfile2, sumdata);
        }
        m.status("Done!");
    }

    public static void TryToFindInstalledVersionsOfAllAges() {
        for (UamConfigNew.UamConfigData.Age age : ageList.getAllAges()) {
            String string = Uam.TryToFindInstalledVersionOfAge(age);
        }
    }

    public static String TryToFindInstalledVersionOfAge(String agename) {
        return Uam.TryToFindInstalledVersionOfAge(ageList.getAge(agename));
    }

    private static String TryToFindInstalledVersionOfAge(UamConfigNew.UamConfigData.Age age) {
        AgeInstallInfo info = installInfo.getAge(age.filename);
        if (info.installedVersion != null) {
            return info.installedVersion;
        }
        for (UamConfigNew.UamConfigData.Age.Version ver : age.versions) {
            boolean isinstalled;
            String archivefilename = Uam.getPotsFolder() + ageArchivesFolder + age.filename + versionSep + ver.name + ".7z";
            if (!FileUtils.Exists(archivefilename) || !(isinstalled = sevenzip.check(archivefilename, Uam.getPotsFolder(), new sevenzip.FileIncluder(){

                public boolean includeFile(String filename) {
                    return !filename.endsWith(".sum");
                }
            }))) continue;
            info.installedVersion = ver.name;
            return info.installedVersion;
        }
        return null;
    }

    public static void DeleteOldArchives() {
        if (!AllGames.getPots().isFolderX(Uam.getPotsFolder())) {
            return;
        }
        if (!Uam.HasPermissions(Uam.getPotsFolder())) {
            return;
        }
        if (ageList == null) {
            m.err("You need to load the Age List in the UAM tab first.");
            return;
        }
        if (!GuiUtils.getOKorCancelFromUser(m.trans("Are you sure you want to delete the old archives?"), m.trans("Delete the archives?"))) {
            return;
        }
        m.status("Detecting which versions are installed...");
        Uam.TryToFindInstalledVersionsOfAllAges();
        for (UamConfigNew.UamConfigData.Age age : ageList.getAllAges()) {
            AgeInstallInfo info = installInfo.getAge(age.filename);
            if (info.installationStatus.isInstalled()) {
                if (info.installedVersion != null) {
                    for (UamConfigNew.UamConfigData.Age.Version ver : age.versions) {
                        if (ver.name.equals(info.installedVersion)) continue;
                        Uam.DeleteArchive(age.filename, ver.name);
                    }
                    continue;
                }
                m.warn("Unable to detect installed version, so keeping archives for Age: ", age.filename);
                continue;
            }
            for (UamConfigNew.UamConfigData.Age.Version ver : age.versions) {
                Uam.DeleteArchive(age.filename, ver.name);
            }
        }
        m.status("Done!");
        UamGui.RefreshInfo();
    }

    private static void DeleteArchive(String agename, String version) {
        String f = Uam.getPotsFolder() + ageArchivesFolder + agename + versionSep + version + ".7z";
        if (FileUtils.Exists(f)) {
            FileUtils.DeleteFile2(f);
        }
    }

    public static Vector<String> GetAllAgeArchives() {
        if (!AllGames.getPots().isFolderX(Uam.getPotsFolder())) {
            return null;
        }
        Vector<String> r = new Vector<String>();
        File archivefolder = new File(Uam.getPotsFolder() + ageArchivesFolder);
        for (File file : archivefolder.listFiles()) {
            if (!file.isFile() || !file.getName().endsWith(".7z")) continue;
            r.add(file.getAbsolutePath());
        }
        return r;
    }

    public static String GetRandomAge() {
        if (ageList == null) {
            m.err("You need to load the Age List in the UAM tab first.");
            return "";
        }
        String[] fanages = new String[Uam.ageList.data.ages.size()];
        for (int i = 0; i < Uam.ageList.data.ages.size(); ++i) {
            fanages[i] = Uam.ageList.data.ages.get((int)i).propername;
        }
        String item = RandomUtils.GetRandomItem(ageLists.potsages, ageLists.convertedages, fanages);
        return item;
    }

    public static void RunTests(String potsfolder) {
        if (!AllGames.getPots().isFolderX(potsfolder)) {
            return;
        }
        boolean ignoreKnownOverrides = AllStates.getStateAsBoolean("uamig");
        Uam.HasPermissions(potsfolder);
        m.msg("Checking for python file duplicates...");
        HashMap pyfiles = new HashMap();
        Vector<File> pakfiles = FileUtils.FindAllFiles(potsfolder + "/Python/", ".pak", false);
        for (File f : pakfiles) {
            pakfile pak = new pakfile(f.getAbsolutePath(), AllGames.getPots().g, true);
            for (pakfile.IndexEntry ind : pak.indices) {
                String pyname = ind.objectname.toString();
                Vector paklist = (Vector)pyfiles.get(pyname);
                if (paklist == null) {
                    pyfiles.put(pyname, new Vector());
                    ((Vector)pyfiles.get(pyname)).add(f.getName());
                    continue;
                }
                ((Vector)pyfiles.get(pyname)).add(f.getName());
            }
        }
        for (String pyfile : pyfiles.keySet()) {
            Vector paklist = (Vector)pyfiles.get(pyfile);
            boolean complain = false;
            if (paklist.size() == 2) {
                if (!(ignoreKnownOverrides && (paklist.contains("moul.pak") || paklist.contains("offlineki.pak") || paklist.contains("UruLibraryManager.pak") || paklist.contains("tpots-fixes.pak") || paklist.contains("tpots-addons.pak")))) {
                    complain = true;
                }
            } else if (paklist.size() > 2) {
                complain = true;
            }
            if (!complain) continue;
            String complaint = "  The file " + pyfile + " was found in these files: ";
            for (String pakfile2 : paklist) {
                complaint = complaint + pakfile2 + ", ";
            }
            m.msg(complaint);
        }
        m.msg("Done checking for python file duplicates.");
        m.msg("Checking for sequence prefix duplicates...");
        HashMap<String, String> seqprefs = new HashMap<String, String>();
        Vector<File> agefiles = FileUtils.FindAllFiles(potsfolder + "/dat/", ".age", false);
        for (File f : agefiles) {
            textfile agefile = textfile.createFromBytes(UruCrypt.DecryptWhatdoyousee(FileUtils.ReadFile(f)));
            String seq = agefile.getVariable("SequencePrefix");
            if (seqprefs.containsKey(seq)) {
                m.msg("  Sequence Prefix from ", f.getName(), " already used in ", (String)seqprefs.get(seq));
                continue;
            }
            seqprefs.put(seq, f.getName());
        }
        m.msg("Done checking for sequence prefix duplicates.");
        m.msg("Checking for prps with duplicate page IDs...");
        HashMap<Pageid, String> pageids = new HashMap<Pageid, String>();
        Vector<File> prpfiles = FileUtils.FindAllFiles(potsfolder + "/dat/", ".prp", false);
        for (File f : prpfiles) {
            IBytestream c = SerialBytestream.createFromFile(f);
            PrpHeader header = new PrpHeader(c);
            if (pageids.containsKey(header.pageid)) {
                m.msg("  Pageid ", header.pageid.toString2(), " used in both ", f.getName(), " and ", (String)pageids.get(header.pageid));
                continue;
            }
            pageids.put(header.pageid, f.getName());
        }
        m.msg("Done checking for duplicate page IDs.");
        m.msg("Checking .sum files...");
        for (File f : FileUtils.FindAllFiles(potsfolder + "/dat/", ".sum", false)) {
            sumfile sf = sumfile.readFromFile(f, 3);
            for (sumfile.sumfileFileinfo sfi : sf.files) {
                String filename = potsfolder + "/" + sfi.filename.toString();
                if (FileUtils.Exists(filename)) {
                    byte[] expectedhash = sfi.md5;
                    byte[] actualhash = CryptHashes.GetHash(filename, CryptHashes.Hashtype.md5);
                    if (b.isEqual(actualhash, expectedhash)) continue;
                    m.msg("  File listed in ", f.getAbsolutePath(), " has the wrong hash: ", filename);
                    continue;
                }
                m.msg("  File listed in ", f.getAbsolutePath(), " was not found: ", filename);
            }
        }
        m.msg("Done checking .sum files.");
    }

    public static void launchUru() {
        if (Main.isVistaPlus()) {
            Exec.LaunchProgram(Uam.getPotsFolder() + "/" + "Uru.exe", "Uru");
        } else {
            Exec.LaunchProgram(Uam.getPotsFolder() + "/" + "UruSetup.exe", "Uru");
        }
    }

    public static void launchSoundDecompress() {
        Exec.LaunchProgram(Uam.getPotsFolder() + "/" + "SoundDecompress.exe", "SoundDecompress");
    }

    public static String getPotsFolder() {
        return AllStates.getStateAsString("uamRoot");
    }

    public static void listAvailableAges() {
        if (ageList == null) {
            m.msg("You have to get the list of available Ages first.");
            return;
        }
        for (UamConfigNew.UamConfigData.Age age : Uam.ageList.data.ages) {
            m.msg("Age: ", age.filename);
            for (UamConfigNew.UamConfigData.Age.Version ver : age.versions) {
                m.msg("  Ver: ", ver.name);
                for (UamConfigNew.UamConfigData.Age.Version.Mirror mir : ver.mirrors) {
                    m.msg("    Mir: ", mir.url);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InstallStatus {
        noVersionsExist,
        notInstalled,
        latestVersionInCache,
        nonLatestVersionInCache,
        notInCache;


        public boolean isInstalled() {
            return this != notInstalled && this != noVersionsExist;
        }
    }

    public static class AgeInstallInfo {
        public InstallStatus installationStatus = InstallStatus.notInstalled;
        public HashMap<String, InstallStatus> versions = new HashMap();
        public String installedVersion = null;
    }

    public static class InstallInfo {
        public HashMap<String, AgeInstallInfo> ages = new HashMap();
        public int numNotInstalled;
        public int numUnknown;
        public int numUpdatable;
        public boolean fullyUpToDate;

        public AgeInstallInfo getOrCreateAge(String age) {
            AgeInstallInfo result = this.ages.get(age);
            if (result == null) {
                result = new AgeInstallInfo();
                this.ages.put(age, result);
            }
            return result;
        }

        public AgeInstallInfo getAge(String age) {
            return this.ages.get(age);
        }

        public void countStats() {
            this.numNotInstalled = 0;
            this.numUnknown = 0;
            this.numUpdatable = 0;
            block7: for (AgeInstallInfo ageinfo : this.ages.values()) {
                switch (ageinfo.installationStatus) {
                    case latestVersionInCache: {
                        continue block7;
                    }
                    case noVersionsExist: {
                        continue block7;
                    }
                    case nonLatestVersionInCache: {
                        ++this.numUpdatable;
                        continue block7;
                    }
                    case notInCache: {
                        ++this.numUnknown;
                        continue block7;
                    }
                    case notInstalled: {
                        ++this.numNotInstalled;
                        continue block7;
                    }
                }
                m.err("Unhandled installation type.");
            }
            this.fullyUpToDate = this.numUnknown == 0 && this.numNotInstalled == 0 && this.numUpdatable == 0;
        }

        public void printStatsMessage() {
            this.countStats();
            if (this.fullyUpToDate) {
                m.msg("You have everything installed!");
            } else {
                Vector<String> result2 = new Vector<String>();
                if (this.numNotInstalled != 0) {
                    result2.add("Ages not installed: ");
                    result2.add(Integer.toString(this.numNotInstalled) + "    ");
                }
                if (this.numUpdatable != 0) {
                    result2.add("Ages updatable: ");
                    result2.add(Integer.toString(this.numUpdatable) + "    ");
                }
                if (this.numUnknown != 0) {
                    result2.add("Ages with unknown installation status: ");
                    result2.add(Integer.toString(this.numUnknown) + "    ");
                }
                m.msg((String[])generic.convertVectorToArray(result2, String.class));
            }
        }
    }
}

