/*
 * Decompiled with CFR 0.152.
 */
package uru;

import shared.Bytes;
import shared.IBytestream;
import shared.b;
import shared.m;
import shared.uncaughtexception;

public class Bytestream
extends IBytestream {
    private byte[] data;
    private int minpos;
    private int maxpos;
    private int pos;
    public boolean throwExceptionOnEof = false;

    public int getBytesRemaining() {
        throw new uncaughtexception("Haven't implemented GetBytesRemaining yet.");
    }

    public int getFilelength() {
        throw new uncaughtexception("Haven't implemented GetFileLength yet.");
    }

    public IBytestream Fork(long offset) {
        return new Bytestream(this, (int)offset);
    }

    public Bytestream(byte[] newData) {
        this.data = newData;
        int length = this.data.length;
        this.maxpos = length - 1;
        this.pos = 0;
    }

    private Bytestream() {
    }

    public boolean eof() {
        return this.pos > this.maxpos;
    }

    public static Bytestream createFromBytes(Bytes newData) {
        Bytestream result = new Bytestream();
        result.data = newData.getByteArray();
        int length = result.data.length;
        result.maxpos = length - 1;
        result.pos = 0;
        return result;
    }

    public static Bytestream createFromFilename(String filename) {
        return Bytestream.createFromBytes(Bytes.createFromFile(filename));
    }

    public Bytestream Fork() {
        return new Bytestream(this, this.pos);
    }

    public Bytestream Fork(int offset) {
        return new Bytestream(this, offset);
    }

    public Bytestream(Bytestream parent, int absoluteOffset) {
        this.data = parent.data;
        this.minpos = absoluteOffset;
        this.maxpos = this.data.length - 1;
        this.pos = this.minpos;
        if (this.minpos < 0 || this.maxpos + 1 > this.data.length) {
            m.msg("bytestream: maxpos is out of range.");
        }
    }

    public int getAbsoluteOffset() {
        return this.pos;
    }

    public int getNumBytesProcessed() {
        return this.pos - this.minpos;
    }

    public byte peekByte() {
        if (this.pos + 1 <= this.maxpos + 1) {
            return this.data[this.pos];
        }
        m.msg("end of file in readByte");
        return 0;
    }

    public short peekShort() {
        if (this.pos + 2 <= this.maxpos + 1) {
            return b.BytesToInt16(this.data, this.pos);
        }
        m.msg("end of file in readShort");
        return 0;
    }

    public int peekInt() {
        if (this.pos + 4 <= this.maxpos + 1) {
            return b.BytesToInt32(this.data, this.pos);
        }
        m.msg("end of file in readShort");
        return 0;
    }

    protected int read() {
        return b.ByteToInt32(this.readByte());
    }

    public byte readByte() {
        byte result = this.peekByte();
        ++this.pos;
        return result;
    }

    public short readShort() {
        short result = this.peekShort();
        this.pos += 2;
        return result;
    }

    public int readInt() {
        int result = this.peekInt();
        this.pos += 4;
        return result;
    }

    public byte[] readBytes(int num) {
        byte[] result = new byte[num];
        for (int i = 0; i < num; ++i) {
            result[i] = this.readByte();
        }
        return result;
    }

    public short[] readShorts(int num) {
        short[] result = new short[num];
        for (int i = 0; i < num; ++i) {
            result[i] = this.readShort();
        }
        return result;
    }

    public void skipBytes(int numToSkip) {
        if (this.pos + numToSkip <= this.maxpos + 1) {
            this.pos += numToSkip;
        } else {
            m.msg("end of file in readByte");
        }
    }

    public void skipShorts(int numToSkip) {
        if (this.pos + 2 * numToSkip <= this.maxpos + 1) {
            this.pos += 2 * numToSkip;
        } else {
            m.msg("end of file in readByte");
        }
    }

    public void skipInts(int numToSkip) {
        if (this.pos + 4 * numToSkip <= this.maxpos + 1) {
            this.pos += 4 * numToSkip;
        } else {
            m.msg("end of file in readByte");
        }
    }

    public void skipByte() {
        this.skipBytes(1);
    }

    public void skipShort() {
        this.skipShorts(1);
    }

    public void skipInt() {
        this.skipInts(1);
    }

    public String toString() {
        int readahead = 128;
        String result = "(pos=0x" + Integer.toHexString(this.pos) + "=" + Integer.toString(this.pos) + ")\n";
        result = result + "Data:\n";
        if (this.pos + readahead > this.maxpos + 1) {
            readahead = this.maxpos + 1 - this.pos;
        }
        for (int i = 0; i < readahead; ++i) {
            byte by = this.data[this.pos + i];
            String hex = Integer.toHexString(b.ByteToInt32(by));
            if (hex.length() == 0) {
                hex = "00";
            }
            if (hex.length() == 1) {
                hex = "0" + hex;
            }
            result = result + hex;
            if (i % 4 == 3) {
                result = result + " ";
            }
            if (i % 16 != 15) continue;
            result = result + "\n";
        }
        return result;
    }
}

