/*
 * Decompiled with CFR 0.152.
 */
package pythondec;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import pythondec.PyCode;
import pythondec.PyObject;
import pythondec.PyString;
import pythondec.PythonVersions;
import pythondec.op;
import shared.b;
import shared.m;

public class Disassemble {
    JumpInfo jumptable;
    public Vector<OpInfo> rv;

    public Disassemble(PyCode pycode, PythonVersions p) {
        PyString code = pycode.code;
        this.jumptable = new JumpInfo();
        this.rv = new Vector();
        int i = 0;
        while (i < code.rawstr.length) {
            int offset = i;
            byte c = code.rawstr[i];
            ++i;
            op o = op.get(c);
            OpInfo oo = new OpInfo(o, offset);
            if (o.hasArgument()) {
                byte b1 = code.rawstr[i];
                oo.i0 = b.ByteToInt32(b1);
                byte b2 = code.rawstr[++i];
                ++i;
                oo.i1 = b.ByteToInt32(b2);
                oo.oparg = b.BytesToInt32(b1, b2, (byte)0, (byte)0);
                int extended_arg = 0;
                if (o == op.EXTENDED_ARG) {
                    extended_arg = oo.oparg << 16;
                    m.throwUncaughtException("Unhandled.");
                }
                if (o.hasConst()) {
                    PyObject const1 = pycode.consts.items[oo.oparg];
                    oo.pattr = const1 instanceof PyCode ? const1 : const1;
                } else if (o.hasName()) {
                    oo.pattr = pycode.names.items[oo.oparg];
                } else if (o.hasJrel()) {
                    oo.pointerDest = i + oo.oparg;
                    this.jumptable.from1to2.put(oo.offset, oo.pointerDest);
                    oo.pattr = Integer.toString(oo.pointerDest);
                } else if (o.hasJabs()) {
                    oo.pointerDest = oo.oparg;
                    this.jumptable.from1to2.put(oo.offset, oo.pointerDest);
                    oo.pattr = Integer.toString(oo.pointerDest);
                } else if (o.hasLocal()) {
                    oo.pattr = pycode.varnames.items[oo.oparg];
                } else if (o.hasCompare()) {
                    oo.pattr = p.cmp_ops()[oo.oparg];
                } else if (o.hasFree()) {
                    oo.pattr = oo.oparg < pycode.cellvars.items.length ? pycode.cellvars.items[oo.oparg] : pycode.freevars.items[oo.oparg - pycode.cellvars.items.length];
                }
            }
            this.rv.add(oo);
        }
        this.jumptable.finishup();
        this.jumptable.finishup2(this.rv);
    }

    public void printTokens() {
        for (OpInfo oi : this.rv) {
            m.msg(oi.toDebugString());
        }
    }

    JumpInfo find_jumps(PyString s) {
        JumpInfo result = new JumpInfo();
        int i = 0;
        while (i < s.rawstr.length) {
            int label;
            int offset = i;
            byte c = s.rawstr[i];
            ++i;
            op o = op.get(c);
            if (o == null) {
                boolean dummy = false;
            }
            if (!o.hasArgument()) continue;
            byte b1 = s.rawstr[i];
            byte b2 = s.rawstr[++i];
            ++i;
            int oparg = b.BytesToInt32(b1, b2, (byte)0, (byte)0);
            if (o.hasJrel()) {
                label = i + oparg;
                result.from1to2.put(offset, label);
            }
            if (!o.hasJabs()) continue;
            label = oparg;
            result.from1to2.put(offset, label);
        }
        result.finishup();
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JumpInfo {
        HashMap<Integer, Integer> from1to2 = new HashMap();
        HashMap<Integer, ArrayList<Integer>> from2to1 = new HashMap();

        public void finishup() {
            for (Map.Entry<Integer, Integer> entry : this.from1to2.entrySet()) {
                Integer key = entry.getKey();
                Integer val = entry.getValue();
                ArrayList<Integer> refs = this.from2to1.get(val);
                if (refs == null) {
                    refs = new ArrayList();
                    this.from2to1.put(val, refs);
                }
                refs.add(key);
            }
        }

        public void finishup2(Vector<OpInfo> rv) {
            for (OpInfo oi : rv) {
                ArrayList<Integer> refs = this.from2to1.get(oi.offset);
                oi.pointerSources = refs;
            }
        }
    }

    public static class OpInfo {
        public op o;
        public int offset;
        public Integer i0;
        public Integer i1;
        public Integer oparg;
        public Object pattr;
        public Integer pointerDest;
        public ArrayList<Integer> pointerSources;

        public OpInfo(op o, Integer i0, Integer i1, Integer oparg, Object pattr, int offset) {
            this.o = o;
            this.i0 = i0;
            this.i1 = i1;
            this.oparg = oparg;
            this.pattr = pattr;
            this.offset = offset;
        }

        public OpInfo(op o, int offset) {
            this.o = o;
            this.offset = offset;
        }

        public static OpInfo create(op o) {
            return new OpInfo(o, -1);
        }

        public static OpInfo create(op o, int arg) {
            OpInfo o2 = new OpInfo(o, -1);
            o2.setArg(arg);
            return o2;
        }

        public String toString() {
            return this.o.toString();
        }

        public String toDebugString() {
            return this.o.toString() + " arg:" + (this.oparg != null ? this.oparg.toString() : "") + " pattr:" + (this.pattr != null ? this.pattr.toString() : "") + " offset:" + Integer.toString(this.offset);
        }

        public void setArg(int arg) {
            this.oparg = arg;
            this.i0 = b.getByte0(arg);
            this.i1 = b.getByte1(arg);
        }

        public boolean compare(OpInfo o2) {
            PyObject pa2;
            PyObject pa;
            if (o2 == null) {
                return false;
            }
            if (this.o != o2.o) {
                return false;
            }
            return !this.o.hasArgument() || this.o.hasJabs() || this.o.hasJrel() || !(this.o.hasCompare() ? !this.oparg.equals(o2.oparg) : (this.o.hasConst() || this.o.hasFree() || this.o.hasLocal() || this.o.hasName() ? !(pa = (PyObject)this.pattr).compare(pa2 = (PyObject)o2.pattr) : !this.oparg.equals(o2.oparg)));
        }
    }
}

