/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.gui.layer.geoimage.ImageEntry;
import org.openstreetmap.josm.gui.layer.geoimage.WikimediaCommonsEntry;
import org.openstreetmap.josm.gui.layer.geoimage.WikimediaCommonsLayer;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Mediawiki;
import org.xml.sax.SAXException;

public class WikimediaCommonsLoader
extends PleaseWaitRunnable {
    protected String apiUrl = "https://commons.wikimedia.org/w/api.php";
    protected GeoImageLayer layer;
    private final Bounds bounds;

    public WikimediaCommonsLoader(Bounds bounds) {
        super(I18n.tr("Load images from Wikimedia Commons", new Object[0]));
        this.bounds = bounds;
    }

    @Override
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        ArrayList<ImageEntry> imageEntries = new ArrayList<ImageEntry>();
        try {
            new Mediawiki(this.apiUrl).searchGeoImages(this.bounds, (title, latLon) -> imageEntries.add(new WikimediaCommonsEntry((String)title, (LatLon)latLon)));
        }
        catch (ParserConfigurationException | XPathExpressionException e) {
            throw new IllegalStateException(e);
        }
        Logging.info("Loaded {0} images from Wikimedia Commons", imageEntries.size());
        this.layer = new WikimediaCommonsLayer(imageEntries);
    }

    @Override
    protected void finish() {
        MainApplication.getLayerManager().addLayer(this.layer);
    }

    @Override
    protected void cancel() {
    }

    public static class Action
    extends JosmAction {
        public Action() {
            super(I18n.tr("Load images from Wikimedia Commons", new Object[0]), "wikimedia_commons", null, null, false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Bounds bounds = MainApplication.getMap().mapView.getRealBounds();
            MainApplication.worker.execute(new WikimediaCommonsLoader(bounds));
        }

        @Override
        protected void updateEnabledState() {
            this.setEnabled(MainApplication.isDisplayingMapView());
        }
    }
}

