/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.download.overpass;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.openstreetmap.josm.gui.download.OverpassQueryWizardDialog;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public final class OverpassWizardRegistration {
    private static final List<Function<OverpassWizardCallbacks, Action>> wizards = Collections.synchronizedList(new ArrayList());

    public static void registerWizard(Function<OverpassWizardCallbacks, Action> wizard) {
        Objects.requireNonNull(wizard, "wizard");
        wizards.add(wizard);
    }

    public static List<Action> getWizards(OverpassWizardCallbacks callbacks) {
        return wizards.stream().map(x -> (Action)x.apply(callbacks)).collect(Collectors.toList());
    }

    private OverpassWizardRegistration() {
    }

    static {
        OverpassWizardRegistration.registerWizard(callbacks -> new AbstractAction(I18n.tr("Query Wizard", new Object[0]), (OverpassWizardCallbacks)callbacks){
            final /* synthetic */ OverpassWizardCallbacks val$callbacks;
            {
                this.val$callbacks = overpassWizardCallbacks;
                super(arg0);
                this.putValue("ShortDescription", I18n.tr("Build an Overpass query using the query wizard", new Object[0]));
                new ImageProvider("dialogs/magic-wand").getResource().attachImageIcon(this, true);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                new OverpassQueryWizardDialog(this.val$callbacks).showDialog();
            }
        });
    }

    public static interface OverpassWizardCallbacks {
        public void submitWizardResult(String var1);

        public Component getParent();
    }
}

