/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.tagging.ac;

import java.util.Objects;

public class AutoCompletionPriority
implements Comparable<AutoCompletionPriority> {
    public static final AutoCompletionPriority IS_IN_STANDARD_AND_IN_DATASET = new AutoCompletionPriority(true, true, false);
    public static final AutoCompletionPriority IS_IN_DATASET = new AutoCompletionPriority(true, false, false);
    public static final AutoCompletionPriority IS_IN_STANDARD = new AutoCompletionPriority(false, true, false);
    public static final AutoCompletionPriority IS_IN_SELECTION = new AutoCompletionPriority(false, false, true);
    public static final AutoCompletionPriority UNKNOWN = new AutoCompletionPriority(false, false, false);
    private static final int NO_USER_INPUT = Integer.MAX_VALUE;
    private final int userInput;
    private final boolean inDataSet;
    private final boolean inStandard;
    private final boolean selected;

    public AutoCompletionPriority(boolean inDataSet, boolean inStandard, boolean selected, Integer userInput) {
        this.inDataSet = inDataSet;
        this.inStandard = inStandard;
        this.selected = selected;
        this.userInput = userInput == null ? Integer.MAX_VALUE : userInput;
    }

    public AutoCompletionPriority(boolean inDataSet, boolean inStandard, boolean selected) {
        this(inDataSet, inStandard, selected, Integer.MAX_VALUE);
    }

    public boolean isInDataSet() {
        return this.inDataSet;
    }

    public boolean isInStandard() {
        return this.inStandard;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public Integer getUserInput() {
        return this.userInput == Integer.MAX_VALUE ? null : Integer.valueOf(this.userInput);
    }

    @Override
    public int compareTo(AutoCompletionPriority other) {
        int ui = Integer.compare(other.userInput, this.userInput);
        if (ui != 0) {
            return ui;
        }
        int sel = Boolean.compare(this.selected, other.selected);
        if (sel != 0) {
            return sel;
        }
        int ds = Boolean.compare(this.inDataSet, other.inDataSet);
        if (ds != 0) {
            return ds;
        }
        return Boolean.compare(this.inStandard, other.inStandard);
    }

    public AutoCompletionPriority mergeWith(AutoCompletionPriority other) {
        return new AutoCompletionPriority(this.inDataSet || other.inDataSet, this.inStandard || other.inStandard, this.selected || other.selected, Math.min(this.userInput, other.userInput));
    }

    public int hashCode() {
        return Objects.hash(this.inDataSet, this.inStandard, this.selected, this.userInput);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AutoCompletionPriority other = (AutoCompletionPriority)obj;
        return this.inDataSet == other.inDataSet && this.inStandard == other.inStandard && this.selected == other.selected && this.userInput == other.userInput;
    }

    public String toString() {
        return String.format("<Priority; userInput: %s, inDataSet: %b, inStandard: %b, selected: %b>", this.userInput == Integer.MAX_VALUE ? "no" : Integer.toString(this.userInput), this.inDataSet, this.inStandard, this.selected);
    }
}

