/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.PolarCoor;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;

public final class AlignInLineAction
extends JosmAction {
    public AlignInLineAction() {
        super(I18n.tr("Align Nodes in Line", new Object[0]), "alignline", I18n.tr("Move the selected nodes in to a line.", new Object[0]), Shortcut.registerShortcut("tools:alignline", I18n.tr("Tools: {0}", I18n.tr("Align Nodes in Line", new Object[0])), 76, 5003), true);
        this.setHelpId(HelpUtil.ht("/Action/AlignInLine"));
    }

    private static Node[] nodePairFurthestApart(List<Node> nodes) {
        HashSet<Way> waysRef = null;
        for (Node n : nodes) {
            List<Way> ref = n.getParentWays();
            if (waysRef == null) {
                waysRef = new HashSet<Way>(ref);
                continue;
            }
            waysRef.retainAll(ref);
        }
        if (waysRef == null) {
            throw new IllegalArgumentException();
        }
        if (waysRef.size() != 1) {
            return AlignInLineAction.nodeFurthestAppart(nodes);
        }
        Way way = (Way)waysRef.iterator().next();
        if (way.isClosed()) {
            return AlignInLineAction.nodeFurthestAppart(nodes);
        }
        Node nodea = null;
        Node nodeb = null;
        HashSet<Node> remainNodes = new HashSet<Node>(nodes);
        for (Node n : way.getNodes()) {
            if (!remainNodes.contains(n)) continue;
            if (nodea == null) {
                nodea = n;
            }
            if (remainNodes.size() == 1) {
                nodeb = (Node)remainNodes.iterator().next();
                break;
            }
            remainNodes.remove(n);
        }
        return new Node[]{nodea, nodeb};
    }

    private static Node[] nodeFurthestAppart(List<Node> nodes) {
        Node node1 = null;
        Node node2 = null;
        double minSqDistance = 0.0;
        int nb = nodes.size();
        for (int i = 0; i < nb - 1; ++i) {
            Node n = nodes.get(i);
            for (int j = i + 1; j < nb; ++j) {
                Node m = nodes.get(j);
                double sqDist = n.getEastNorth().distanceSq(m.getEastNorth());
                if (!(sqDist > minSqDistance)) continue;
                node1 = n;
                node2 = m;
                minSqDistance = sqDist;
            }
        }
        return new Node[]{node1, node2};
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        try {
            Command cmd = this.buildCommand(this.getLayerManager().getEditDataSet());
            if (cmd != null) {
                UndoRedoHandler.getInstance().add(cmd);
            }
        }
        catch (InvalidSelection except) {
            Logging.debug(except);
            new Notification(except.getMessage()).setIcon(1).show();
        }
    }

    public Command buildCommand(DataSet ds) throws InvalidSelection {
        ArrayList<Node> selectedNodes = new ArrayList<Node>(ds.getSelectedNodes());
        ArrayList<Way> selectedWays = new ArrayList<Way>(ds.getSelectedWays());
        selectedWays.removeIf(w -> w.isIncomplete() || w.isEmpty());
        if (selectedNodes.isEmpty() && !selectedWays.isEmpty()) {
            return AlignInLineAction.alignMultiWay(selectedWays);
        }
        if (selectedNodes.size() == 1) {
            List<Way> involvedWays;
            Node selectedNode = (Node)selectedNodes.get(0);
            List<Line> lines = AlignInLineAction.getInvolvedLines(selectedNode, involvedWays = selectedWays.isEmpty() ? selectedNode.getParentWays() : selectedWays);
            if (lines.size() > 2 || lines.isEmpty()) {
                throw new InvalidSelection();
            }
            return AlignInLineAction.alignSingleNode((Node)selectedNodes.get(0), lines);
        }
        if (selectedNodes.size() >= 3) {
            return AlignInLineAction.alignOnlyNodes(selectedNodes);
        }
        throw new InvalidSelection();
    }

    private static Command alignOnlyNodes(List<Node> nodes) throws InvalidSelection {
        Node[] anchors = AlignInLineAction.nodePairFurthestApart(nodes);
        Line line = new Line(anchors[0], anchors[1]);
        Collection cmds = nodes.stream().filter(node -> node != anchors[0] && node != anchors[1]).map(line::projectionCommand).collect(Collectors.toList());
        return new SequenceCommand(I18n.tr("Align Nodes in Line", new Object[0]), cmds);
    }

    private static Command alignMultiWay(Collection<Way> ways) throws InvalidSelection {
        HashSet<Node> nodes = new HashSet<Node>();
        HashMap<Way, Line> lines = new HashMap<Way, Line>();
        for (Way w : ways) {
            if (w.isClosed()) {
                throw new InvalidSelection(I18n.tr("Can not align a polygon. Abort.", new Object[0]));
            }
            if (w.isEmpty()) continue;
            nodes.addAll(w.getNodes());
            lines.put(w, new Line(w));
        }
        if (nodes.isEmpty()) {
            throw new InvalidSelection(I18n.tr("Intersection of three or more ways can not be solved. Abort.", new Object[0]));
        }
        ArrayList<Command> cmds = new ArrayList<Command>(nodes.size());
        ArrayList<Way> referrers = new ArrayList<Way>(ways.size());
        for (Node n : nodes) {
            referrers.clear();
            for (OsmPrimitive o : n.getReferrers()) {
                if (!ways.contains(o)) continue;
                referrers.add((Way)o);
            }
            if (referrers.size() == 1) {
                Way way = (Way)referrers.get(0);
                if (way.isFirstLastNode(n)) continue;
                cmds.add(((Line)lines.get(way)).projectionCommand(n));
                continue;
            }
            if (referrers.size() == 2) {
                cmds.add(((Line)lines.get(referrers.get(0))).intersectionCommand(n, (Line)lines.get(referrers.get(1))));
                continue;
            }
            throw new InvalidSelection(I18n.tr("Intersection of three or more ways can not be solved. Abort.", new Object[0]));
        }
        return cmds.isEmpty() ? null : new SequenceCommand(I18n.tr("Align Nodes in Line", new Object[0]), cmds);
    }

    private static List<Line> getInvolvedLines(Node node, List<Way> refWays) throws InvalidSelection {
        ArrayList<Line> lines = new ArrayList<Line>();
        ArrayList<Node> neighbors = new ArrayList<Node>();
        for (Way way : refWays) {
            List<Node> nodes = way.getNodes();
            neighbors.clear();
            for (int i2 = 1; i2 < nodes.size() - 1; ++i2) {
                if (nodes.get(i2) != node) continue;
                neighbors.add(nodes.get(i2 - 1));
                neighbors.add(nodes.get(i2 + 1));
            }
            if (neighbors.isEmpty()) continue;
            if (neighbors.size() == 2) {
                lines.add(new Line((Node)neighbors.get(0), (Node)neighbors.get(1)));
                continue;
            }
            if (neighbors.size() == 4) {
                EastNorth c = node.getEastNorth();
                double[] angle = IntStream.range(0, 4).mapToDouble(i -> PolarCoor.computeAngle(((Node)neighbors.get(i)).getEastNorth(), c)).toArray();
                double[] deltaAngle = new double[3];
                for (int i3 = 0; i3 < 3; ++i3) {
                    deltaAngle[i3] = angle[i3 + 1] - angle[0];
                    if (!(deltaAngle[i3] < 0.0)) continue;
                    int n = i3;
                    deltaAngle[n] = deltaAngle[n] + Math.PI * 2;
                }
                int nb = 0;
                if (deltaAngle[1] < deltaAngle[0]) {
                    ++nb;
                }
                if (deltaAngle[2] < deltaAngle[0]) {
                    ++nb;
                }
                if (nb == 1) {
                    lines.add(new Line((Node)neighbors.get(0), (Node)neighbors.get(1)));
                    lines.add(new Line((Node)neighbors.get(2), (Node)neighbors.get(3)));
                    continue;
                }
                lines.add(new Line((Node)neighbors.get(0), (Node)neighbors.get(2)));
                lines.add(new Line((Node)neighbors.get(1), (Node)neighbors.get(3)));
                continue;
            }
            throw new InvalidSelection("cannot treat more than 4 neighbours, got " + neighbors.size());
        }
        return lines;
    }

    private static Command alignSingleNode(Node node, List<Line> lines) throws InvalidSelection {
        if (lines.size() == 1) {
            return lines.get(0).projectionCommand(node);
        }
        if (lines.size() == 2) {
            return lines.get(0).intersectionCommand(node, lines.get(1));
        }
        throw new InvalidSelection();
    }

    @Override
    protected void updateEnabledState() {
        DataSet ds = this.getLayerManager().getEditDataSet();
        this.setEnabled(ds != null && !ds.selectionEmpty());
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.updateEnabledStateOnModifiableSelection(selection);
    }

    static class InvalidSelection
    extends Exception {
        InvalidSelection() {
            super(I18n.tr("Please select at least three nodes.", new Object[0]));
        }

        InvalidSelection(String msg) {
            super(msg);
        }
    }

    static class Line {
        private double a;
        private double b;
        private final double c;
        private final double xM;
        private final double yM;

        Line(Node first, Node last) throws InvalidSelection {
            this.xM = first.getEastNorth().getX();
            this.yM = first.getEastNorth().getY();
            double xB = last.getEastNorth().getX();
            double yB = last.getEastNorth().getY();
            this.a = yB - this.yM;
            this.b = this.xM - xB;
            double norm = Math.sqrt(this.a * this.a + this.b * this.b);
            if (norm == 0.0) {
                throw new InvalidSelection("Nodes have same coordinates!");
            }
            this.a /= norm;
            this.b /= norm;
            this.c = -(this.a * this.xM + this.b * this.yM);
        }

        Line(Way way) throws InvalidSelection {
            this(way.firstNode(), way.lastNode());
        }

        public Command projectionCommand(Node n) {
            double s = (this.xM - n.getEastNorth().getX()) * this.a + (this.yM - n.getEastNorth().getY()) * this.b;
            return new MoveCommand((OsmPrimitive)n, this.a * s, this.b * s);
        }

        public Command intersectionCommand(Node n, Line other) throws InvalidSelection {
            double d = this.a * other.b - other.a * this.b;
            if (Math.abs(d) < 1.0E-5) {
                throw new InvalidSelection(I18n.tr("Two parallels ways found. Abort.", new Object[0]));
            }
            double x = (this.b * other.c - other.b * this.c) / d;
            double y = (other.a * this.c - this.a * other.c) / d;
            return new MoveCommand((OsmPrimitive)n, x - n.getEastNorth().getX(), y - n.getEastNorth().getY());
        }
    }
}

