/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.oauth;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.html.HTMLEditorKit;
import org.openstreetmap.josm.data.oauth.OAuthAccessTokenHolder;
import org.openstreetmap.josm.data.oauth.OAuthParameters;
import org.openstreetmap.josm.data.oauth.OAuthToken;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.oauth.AbstractAuthorizationUI;
import org.openstreetmap.josm.gui.oauth.AuthorizationProcedure;
import org.openstreetmap.josm.gui.oauth.FullyAutomaticAuthorizationUI;
import org.openstreetmap.josm.gui.oauth.ManualAuthorizationUI;
import org.openstreetmap.josm.gui.oauth.SemiAutomaticAuthorizationUI;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.WindowGeometry;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;
import org.openstreetmap.josm.tools.UserCancelException;
import org.openstreetmap.josm.tools.Utils;

public class OAuthAuthorizationWizard
extends JDialog {
    private boolean canceled;
    private final AuthorizationProcedure procedure;
    private final String apiUrl;
    private FullyAutomaticAuthorizationUI pnlFullyAutomaticAuthorisationUI;
    private SemiAutomaticAuthorizationUI pnlSemiAutomaticAuthorisationUI;
    private ManualAuthorizationUI pnlManualAuthorisationUI;
    private JScrollPane spAuthorisationProcedureUI;
    private final transient Executor executor;

    public void showDialog() throws UserCancelException {
        this.setVisible(true);
        if (this.isCanceled()) {
            throw new UserCancelException();
        }
        OAuthAccessTokenHolder holder = OAuthAccessTokenHolder.getInstance();
        holder.setAccessToken(this.getAccessToken());
        holder.setSaveToPreferences(this.isSaveAccessTokenToPreferences());
    }

    protected JPanel buildButtonRow() {
        JPanel pnl = new JPanel(new FlowLayout(1));
        AcceptAccessTokenAction actAcceptAccessToken = new AcceptAccessTokenAction();
        this.pnlFullyAutomaticAuthorisationUI.addPropertyChangeListener(actAcceptAccessToken);
        this.pnlSemiAutomaticAuthorisationUI.addPropertyChangeListener(actAcceptAccessToken);
        this.pnlManualAuthorisationUI.addPropertyChangeListener(actAcceptAccessToken);
        pnl.add(new JButton(actAcceptAccessToken));
        pnl.add(new JButton(new CancelAction()));
        pnl.add(new JButton(new ContextSensitiveHelpAction(HelpUtil.ht("/Dialog/OAuthAuthorisationWizard"))));
        return pnl;
    }

    protected JPanel buildHeaderInfoPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        pnl.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        HtmlPanel pnlMessage = new HtmlPanel();
        pnlMessage.setText("<html><body>" + I18n.tr("With OAuth you grant JOSM the right to upload map data and GPS tracks on your behalf (<a href=\"{0}\">more info...</a>).", "https://wiki.openstreetmap.org/wiki/OAuth") + "</body></html>");
        pnlMessage.enableClickableHyperlinks();
        pnl.add((Component)pnlMessage, GBC.eol().fill(2));
        JMultilineLabel lbl = new JMultilineLabel(AuthorizationProcedure.FULLY_AUTOMATIC.getDescription());
        lbl.setFont(lbl.getFont().deriveFont(0));
        pnl.add((Component)lbl, GBC.std());
        if (!Config.getUrls().getDefaultOsmApiUrl().equals(this.apiUrl)) {
            HtmlPanel pnlWarning = new HtmlPanel();
            HTMLEditorKit kit = (HTMLEditorKit)pnlWarning.getEditorPane().getEditorKit();
            kit.getStyleSheet().addRule(".warning-body {background-color:rgb(253,255,221);padding: 10pt; border-color:rgb(128,128,128);border-style: solid;border-width: 1px;}");
            kit.getStyleSheet().addRule("ol {margin-left: 1cm}");
            pnlWarning.setText("<html><body><p class=\"warning-body\">" + I18n.tr("<strong>Warning:</strong> Since you are using not the default OSM API, make sure to set an OAuth consumer key and secret in the <i>Advanced OAuth parameters</i>.", new Object[0]) + "</p></body></html>");
            pnl.add((Component)pnlWarning, GBC.eop().fill());
        }
        return pnl;
    }

    protected void refreshAuthorisationProcedurePanel() {
        switch (this.procedure) {
            case FULLY_AUTOMATIC: {
                this.spAuthorisationProcedureUI.getViewport().setView(this.pnlFullyAutomaticAuthorisationUI);
                this.pnlFullyAutomaticAuthorisationUI.revalidate();
                break;
            }
            case SEMI_AUTOMATIC: {
                this.spAuthorisationProcedureUI.getViewport().setView(this.pnlSemiAutomaticAuthorisationUI);
                this.pnlSemiAutomaticAuthorisationUI.revalidate();
                break;
            }
            case MANUALLY: {
                this.spAuthorisationProcedureUI.getViewport().setView(this.pnlManualAuthorisationUI);
                this.pnlManualAuthorisationUI.revalidate();
            }
        }
        this.validate();
        this.repaint();
    }

    protected final void build() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.buildHeaderInfoPanel(), "North");
        this.setTitle(I18n.tr("Get an Access Token for ''{0}''", this.apiUrl));
        this.setMinimumSize(new Dimension(500, 300));
        this.pnlFullyAutomaticAuthorisationUI = new FullyAutomaticAuthorizationUI(this.apiUrl, this.executor);
        this.pnlSemiAutomaticAuthorisationUI = new SemiAutomaticAuthorizationUI(this.apiUrl, this.executor);
        this.pnlManualAuthorisationUI = new ManualAuthorizationUI(this.apiUrl, this.executor);
        this.spAuthorisationProcedureUI = GuiHelper.embedInVerticalScrollPane(new JPanel());
        this.spAuthorisationProcedureUI.getVerticalScrollBar().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                OAuthAuthorizationWizard.this.spAuthorisationProcedureUI.setBorder(UIManager.getBorder("ScrollPane.border"));
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                OAuthAuthorizationWizard.this.spAuthorisationProcedureUI.setBorder(null);
            }
        });
        this.getContentPane().add((Component)this.spAuthorisationProcedureUI, "Center");
        this.getContentPane().add((Component)this.buildButtonRow(), "South");
        this.addWindowListener(new WindowEventHandler());
        InputMapUtils.addEscapeAction(this.getRootPane(), new CancelAction());
        this.refreshAuthorisationProcedurePanel();
        HelpUtil.setHelpContext(this.getRootPane(), HelpUtil.ht("/Dialog/OAuthAuthorisationWizard"));
    }

    public OAuthAuthorizationWizard(Component parent, AuthorizationProcedure procedure, String apiUrl, Executor executor) {
        super((Window)GuiHelper.getFrameForComponent(parent), Dialog.ModalityType.DOCUMENT_MODAL);
        this.procedure = Objects.requireNonNull(procedure, "procedure");
        this.apiUrl = Objects.requireNonNull(apiUrl, "apiUrl");
        this.executor = executor;
        this.build();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    protected AbstractAuthorizationUI getCurrentAuthorisationUI() {
        switch (this.procedure) {
            case FULLY_AUTOMATIC: {
                return this.pnlFullyAutomaticAuthorisationUI;
            }
            case MANUALLY: {
                return this.pnlManualAuthorisationUI;
            }
            case SEMI_AUTOMATIC: {
                return this.pnlSemiAutomaticAuthorisationUI;
            }
        }
        return null;
    }

    public OAuthToken getAccessToken() {
        return this.getCurrentAuthorisationUI().getAccessToken();
    }

    public OAuthParameters getOAuthParameters() {
        return (OAuthParameters)this.getCurrentAuthorisationUI().getOAuthParameters();
    }

    public boolean isSaveAccessTokenToPreferences() {
        return this.getCurrentAuthorisationUI().isSaveAccessTokenToPreferences();
    }

    public void initFromPreferences() {
        this.pnlFullyAutomaticAuthorisationUI.initialize(this.apiUrl);
        this.pnlSemiAutomaticAuthorisationUI.initialize(this.apiUrl);
        this.pnlManualAuthorisationUI.initialize(this.apiUrl);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.pack();
            new WindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(MainApplication.getMainFrame(), this.getPreferredSize())).applySafe(this);
            this.initFromPreferences();
        } else if (this.isShowing()) {
            new WindowGeometry(this).remember(this.getClass().getName() + ".geometry");
        }
        super.setVisible(visible);
    }

    protected void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public static void obtainAccessToken(URL serverUrl) throws InvocationTargetException, InterruptedException {
        FutureTask<OAuthAuthorizationWizard> authTask = new FutureTask<OAuthAuthorizationWizard>(() -> {
            OAuthAuthorizationWizard wizard = new OAuthAuthorizationWizard((Component)MainApplication.getMainFrame(), AuthorizationProcedure.FULLY_AUTOMATIC, serverUrl.toExternalForm(), Utils.newDirectExecutor());
            wizard.showDialog();
            return wizard;
        });
        if (SwingUtilities.isEventDispatchThread()) {
            authTask.run();
        } else {
            SwingUtilities.invokeAndWait(authTask);
        }
    }

    class AcceptAccessTokenAction
    extends AbstractAction
    implements PropertyChangeListener {
        AcceptAccessTokenAction() {
            this.putValue("Name", I18n.tr("Accept Access Token", new Object[0]));
            new ImageProvider("ok").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Close the dialog and accept the Access Token", new Object[0]));
            this.updateEnabledState(null);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            OAuthAuthorizationWizard.this.setCanceled(false);
            OAuthAuthorizationWizard.this.setVisible(false);
        }

        public final void updateEnabledState(OAuthToken token) {
            this.setEnabled(token != null);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!evt.getPropertyName().equals(AbstractAuthorizationUI.ACCESS_TOKEN_PROP)) {
                return;
            }
            this.updateEnabledState((OAuthToken)evt.getNewValue());
        }
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", I18n.tr("Cancel", new Object[0]));
            new ImageProvider("cancel").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Close the dialog and cancel authorization", new Object[0]));
        }

        public void cancel() {
            OAuthAuthorizationWizard.this.setCanceled(true);
            OAuthAuthorizationWizard.this.setVisible(false);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.cancel();
        }
    }

    class WindowEventHandler
    extends WindowAdapter {
        WindowEventHandler() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            new CancelAction().cancel();
        }
    }
}

