/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.gui.jmapviewer.FeatureAdapter;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;

public final class ImageryPatterns {
    static final Pattern PATTERN_HEADER = Pattern.compile("\\{header\\(([^,]+),([^}]+)\\)\\}");
    static final Pattern PATTERN_PROJ = Pattern.compile("\\{proj\\}");
    static final Pattern PATTERN_WKID = Pattern.compile("\\{wkid\\}");
    static final Pattern PATTERN_BBOX = Pattern.compile("\\{bbox\\}");
    static final Pattern PATTERN_W = Pattern.compile("\\{w\\}");
    static final Pattern PATTERN_S = Pattern.compile("\\{s\\}");
    static final Pattern PATTERN_E = Pattern.compile("\\{e\\}");
    static final Pattern PATTERN_N = Pattern.compile("\\{n\\}");
    static final Pattern PATTERN_WIDTH = Pattern.compile("\\{width\\}");
    static final Pattern PATTERN_HEIGHT = Pattern.compile("\\{height\\}");
    static final Pattern PATTERN_TIME = Pattern.compile("\\{time\\}");
    static final Pattern PATTERN_PARAM = Pattern.compile("\\{([^}]+)\\}");
    static final Pattern PATTERN_API_KEY = Pattern.compile("\\{apikey}");
    private static final Pattern[] ALL_WMS_PATTERNS = new Pattern[]{PATTERN_HEADER, PATTERN_PROJ, PATTERN_WKID, PATTERN_BBOX, PATTERN_W, PATTERN_S, PATTERN_E, PATTERN_N, PATTERN_WIDTH, PATTERN_HEIGHT, PATTERN_TIME, PATTERN_API_KEY};
    private static final Pattern[] ALL_WMTS_PATTERNS = new Pattern[]{PATTERN_HEADER, PATTERN_API_KEY};

    private ImageryPatterns() {
    }

    private static void checkUrlPatterns(String url, Pattern[] allPatterns, String errMessage) {
        Matcher m = PATTERN_PARAM.matcher(Objects.requireNonNull(url, "url"));
        while (m.find()) {
            if (!Arrays.stream(allPatterns).noneMatch(pattern -> pattern.matcher(m.group()).matches())) continue;
            throw new IllegalArgumentException(I18n.tr(errMessage, m.group(), url));
        }
    }

    static void checkWmsUrlPatterns(String url) {
        ImageryPatterns.checkUrlPatterns(url, ALL_WMS_PATTERNS, I18n.marktr("{0} is not a valid WMS argument. Please check this server URL:\n{1}"));
    }

    static void checkWmtsUrlPatterns(String url) {
        ImageryPatterns.checkUrlPatterns(url, ALL_WMTS_PATTERNS, I18n.marktr("{0} is not a valid WMTS argument. Please check this server URL:\n{1}"));
    }

    static String handleHeaderTemplate(String url, Map<String, String> headers) {
        StringBuffer output = new StringBuffer();
        Matcher matcher = PATTERN_HEADER.matcher(url);
        while (matcher.find()) {
            headers.put(matcher.group(1), matcher.group(2));
            matcher.appendReplacement(output, "");
        }
        matcher.appendTail(output);
        return output.toString();
    }

    static String handleApiKeyTemplate(String id, String url) {
        Matcher matcher;
        if (id != null && url != null && (matcher = PATTERN_API_KEY.matcher(url)).find()) {
            try {
                return Optional.ofNullable(FeatureAdapter.retrieveApiKey(id)).map(matcher::replaceAll).orElseThrow(() -> {
                    String message = Config.getPref().getKeySet().contains("apikey.sites") ? I18n.tr("Advanced preference ''{0}'' is not default. Please consider resetting it.", "apikey.sites") : I18n.tr("API key for imagery with id={0} may not be available.", id);
                    return new IOException(message);
                });
            }
            catch (IOException e) {
                throw new IllegalArgumentException(I18n.tr("Could not retrieve API key for imagery with id={0}. Cannot add layer.\n{1}", id, e.getMessage()), e);
            }
        }
        return url;
    }
}

