/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.gpx;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.openstreetmap.josm.data.IQuadBucketType;
import org.openstreetmap.josm.data.coor.CachedLatLon;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.imagery.street_level.Projections;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.gui.layer.geoimage.ImageMetadata;

public class GpxImageEntry
implements Comparable<GpxImageEntry>,
IQuadBucketType,
ImageMetadata {
    private File file;
    private Integer exifOrientation;
    private LatLon exifCoor;
    private Double exifImgDir;
    private Instant exifTime;
    private Projections cameraProjection = Projections.UNKNOWN;
    private boolean isNewGpsData;
    private Instant exifGpsTime;
    private String iptcCaption;
    private String iptcHeadline;
    private List<String> iptcKeywords;
    private String iptcObjectName;
    private CachedLatLon pos;
    private Double speed;
    private Double elevation;
    private Instant gpsTime;
    private int width;
    private int height;
    private GpxImageEntry tmp;

    public GpxImageEntry() {
    }

    public GpxImageEntry(GpxImageEntry other) {
        this.file = other.file;
        this.exifOrientation = other.exifOrientation;
        this.exifCoor = other.exifCoor;
        this.exifImgDir = other.exifImgDir;
        this.exifTime = other.exifTime;
        this.isNewGpsData = other.isNewGpsData;
        this.exifGpsTime = other.exifGpsTime;
        this.pos = other.pos;
        this.speed = other.speed;
        this.elevation = other.elevation;
        this.gpsTime = other.gpsTime;
        this.width = other.width;
        this.height = other.height;
        this.tmp = other.tmp;
    }

    public GpxImageEntry(File file) {
        this.setFile(file);
    }

    @Override
    public URI getImageURI() {
        return this.getFile().toURI();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public CachedLatLon getPos() {
        if (this.tmp != null) {
            return this.tmp.pos;
        }
        return this.pos;
    }

    @Override
    public Double getSpeed() {
        if (this.tmp != null) {
            return this.tmp.speed;
        }
        return this.speed;
    }

    @Override
    public Double getElevation() {
        if (this.tmp != null) {
            return this.tmp.elevation;
        }
        return this.elevation;
    }

    @Override
    public Instant getGpsInstant() {
        return this.tmp != null ? this.tmp.gpsTime : this.gpsTime;
    }

    @Override
    public boolean hasGpsTime() {
        return this.tmp != null && this.tmp.gpsTime != null || this.gpsTime != null;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public String getDisplayName() {
        return this.file == null ? "" : this.file.getName();
    }

    @Override
    public Integer getExifOrientation() {
        return this.exifOrientation != null ? this.exifOrientation : 1;
    }

    @Override
    public Instant getExifInstant() {
        return this.exifTime;
    }

    @Override
    public boolean hasExifTime() {
        return this.exifTime != null;
    }

    @Override
    public Instant getExifGpsInstant() {
        return this.exifGpsTime;
    }

    @Override
    public boolean hasExifGpsTime() {
        return this.exifGpsTime != null;
    }

    private static Date getDefensiveDate(Instant date) {
        if (date == null) {
            return null;
        }
        return Date.from(date);
    }

    @Override
    public LatLon getExifCoor() {
        return this.exifCoor;
    }

    @Override
    public Double getExifImgDir() {
        if (this.tmp != null) {
            return this.tmp.exifImgDir;
        }
        return this.exifImgDir;
    }

    @Override
    public Instant getLastModified() {
        return Instant.ofEpochMilli(this.getFile().lastModified());
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    public void setPos(CachedLatLon pos) {
        this.pos = pos;
    }

    public void setPos(LatLon pos) {
        this.setPos(pos != null ? new CachedLatLon(pos) : null);
    }

    @Override
    public void setPos(ILatLon pos) {
        if (pos instanceof CachedLatLon) {
            this.setPos((CachedLatLon)pos);
        } else if (pos instanceof LatLon) {
            this.setPos((LatLon)pos);
        } else if (pos != null) {
            this.setPos(new LatLon(pos));
        } else {
            this.setPos(null);
        }
    }

    @Override
    public void setSpeed(Double speed) {
        this.speed = speed;
    }

    @Override
    public void setElevation(Double elevation) {
        this.elevation = elevation;
    }

    public void setFile(File file) {
        this.file = file;
    }

    @Override
    public void setExifOrientation(Integer exifOrientation) {
        this.exifOrientation = exifOrientation;
    }

    @Override
    public void setExifTime(Instant exifTime) {
        this.exifTime = exifTime;
    }

    @Override
    public void setExifGpsTime(Instant exifGpsTime) {
        this.exifGpsTime = exifGpsTime;
    }

    @Override
    public void setGpsTime(Instant gpsTime) {
        this.gpsTime = gpsTime;
    }

    public void setExifCoor(LatLon exifCoor) {
        this.exifCoor = exifCoor;
    }

    @Override
    public void setExifCoor(ILatLon exifCoor) {
        this.exifCoor = exifCoor instanceof LatLon ? (LatLon)exifCoor : (exifCoor != null ? new LatLon(exifCoor) : null);
    }

    @Override
    public void setExifImgDir(Double exifDir) {
        this.exifImgDir = exifDir;
    }

    @Override
    public void setIptcCaption(String iptcCaption) {
        this.iptcCaption = iptcCaption;
    }

    @Override
    public void setIptcHeadline(String iptcHeadline) {
        this.iptcHeadline = iptcHeadline;
    }

    @Override
    public void setIptcKeywords(List<String> iptcKeywords) {
        this.iptcKeywords = iptcKeywords;
    }

    @Override
    public void setIptcObjectName(String iptcObjectName) {
        this.iptcObjectName = iptcObjectName;
    }

    @Override
    public String getIptcCaption() {
        return this.iptcCaption;
    }

    @Override
    public String getIptcHeadline() {
        return this.iptcHeadline;
    }

    @Override
    public List<String> getIptcKeywords() {
        return this.iptcKeywords;
    }

    @Override
    public String getIptcObjectName() {
        return this.iptcObjectName;
    }

    @Override
    public int compareTo(GpxImageEntry image) {
        if (this.exifTime != null && image.exifTime != null) {
            return this.exifTime.compareTo(image.exifTime);
        }
        if (this.exifTime == null && image.exifTime == null) {
            return 0;
        }
        if (this.exifTime == null) {
            return -1;
        }
        return 1;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.height, this.width, this.isNewGpsData, this.elevation, this.exifCoor, this.exifGpsTime, this.exifImgDir, this.exifOrientation, this.exifTime, this.iptcCaption, this.iptcHeadline, this.iptcKeywords, this.iptcObjectName, this.file, this.gpsTime, this.pos, this.speed, this.tmp, this.cameraProjection});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GpxImageEntry other = (GpxImageEntry)obj;
        return this.height == other.height && this.width == other.width && this.isNewGpsData == other.isNewGpsData && Objects.equals(this.elevation, other.elevation) && Objects.equals(this.exifCoor, other.exifCoor) && Objects.equals(this.exifGpsTime, other.exifGpsTime) && Objects.equals(this.exifImgDir, other.exifImgDir) && Objects.equals(this.exifOrientation, other.exifOrientation) && Objects.equals(this.exifTime, other.exifTime) && Objects.equals(this.iptcCaption, other.iptcCaption) && Objects.equals(this.iptcHeadline, other.iptcHeadline) && Objects.equals(this.iptcKeywords, other.iptcKeywords) && Objects.equals(this.iptcObjectName, other.iptcObjectName) && Objects.equals(this.file, other.file) && Objects.equals(this.gpsTime, other.gpsTime) && Objects.equals(this.pos, other.pos) && Objects.equals(this.speed, other.speed) && Objects.equals(this.tmp, other.tmp) && this.cameraProjection == other.cameraProjection;
    }

    public GpxImageEntry createTmp() {
        this.tmp = new GpxImageEntry(this);
        this.tmp.tmp = null;
        return this.tmp;
    }

    public GpxImageEntry getTmp() {
        if (this.tmp == null) {
            this.createTmp();
        }
        return this.tmp;
    }

    public void applyTmp() {
        if (this.tmp != null) {
            this.pos = this.tmp.pos;
            this.speed = this.tmp.speed;
            this.elevation = this.tmp.elevation;
            this.gpsTime = this.tmp.gpsTime;
            this.exifImgDir = this.tmp.exifImgDir;
            this.isNewGpsData = this.isNewGpsData || this.tmp.isNewGpsData;
            this.tmp = null;
        }
        this.tmpUpdated();
    }

    public void discardTmp() {
        this.tmp = null;
        this.tmpUpdated();
    }

    public boolean isTagged() {
        return this.pos != null;
    }

    public String toString() {
        return this.file.getName() + ": pos = " + String.valueOf(this.pos) + " | exifCoor = " + String.valueOf(this.exifCoor) + " | " + (String)(this.tmp == null ? " tmp==null" : " [tmp] pos = " + String.valueOf(this.tmp.pos));
    }

    public void flagNewGpsData() {
        this.isNewGpsData = true;
    }

    protected void tmpUpdated() {
    }

    @Override
    public BBox getBBox() {
        return new BBox(this.getPos());
    }

    public void unflagNewGpsData() {
        this.isNewGpsData = false;
    }

    public boolean hasNewGpsData() {
        if (this.tmp != null) {
            return this.tmp.isNewGpsData;
        }
        return this.isNewGpsData;
    }

    @Override
    public void extractExif() {
        ImageMetadata.super.extractExif();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return Files.newInputStream(this.getFile().toPath(), new OpenOption[0]);
    }

    public BufferedImage read(Dimension target) throws IOException {
        throw new UnsupportedOperationException("read not implemented for " + this.getClass().getSimpleName());
    }

    @Override
    public Projections getProjectionType() {
        return this.cameraProjection;
    }

    @Override
    public void setProjectionType(Projections newProjection) {
        this.cameraProjection = newProjection;
    }

    public WayPoint asWayPoint() {
        CachedLatLon position = this.getPos();
        WayPoint wpt = null;
        if (position != null) {
            wpt = new WayPoint(position);
            wpt.setInstant(this.exifTime);
            Double ele = this.getElevation();
            if (ele != null) {
                wpt.put("ele", ele.toString());
            }
        }
        return wpt;
    }
}

