/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.relation;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Objects;
import org.openstreetmap.josm.actions.relation.AbstractRelationAction;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.osm.DataSelectionListener;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.OsmData;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.dialogs.relation.GenericRelationEditor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.StreamUtils;
import org.openstreetmap.josm.tools.Utils;

public class AddSelectionToRelations
extends AbstractRelationAction
implements DataSelectionListener {
    public AddSelectionToRelations() {
        new ImageProvider("dialogs/conflict", "copyendright").getResource().attachImageIcon(this, true);
        this.putValue("ShortDescription", I18n.tr("Add all objects selected in the current dataset after the last member", new Object[0]));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Collection cmds = Utils.filteredCollection(this.relations, Relation.class).stream().map(r -> GenericRelationEditor.addPrimitivesToRelation(r, MainApplication.getLayerManager().getActiveDataSet().getSelected())).filter(Objects::nonNull).collect(StreamUtils.toUnmodifiableList());
        if (!cmds.isEmpty()) {
            UndoRedoHandler.getInstance().add(new SequenceCommand(I18n.tr("Add selection to relation", new Object[0]), cmds));
            new Notification("<html>" + I18n.tr("{0}Add selection to relation{1}: Verify every single relation to avoid damage!", "<strong>", "</strong>") + "</html>").setIcon(2).show();
        }
    }

    @Override
    public void updateEnabledState() {
        int size = this.relations.size();
        this.putValue("Name", I18n.trn("Add selection to {0} relation", "Add selection to {0} relations", size, size));
        OsmData<?, ?, ?, ?> ds = MainApplication.getLayerManager().getActiveData();
        if (ds != null) {
            this.selectionChanged(ds.getSelected());
        } else {
            this.setEnabled(false);
        }
    }

    private void selectionChanged(Collection<? extends IPrimitive> newSelection) {
        GuiHelper.runInEDT(() -> this.setEnabled(!Utils.isEmpty(newSelection) && OsmUtils.isOsmCollectionEditable(this.relations)));
    }

    @Override
    public void selectionChanged(DataSelectionListener.SelectionChangeEvent event) {
        this.selectionChanged(event.getSelection());
    }
}

