/*
 * Decompiled with CFR 0.152.
 */
package ch.poole.openinghoursparser;

import ch.poole.openinghoursparser.Element;
import ch.poole.openinghoursparser.Nth;
import ch.poole.openinghoursparser.Util;
import ch.poole.openinghoursparser.WeekDay;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class WeekDayRange
extends Element {
    WeekDay startDay = null;
    WeekDay endDay = null;
    List<Nth> nths = null;
    int offset = 0;

    public WeekDayRange() {
    }

    public WeekDayRange(@NotNull WeekDayRange wdr) {
        this.startDay = wdr.startDay;
        this.endDay = wdr.endDay;
        this.nths = wdr.nths != null ? Util.copyList(wdr.nths) : null;
        this.offset = wdr.offset;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append((Object)this.startDay);
        if (this.endDay != null) {
            b.append("-");
            b.append((Object)this.endDay);
        } else if (this.nths != null && !this.nths.isEmpty()) {
            b.append("[");
            for (Nth n : this.nths) {
                b.append(n.toString());
                if (n.equals(this.nths.get(this.nths.size() - 1))) continue;
                b.append(",");
            }
            b.append("]");
            if (this.offset != 0) {
                if (this.offset > 0) {
                    b.append(" +");
                } else {
                    b.append(" -");
                }
                b.append(String.format("%d", Math.abs(this.offset)));
                b.append(" day");
                if (Math.abs(this.offset) > 1) {
                    b.append("s");
                }
            }
        }
        return b.toString();
    }

    @Override
    public String toDebugString() {
        StringBuilder b = new StringBuilder();
        b.append(this.getClass().getSimpleName() + ":");
        b.append((Object)this.startDay);
        if (this.endDay != null) {
            b.append("-");
            b.append((Object)this.endDay);
        } else if (this.nths != null && !this.nths.isEmpty()) {
            b.append("[");
            for (Nth n : this.nths) {
                b.append(n.toDebugString());
                if (n.equals(this.nths.get(this.nths.size() - 1))) continue;
                b.append(",");
            }
            b.append("]");
            if (this.offset != 0) {
                if (this.offset > 0) {
                    b.append(" +");
                } else {
                    b.append(" -");
                }
                b.append(String.format("%d", Math.abs(this.offset)));
                b.append(" day");
                if (Math.abs(this.offset) > 1) {
                    b.append("s");
                }
            }
        }
        return b.toString();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof WeekDayRange) {
            WeekDayRange o = (WeekDayRange)other;
            return Util.equals((Object)this.startDay, (Object)o.startDay) && Util.equals((Object)this.endDay, (Object)o.endDay) && Util.equals(this.nths, o.nths) && this.offset == o.offset;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 37 * result + (this.startDay == null ? 0 : this.startDay.hashCode());
        result = 37 * result + (this.endDay == null ? 0 : this.endDay.hashCode());
        result = 37 * result + (this.nths == null ? 0 : this.nths.hashCode());
        result = 37 * result + this.offset;
        return result;
    }

    public WeekDay getStartDay() {
        return this.startDay;
    }

    public WeekDay getEndDay() {
        return this.endDay;
    }

    public List<Nth> getNths() {
        return this.nths;
    }

    public void setStartDay(WeekDay day) {
        this.startDay = day;
    }

    public void setStartDay(String day) {
        if (day == null || "".equals(day)) {
            this.startDay = null;
            return;
        }
        this.startDay = WeekDay.getValue(day);
    }

    public void setEndDay(WeekDay day) {
        this.endDay = day;
    }

    public void setEndDay(String day) {
        this.endDay = WeekDay.getValue(day);
    }

    public void setNths(List<Nth> nths) {
        this.nths = nths;
    }

    public void add(Nth nth) {
        if (this.nths == null) {
            this.nths = new ArrayList<Nth>();
        }
        this.nths.add(nth);
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public WeekDayRange copy() {
        return new WeekDayRange(this);
    }
}

