/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.io.StringReader;
import java.io.StringWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import org.openstreetmap.josm.spi.preferences.IPreferences;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.ReflectionUtils;
import org.openstreetmap.josm.tools.Utils;

public final class StructUtils {
    private StructUtils() {
    }

    public static <T> List<T> getListOfStructs(IPreferences preferences, String key, Class<T> klass) {
        return Optional.ofNullable(StructUtils.getListOfStructs(preferences, key, null, klass)).orElseGet(Collections::emptyList);
    }

    public static <T> List<T> getListOfStructs(IPreferences preferences, String key, Collection<T> def, Class<T> klass) {
        List<Map<String, String>> prop = preferences.getListOfMaps(key, def == null ? null : StructUtils.serializeListOfStructs(def, klass));
        if (prop == null) {
            return def == null ? null : new ArrayList<T>(def);
        }
        return prop.stream().map(p -> StructUtils.deserializeStruct(p, klass)).collect(Collectors.toList());
    }

    public static <T> boolean putListOfStructs(IPreferences preferences, String key, Collection<T> val, Class<T> klass) {
        return preferences.putListOfMaps(key, StructUtils.serializeListOfStructs(val, klass));
    }

    private static <T> List<Map<String, String>> serializeListOfStructs(Collection<T> l, Class<T> klass) {
        if (l == null) {
            return null;
        }
        return l.stream().filter(Objects::nonNull).map(struct -> StructUtils.serializeStruct(struct, klass)).collect(Collectors.toList());
    }

    public static <T> HashMap<String, String> serializeStruct(T struct, Class<T> klass) {
        T structPrototype;
        try {
            structPrototype = klass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            throw new IllegalArgumentException(ex);
        }
        LinkedHashMap<String, String> hash = new LinkedHashMap<String, String>();
        for (Field f : klass.getDeclaredFields()) {
            if (f.getAnnotation(StructEntry.class) == null) continue;
            try {
                ReflectionUtils.setObjectsAccessible(f);
                Object fieldValue = f.get(struct);
                Object defaultFieldValue = f.get(structPrototype);
                if (fieldValue == null || f.getAnnotation(WriteExplicitly.class) == null && Objects.equals(fieldValue, defaultFieldValue)) continue;
                String key = f.getName().replace('_', '-');
                if (fieldValue instanceof Map) {
                    hash.put(key, StructUtils.mapToJson((Map)fieldValue));
                    continue;
                }
                if (fieldValue instanceof MultiMap) {
                    hash.put(key, StructUtils.multiMapToJson((MultiMap)fieldValue));
                    continue;
                }
                hash.put(key, fieldValue.toString());
            }
            catch (IllegalAccessException | SecurityException ex) {
                throw new JosmRuntimeException(ex);
            }
        }
        return hash;
    }

    public static <T> T deserializeStruct(Map<String, String> hash, Class<T> klass) {
        T struct = null;
        try {
            struct = klass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            throw new IllegalArgumentException(ex);
        }
        for (Map.Entry<String, String> keyValue : hash.entrySet()) {
            Object value;
            Field f;
            block22: {
                try {
                    f = klass.getDeclaredField(keyValue.getKey().replace('-', '_'));
                }
                catch (NoSuchFieldException ex) {
                    Logging.trace(ex);
                    continue;
                }
                if (f.getAnnotation(StructEntry.class) == null) continue;
                ReflectionUtils.setObjectsAccessible(f);
                if (f.getType() == Boolean.class || f.getType() == Boolean.TYPE) {
                    value = Boolean.valueOf(keyValue.getValue());
                } else {
                    if (f.getType() == Integer.class || f.getType() == Integer.TYPE) {
                        try {
                            value = Integer.valueOf(keyValue.getValue());
                            break block22;
                        }
                        catch (NumberFormatException nfe) {
                            continue;
                        }
                    }
                    if (f.getType() == Double.class || f.getType() == Double.TYPE) {
                        try {
                            value = Double.valueOf(keyValue.getValue());
                            break block22;
                        }
                        catch (NumberFormatException nfe) {
                            continue;
                        }
                    }
                    if (f.getType() == String.class) {
                        value = keyValue.getValue();
                    } else if (f.getType().isAssignableFrom(Map.class)) {
                        value = StructUtils.mapFromJson(keyValue.getValue());
                    } else if (f.getType().isAssignableFrom(MultiMap.class)) {
                        value = StructUtils.multiMapFromJson(keyValue.getValue());
                    } else {
                        throw new JosmRuntimeException("unsupported preference primitive type");
                    }
                }
            }
            try {
                f.set(struct, value);
            }
            catch (IllegalArgumentException ex) {
                throw new AssertionError((Object)ex);
            }
            catch (IllegalAccessException ex) {
                throw new JosmRuntimeException(ex);
            }
        }
        return struct;
    }

    private static String mapToJson(Map map) {
        StringWriter stringWriter = new StringWriter();
        try (JsonWriter writer = Json.createWriter(stringWriter);){
            JsonObjectBuilder object = Json.createObjectBuilder();
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry o;
                Map.Entry e = o = iterator.next();
                Object evalue = e.getValue();
                object.add(e.getKey().toString(), evalue.toString());
            }
            writer.writeObject(object.build());
        }
        return stringWriter.toString();
    }

    private static Map mapFromJson(String s) {
        HashMap ret = null;
        try (JsonReader reader = Json.createReader(new StringReader(s));){
            JsonObject object = reader.readObject();
            ret = new HashMap(Utils.hashMapInitialCapacity(object.size()));
            for (Map.Entry e : object.entrySet()) {
                JsonValue value = (JsonValue)e.getValue();
                if (value instanceof JsonString) {
                    ret.put(e.getKey(), ((JsonString)value).getString());
                    continue;
                }
                ret.put(e.getKey(), ((JsonValue)e.getValue()).toString());
            }
        }
        return ret;
    }

    private static String multiMapToJson(MultiMap map) {
        StringWriter stringWriter = new StringWriter();
        try (JsonWriter writer = Json.createWriter(stringWriter);){
            JsonObjectBuilder object = Json.createObjectBuilder();
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry o;
                Map.Entry e = o = iterator.next();
                Set evalue = e.getValue();
                JsonArrayBuilder a = Json.createArrayBuilder();
                for (Object evo : evalue) {
                    a.add(evo.toString());
                }
                object.add(e.getKey().toString(), a.build());
            }
            writer.writeObject(object.build());
        }
        return stringWriter.toString();
    }

    private static MultiMap multiMapFromJson(String s) {
        MultiMap ret = null;
        try (JsonReader reader = Json.createReader(new StringReader(s));){
            JsonObject object = reader.readObject();
            ret = new MultiMap(object.size());
            for (Map.Entry e : object.entrySet()) {
                JsonValue value = (JsonValue)e.getValue();
                if (value instanceof JsonArray) {
                    for (JsonString js : ((JsonArray)value).getValuesAs(JsonString.class)) {
                        ret.put(e.getKey(), js.getString());
                    }
                    continue;
                }
                if (value instanceof JsonString) {
                    ret.put(e.getKey(), ((JsonString)value).getString());
                    continue;
                }
                ret.put(e.getKey(), ((JsonValue)e.getValue()).toString());
            }
        }
        return ret;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface WriteExplicitly {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface StructEntry {
    }
}

