/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.relation;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.openstreetmap.josm.actions.relation.AbstractRelationAction;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.DownloadPrimitivesTask;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class DownloadMembersAction
extends AbstractRelationAction {
    public DownloadMembersAction() {
        this.putValue("ShortDescription", I18n.tr("Download all members of the selected relations", new Object[0]));
        this.putValue("Name", I18n.tr("Download members", new Object[0]));
        new ImageProvider("dialogs", "downloadincomplete").getResource().attachImageIcon(this, true);
        this.setHelpId(HelpUtil.ht("/Dialog/RelationList#DownloadMembers"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled() || this.relations.isEmpty() || !MainApplication.isDisplayingMapView()) {
            return;
        }
        List<PrimitiveId> members = this.relations.stream().flatMap(r -> r.getMemberPrimitivesList().stream().filter(osm -> !osm.isNew()).map(IPrimitive::getOsmPrimitiveId)).distinct().collect(Collectors.toList());
        MainApplication.worker.submit(new DownloadPrimitivesTask(MainApplication.getLayerManager().getEditLayer(), members, false));
    }

    @Override
    public void setPrimitives(Collection<? extends IPrimitive> primitives) {
        this.relations = DownloadMembersAction.getRelations(primitives);
        this.updateEnabledState();
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.canDownload());
    }
}

