/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.noop;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.chunking.Chunker;
import org.languagetool.language.Contributor;
import org.languagetool.noop.NoopChunker;
import org.languagetool.noop.NoopDisambiguator;
import org.languagetool.rules.Rule;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.xx.DemoTagger;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;

public class NoopLanguage
extends Language {
    private static final String SHORT_CODE = "zz";
    private Tagger tagger;
    private Chunker chunker;
    private Disambiguator disambiguator;

    @Override
    public Locale getLocale() {
        return new Locale("en");
    }

    @Override
    public Disambiguator getDisambiguator() {
        if (this.disambiguator == null) {
            this.disambiguator = new NoopDisambiguator();
        }
        return this.disambiguator;
    }

    @Override
    public String getName() {
        return "NoopLanguage";
    }

    @Override
    public String getShortCode() {
        return SHORT_CODE;
    }

    @Override
    public String[] getCountries() {
        return new String[0];
    }

    @Override
    public Tagger getTagger() {
        if (this.tagger == null) {
            this.tagger = new DemoTagger();
        }
        return this.tagger;
    }

    @Override
    public Chunker getChunker() {
        if (this.chunker == null) {
            this.chunker = new NoopChunker();
        }
        return this.chunker;
    }

    @Override
    public Contributor[] getMaintainers() {
        return null;
    }

    @Override
    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, List<Language> altLanguages) {
        return Collections.emptyList();
    }

    @Override
    protected synchronized List<AbstractPatternRule> getPatternRules() {
        return Collections.emptyList();
    }

    @Override
    public SentenceTokenizer getSentenceTokenizer() {
        return new SentenceTokenizer(){

            @Override
            public List<String> tokenize(String text) {
                return Collections.singletonList(text);
            }

            @Override
            public void setSingleLineBreaksMarksParagraph(boolean lineBreakParagraphs) {
            }

            @Override
            public boolean singleLineBreaksMarksPara() {
                return false;
            }
        };
    }

    @Override
    public Tokenizer getWordTokenizer() {
        return Collections::singletonList;
    }
}

