/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.summary;

import com.hankcs.hanlp.dictionary.stopword.CoreStopWordDictionary;
import com.hankcs.hanlp.seg.common.Term;
import com.hankcs.hanlp.summary.BM25;
import com.hankcs.hanlp.tokenizer.StandardTokenizer;
import com.hankcs.hanlp.utility.TextUtility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;

public class TextRankSentence {
    static final double d = 0.85;
    static final int max_iter = 200;
    static final double min_diff = 0.001;
    static final String default_sentence_separator = "[\uff0c,\u3002:\uff1a\u201c\u201d\uff1f?\uff01!\uff1b;]";
    int D;
    List<List<String>> docs;
    TreeMap<Double, Integer> top;
    double[][] weight;
    double[] weight_sum;
    double[] vertex;
    BM25 bm25;

    public TextRankSentence(List<List<String>> docs) {
        this.docs = docs;
        this.bm25 = new BM25(docs);
        this.D = docs.size();
        this.weight = new double[this.D][this.D];
        this.weight_sum = new double[this.D];
        this.vertex = new double[this.D];
        this.top = new TreeMap(Collections.reverseOrder());
        this.solve();
    }

    private void solve() {
        int cnt = 0;
        for (List<String> sentence : this.docs) {
            double[] scores = this.bm25.simAll(sentence);
            this.weight[cnt] = scores;
            this.weight_sum[cnt] = TextRankSentence.sum(scores) - scores[cnt];
            this.vertex[cnt] = 1.0;
            ++cnt;
        }
        for (int _ = 0; _ < 200; ++_) {
            double[] m = new double[this.D];
            double max_diff = 0.0;
            for (int i = 0; i < this.D; ++i) {
                m[i] = 0.15000000000000002;
                for (int j = 0; j < this.D; ++j) {
                    if (j == i || this.weight_sum[j] == 0.0) continue;
                    int n = i;
                    m[n] = m[n] + 0.85 * this.weight[j][i] / this.weight_sum[j] * this.vertex[j];
                }
                double diff = Math.abs(m[i] - this.vertex[i]);
                if (!(diff > max_diff)) continue;
                max_diff = diff;
            }
            this.vertex = m;
            if (max_diff <= 0.001) break;
        }
        for (int i = 0; i < this.D; ++i) {
            this.top.put(this.vertex[i], i);
        }
    }

    public int[] getTopSentence(int size) {
        Collection<Integer> values = this.top.values();
        size = Math.min(size, values.size());
        int[] indexArray = new int[size];
        Iterator<Integer> it = values.iterator();
        for (int i = 0; i < size; ++i) {
            indexArray[i] = it.next();
        }
        return indexArray;
    }

    private static double sum(double[] array) {
        double total = 0.0;
        for (double v : array) {
            total += v;
        }
        return total;
    }

    static List<String> splitSentence(String document) {
        return TextRankSentence.splitSentence(document, default_sentence_separator);
    }

    static List<String> splitSentence(String document, String sentence_separator) {
        ArrayList<String> sentences = new ArrayList<String>();
        for (String line : document.split("[\r\n]")) {
            if ((line = line.trim()).length() == 0) continue;
            for (String sent : line.split(sentence_separator)) {
                if ((sent = sent.trim()).length() == 0) continue;
                sentences.add(sent);
            }
        }
        return sentences;
    }

    private static List<List<String>> convertSentenceListToDocument(List<String> sentenceList) {
        ArrayList<List<String>> docs = new ArrayList<List<String>>(sentenceList.size());
        for (String sentence : sentenceList) {
            List<Term> termList = StandardTokenizer.segment(sentence.toCharArray());
            LinkedList<String> wordList = new LinkedList<String>();
            for (Term term : termList) {
                if (!CoreStopWordDictionary.shouldInclude(term)) continue;
                wordList.add(term.word);
            }
            docs.add(wordList);
        }
        return docs;
    }

    public static List<String> getTopSentenceList(String document, int size) {
        return TextRankSentence.getTopSentenceList(document, size, default_sentence_separator);
    }

    public static List<String> getTopSentenceList(String document, int size, String sentence_separator) {
        List<String> sentenceList = TextRankSentence.splitSentence(document, sentence_separator);
        List<List<String>> docs = TextRankSentence.convertSentenceListToDocument(sentenceList);
        TextRankSentence textRank = new TextRankSentence(docs);
        int[] topSentence = textRank.getTopSentence(size);
        LinkedList<String> resultList = new LinkedList<String>();
        for (int i : topSentence) {
            resultList.add(sentenceList.get(i));
        }
        return resultList;
    }

    public static String getSummary(String document, int max_length) {
        return TextRankSentence.getSummary(document, max_length, default_sentence_separator);
    }

    public static String getSummary(String document, int max_length, String sentence_separator) {
        List<String> sentenceList = TextRankSentence.splitSentence(document, sentence_separator);
        int sentence_count = sentenceList.size();
        int document_length = document.length();
        int sentence_length_avg = document_length / sentence_count;
        int size = max_length / sentence_length_avg + 1;
        List<List<String>> docs = TextRankSentence.convertSentenceListToDocument(sentenceList);
        TextRankSentence textRank = new TextRankSentence(docs);
        int[] topSentence = textRank.getTopSentence(size);
        List<String> resultList = new LinkedList<String>();
        for (int i : topSentence) {
            resultList.add(sentenceList.get(i));
        }
        resultList = TextRankSentence.permutation(resultList, sentenceList);
        resultList = TextRankSentence.pick_sentences(resultList, max_length);
        return TextUtility.join("\u3002", resultList);
    }

    private static List<String> permutation(List<String> resultList, final List<String> sentenceList) {
        Collections.sort(resultList, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                Integer num1 = sentenceList.indexOf(o1);
                Integer num2 = sentenceList.indexOf(o2);
                return num1.compareTo(num2);
            }
        });
        return resultList;
    }

    private static List<String> pick_sentences(List<String> resultList, int max_length) {
        ArrayList<String> summary = new ArrayList<String>();
        int count = 0;
        for (String result : resultList) {
            if (count + result.length() > max_length) continue;
            summary.add(result);
            count += result.length();
        }
        return summary;
    }
}

