/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.util.ArrayList;
import java.util.List;

class UnicodeBasedLangIdentifier {
    private static final int DEFAULT_MAX_CHECK_LENGTH = 50;
    private static final float THRESHOLD = 0.5f;
    private final int maxCheckLength;

    UnicodeBasedLangIdentifier() {
        this(50);
    }

    UnicodeBasedLangIdentifier(int maxCheckLength) {
        this.maxCheckLength = maxCheckLength;
    }

    List<String> getAdditionalLangCodes(String str) {
        int cyrillicChars = 0;
        int cjkChars = 0;
        int khmerChars = 0;
        int tamilChars = 0;
        int greekChars = 0;
        int devanagariChars = 0;
        int significantChars = 0;
        for (int i = 0; i < Math.min(str.length(), this.maxCheckLength); ++i) {
            char val = str.charAt(i);
            if (!Character.isWhitespace((int)val) && !Character.isDigit((int)val)) {
                ++significantChars;
            }
            if (val >= '\u0400' && val <= '\u04ff') {
                ++cyrillicChars;
            }
            if (val >= '\u4e00' && val <= '\u9fff' || val >= '\u3040' && val <= '\u309f' || val >= '\u30a0' && val <= '\u30ff') {
                ++cjkChars;
            }
            if (val >= '\u1780' && val <= '\u17ff') {
                ++khmerChars;
            }
            if (val >= '\u0b82' && val <= '\u0bfa') {
                ++tamilChars;
            }
            if (val >= '\u0370' && val <= '\u03ff' || val >= '\u1f00' && val <= '\u1fff') {
                ++greekChars;
            }
            if (val < '\u0900' || val > '\u097f') continue;
            ++devanagariChars;
        }
        ArrayList<String> langCodes = new ArrayList<String>();
        if ((float)cyrillicChars / (float)significantChars >= 0.5f) {
            langCodes.add("ru");
            langCodes.add("uk");
            langCodes.add("be");
        }
        if ((float)cjkChars / (float)significantChars >= 0.5f) {
            langCodes.add("zh");
            langCodes.add("ja");
        }
        if ((float)khmerChars / (float)significantChars >= 0.5f) {
            langCodes.add("km");
        }
        if ((float)tamilChars / (float)significantChars >= 0.5f) {
            langCodes.add("ta");
        }
        if ((float)greekChars / (float)significantChars >= 0.5f) {
            langCodes.add("el");
        }
        if ((float)devanagariChars / (float)significantChars >= 0.5f) {
            langCodes.add("hi");
            langCodes.add("mr");
        }
        return langCodes;
    }
}

