/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.corpus.dependency.CoNll;

import com.hankcs.hanlp.corpus.dependency.CoNll.CoNLLWord;
import com.hankcs.hanlp.corpus.dependency.CoNll.CoNllLine;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class CoNLLSentence
implements Iterable<CoNLLWord> {
    public CoNLLWord[] word;

    public CoNLLSentence(List<CoNllLine> lineList) {
        CoNllLine[] lineArray = lineList.toArray(new CoNllLine[0]);
        this.word = new CoNLLWord[lineList.size()];
        int i = 0;
        for (CoNllLine line : lineList) {
            this.word[i++] = new CoNLLWord(line);
        }
        for (CoNLLWord nllWord : this.word) {
            int head = Integer.parseInt(lineArray[nllWord.ID - 1].value[6]) - 1;
            nllWord.HEAD = head != -1 ? this.word[head] : CoNLLWord.ROOT;
        }
    }

    public CoNLLSentence(CoNLLWord[] word) {
        this.word = word;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.word.length * 50);
        for (CoNLLWord word : this.word) {
            sb.append(word);
            sb.append('\n');
        }
        return sb.toString();
    }

    public String[][] getEdgeArray() {
        String[][] edge = new String[this.word.length + 1][this.word.length + 1];
        for (CoNLLWord coNLLWord : this.word) {
            edge[coNLLWord.ID][coNLLWord.HEAD.ID] = coNLLWord.DEPREL;
        }
        return edge;
    }

    public CoNLLWord[] getWordArrayWithRoot() {
        CoNLLWord[] wordArray = new CoNLLWord[this.word.length + 1];
        wordArray[0] = CoNLLWord.ROOT;
        System.arraycopy(this.word, 0, wordArray, 1, this.word.length);
        return wordArray;
    }

    public CoNLLWord[] getWordArray() {
        return this.word;
    }

    @Override
    public Iterator<CoNLLWord> iterator() {
        return new Iterator<CoNLLWord>(){
            int index;

            @Override
            public boolean hasNext() {
                return this.index < CoNLLSentence.this.word.length;
            }

            @Override
            public CoNLLWord next() {
                return CoNLLSentence.this.word[this.index++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("CoNLLSentence\u662f\u53ea\u8bfb\u5bf9\u8c61\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
            }
        };
    }

    public List<CoNLLWord> findChildren(CoNLLWord word) {
        LinkedList<CoNLLWord> result = new LinkedList<CoNLLWord>();
        for (CoNLLWord other : this) {
            if (other.HEAD != word) continue;
            result.add(other);
        }
        return result;
    }

    public List<CoNLLWord> findChildren(CoNLLWord word, String relation) {
        LinkedList<CoNLLWord> result = new LinkedList<CoNLLWord>();
        for (CoNLLWord other : this) {
            if (other.HEAD != word || !other.DEPREL.equals(relation)) continue;
            result.add(other);
        }
        return result;
    }
}

