/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.gui;

import java.awt.AWTException;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import javax.swing.text.Utilities;
import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.gui.AboutDialog;
import org.languagetool.gui.Configuration;
import org.languagetool.gui.ConfigurationDialog;
import org.languagetool.gui.FontChooser;
import org.languagetool.gui.GuiLangConfigPanel;
import org.languagetool.gui.LanguageComboBox;
import org.languagetool.gui.LanguageComboBoxModel;
import org.languagetool.gui.LanguageManagerDialog;
import org.languagetool.gui.LanguageToolEvent;
import org.languagetool.gui.LanguageToolListener;
import org.languagetool.gui.LanguageToolSupport;
import org.languagetool.gui.LocalStorage;
import org.languagetool.gui.LocaleBean;
import org.languagetool.gui.MainWindowStateBean;
import org.languagetool.gui.ResizeComponentListener;
import org.languagetool.gui.ResultAreaHelper;
import org.languagetool.gui.Tools;
import org.languagetool.gui.UndoRedoSupport;
import org.languagetool.rules.Rule;
import org.languagetool.server.HTTPServer;
import org.languagetool.server.HTTPServerConfig;
import org.languagetool.server.PortBindingException;
import org.languagetool.tools.JnaTools;
import org.languagetool.tools.StringTools;

public final class Main {
    static final String EXTERNAL_LANGUAGE_SUFFIX = " (ext.)";
    private static final String HTML_FONT_START = "<font face='Arial,Helvetica'>";
    private static final String HTML_FONT_END = "</font>";
    private static final String TRAY_ICON = "/TrayIcon.png";
    private static final String TRAY_SERVER_ICON = "/TrayIconWithServer.png";
    private static final String TRAY_SMALL_ICON = "/TrayIconSmall.png";
    private static final String TRAY_SMALL_SERVER_ICON = "/TrayIconSmallWithServer.png";
    private static final String TRAY_TOOLTIP = "LanguageTool";
    private static final String TAG_COLOR = "#888888";
    private static final String GUI_STATE = "gui.state";
    private static final int WINDOW_WIDTH = 600;
    private static final int WINDOW_HEIGHT = 550;
    private static final int MAX_RECENT_FILES = 8;
    private final ResourceBundle messages;
    private final List<Language> externalLanguages = new ArrayList<Language>();
    private JFrame frame;
    private JDialog taggerDialog;
    private JTextPane taggerArea;
    private JTextArea textArea;
    private TextLineNumber textLineNumber;
    private JScrollPane numberedTextAreaPane;
    private JTextPane resultArea;
    private LanguageComboBox languageBox;
    private CheckboxMenuItem enableHttpServerItem;
    private HTTPServer httpServer;
    private TrayIcon trayIcon;
    private boolean closeHidesToTray;
    private boolean isInTray;
    private boolean taggerShowsDisambigLog = false;
    private LanguageToolSupport ltSupport;
    private OpenAction openAction;
    private SaveAction saveAction;
    private SaveAsAction saveAsAction;
    private AutoCheckAction autoCheckAction;
    private ShowResultAction showResultAction;
    private CheckAction checkAction;
    private File currentFile;
    private ByteOrderMark bom;
    private UndoRedoSupport undoRedo;
    private final JLabel statusLabel = new JLabel(" ", null, 4);
    private FontChooser fontChooserDialog;
    private final CircularFifoQueue<String> recentFiles = new CircularFifoQueue(8);
    private JMenu recentFilesMenu;
    private final LocalStorage localStorage;
    private final Map<Language, ConfigurationDialog> configDialogs = new HashMap<Language, ConfigurationDialog>();
    private JSplitPane splitPane;
    private final JPanel mainPanel = new JPanel();

    private Main(LocalStorage localStorage) {
        this.localStorage = localStorage;
        this.messages = JLanguageTool.getMessageBundle();
    }

    private void loadFile() {
        File file = Tools.openFileDialog(this.frame, new PlainTextFileFilter());
        if (file == null) {
            return;
        }
        this.loadFile(file);
    }

    private void loadFile(File file) {
        try (FileInputStream inputStream = new FileInputStream(file);){
            String charsetName;
            BOMInputStream bomIn = new BOMInputStream((InputStream)inputStream, false, ByteOrderMark.UTF_8, ByteOrderMark.UTF_16BE, ByteOrderMark.UTF_16LE, ByteOrderMark.UTF_32BE, ByteOrderMark.UTF_32LE);
            if (bomIn.hasBOM()) {
                this.bom = bomIn.getBOM();
                charsetName = this.bom.getCharsetName();
            } else {
                this.bom = null;
                charsetName = null;
            }
            String fileContents = StringTools.readStream(bomIn, charsetName);
            this.textArea.setText(fileContents);
            this.currentFile = file;
            this.updateTitle();
            this.recentFiles.remove(file.getAbsolutePath());
            this.recentFiles.add(file.getAbsolutePath());
            this.localStorage.saveProperty("recentFiles", this.recentFiles);
            this.updateRecentFilesMenu();
        }
        catch (IOException e) {
            Tools.showError(e);
        }
    }

    private void saveFile(boolean newFile) {
        if (this.currentFile == null || newFile) {
            JFileChooser jfc = new JFileChooser();
            jfc.setFileFilter(new PlainTextFileFilter());
            jfc.showSaveDialog(this.frame);
            File file = jfc.getSelectedFile();
            if (file == null) {
                return;
            }
            this.currentFile = file;
            this.bom = null;
            this.updateTitle();
        }
        try {
            if (this.bom != null) {
                FileUtils.writeByteArrayToFile(this.currentFile, this.bom.getBytes());
                FileUtils.write(this.currentFile, (CharSequence)this.textArea.getText(), this.bom.getCharsetName(), true);
            } else {
                FileUtils.write(this.currentFile, (CharSequence)this.textArea.getText(), Charset.defaultCharset());
            }
        }
        catch (IOException ex) {
            Tools.showError(ex);
        }
    }

    private void addLanguage() throws InstantiationException, IllegalAccessException {
        LanguageManagerDialog dialog = new LanguageManagerDialog(this.frame, this.externalLanguages);
        dialog.show();
        List<Language> newExtLanguages = dialog.getLanguages();
        this.externalLanguages.clear();
        this.externalLanguages.addAll(newExtLanguages);
        this.languageBox.setModel(LanguageComboBoxModel.create(this.messages, EXTERNAL_LANGUAGE_SUFFIX, false, this.externalLanguages, null));
        this.languageBox.selectLanguage(this.ltSupport.getLanguage());
        this.ltSupport.setLanguage(this.languageBox.getSelectedLanguage());
        this.checkTextAndDisplayResults();
    }

    private void showOptions() {
        JLanguageTool lt = this.ltSupport.getLanguageTool();
        List<Rule> rules = lt.getAllRules();
        ConfigurationDialog configDialog = this.getCurrentConfigDialog();
        boolean configChanged = configDialog.show(rules);
        if (configChanged) {
            Configuration config = this.ltSupport.getConfig();
            try {
                config.saveConfiguration(lt.getLanguage());
            }
            catch (IOException e) {
                Tools.showError(e);
            }
            this.ltSupport.reloadConfig();
            this.stopServer();
            this.maybeStartServer();
            this.checkTextAndDisplayResults();
        }
    }

    private void showSelectFontDialog() {
        Configuration config = this.ltSupport.getConfig();
        if (this.fontChooserDialog == null) {
            this.fontChooserDialog = new FontChooser((Frame)this.frame, true);
            Tools.centerDialog(this.fontChooserDialog);
            this.fontChooserDialog.addPropertyChangeListener(this.textLineNumber);
        }
        this.fontChooserDialog.setSelectedFont(this.textArea.getFont());
        this.fontChooserDialog.setVisible(true);
        if (this.fontChooserDialog.getSelectedFont() != null) {
            this.textArea.setFont(this.fontChooserDialog.getSelectedFont());
            config.setFontName(this.fontChooserDialog.getSelectedFont().getFamily());
            config.setFontStyle(this.fontChooserDialog.getSelectedFont().getStyle());
            config.setFontSize(this.fontChooserDialog.getSelectedFont().getSize());
            try {
                config.saveConfiguration(this.ltSupport.getLanguage());
            }
            catch (IOException e) {
                Tools.showError(e);
            }
        }
    }

    private Component getFrame() {
        return this.frame;
    }

    private void updateTitle() {
        StringBuilder sb = new StringBuilder();
        if (this.currentFile != null) {
            sb.append(this.currentFile.getName());
            if (this.bom != null) {
                sb.append(" (").append(this.bom.getCharsetName()).append(')');
            }
            sb.append(" - ");
        }
        sb.append("LanguageTool ").append("5.4");
        this.frame.setTitle(sb.toString());
    }

    private void createGUI() {
        this.loadRecentFiles();
        this.frame = new JFrame("LanguageTool 5.4");
        this.setLookAndFeel();
        this.openAction = new OpenAction();
        this.saveAction = new SaveAction();
        this.saveAsAction = new SaveAsAction();
        this.checkAction = new CheckAction();
        this.autoCheckAction = new AutoCheckAction(true);
        this.showResultAction = new ShowResultAction(true);
        this.frame.setDefaultCloseOperation(0);
        this.frame.addWindowListener(new CloseListener());
        URL iconUrl = JLanguageTool.getDataBroker().getFromResourceDirAsUrl(TRAY_ICON);
        this.frame.setIconImage(new ImageIcon(iconUrl).getImage());
        this.textArea = new JTextArea();
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.textArea.addKeyListener(new ControlReturnTextCheckingListener());
        this.textLineNumber = new TextLineNumber(this.textArea, 2);
        this.numberedTextAreaPane = new JScrollPane(this.textArea);
        this.numberedTextAreaPane.setRowHeaderView(this.textLineNumber);
        this.resultArea = new JTextPane();
        this.undoRedo = new UndoRedoSupport(this.textArea, this.messages);
        this.frame.setJMenuBar(this.createMenuBar());
        GridBagConstraints buttonCons = new GridBagConstraints();
        JPanel insidePanel = new JPanel();
        insidePanel.setOpaque(false);
        insidePanel.setLayout(new GridBagLayout());
        buttonCons.gridx = 0;
        buttonCons.gridy = 0;
        buttonCons.anchor = 21;
        insidePanel.add((Component)new JLabel(this.messages.getString("textLanguage") + " "), buttonCons);
        this.languageBox = LanguageComboBox.create(this.messages, EXTERNAL_LANGUAGE_SUFFIX, true, false);
        buttonCons.gridx = 1;
        buttonCons.gridy = 0;
        buttonCons.anchor = 21;
        insidePanel.add((Component)this.languageBox, buttonCons);
        JCheckBox autoDetectBox = new JCheckBox(this.messages.getString("atd"));
        buttonCons.gridx = 2;
        buttonCons.gridy = 0;
        buttonCons.gridwidth = 0;
        buttonCons.anchor = 21;
        insidePanel.add((Component)autoDetectBox, buttonCons);
        buttonCons.gridx = 0;
        buttonCons.gridy = 1;
        buttonCons.gridwidth = 0;
        buttonCons.fill = 2;
        buttonCons.anchor = 22;
        buttonCons.weightx = 1.0;
        insidePanel.add((Component)this.statusLabel, buttonCons);
        Container contentPane = this.frame.getContentPane();
        GridBagLayout gridLayout = new GridBagLayout();
        contentPane.setLayout(gridLayout);
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.gridy = 1;
        cons.fill = 2;
        cons.anchor = 23;
        JToolBar toolbar = new JToolBar("Toolbar", 0);
        toolbar.setFloatable(false);
        contentPane.add((Component)toolbar, cons);
        JButton openButton = new JButton(this.openAction);
        openButton.setHideActionText(true);
        openButton.setFocusable(false);
        toolbar.add(openButton);
        JButton saveButton = new JButton(this.saveAction);
        saveButton.setHideActionText(true);
        saveButton.setFocusable(false);
        toolbar.add(saveButton);
        JButton saveAsButton = new JButton(this.saveAsAction);
        saveAsButton.setHideActionText(true);
        saveAsButton.setFocusable(false);
        toolbar.add(saveAsButton);
        JButton spellButton = new JButton(this.checkAction);
        spellButton.setHideActionText(true);
        spellButton.setFocusable(false);
        toolbar.add(spellButton);
        JToggleButton autoSpellButton = new JToggleButton(this.autoCheckAction);
        autoSpellButton.setHideActionText(true);
        autoSpellButton.setFocusable(false);
        toolbar.add(autoSpellButton);
        JButton clearTextButton = new JButton(new ClearTextAction());
        clearTextButton.setHideActionText(true);
        clearTextButton.setFocusable(false);
        toolbar.add(clearTextButton);
        cons.insets = new Insets(5, 5, 5, 5);
        cons.fill = 1;
        cons.weightx = 10.0;
        cons.weighty = 10.0;
        cons.gridx = 0;
        cons.gridy = 2;
        cons.weighty = 5.0;
        this.splitPane = new JSplitPane(0, this.numberedTextAreaPane, new JScrollPane(this.resultArea));
        this.mainPanel.setLayout(new GridLayout(0, 1));
        contentPane.add((Component)this.mainPanel, cons);
        this.mainPanel.add(this.splitPane);
        cons.fill = 2;
        cons.gridx = 0;
        cons.gridy = 3;
        cons.weightx = 1.0;
        cons.weighty = 0.0;
        cons.insets = new Insets(4, 12, 4, 12);
        contentPane.add((Component)insidePanel, cons);
        this.ltSupport = new LanguageToolSupport(this.frame, this.textArea, this.undoRedo);
        ResultAreaHelper.install(this.messages, this.ltSupport, this.resultArea);
        this.languageBox.selectLanguage(this.ltSupport.getLanguage());
        this.languageBox.setEnabled(!this.ltSupport.getConfig().getAutoDetect());
        autoDetectBox.setSelected(this.ltSupport.getConfig().getAutoDetect());
        this.taggerShowsDisambigLog = this.ltSupport.getConfig().getTaggerShowsDisambigLog();
        this.languageBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Main.this.frame.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
                    Language lang = Main.this.languageBox.getSelectedLanguage();
                    ComponentOrientation componentOrientation = ComponentOrientation.getOrientation(lang.getLocale());
                    Main.this.textArea.applyComponentOrientation(componentOrientation);
                    Main.this.resultArea.applyComponentOrientation(componentOrientation);
                    Main.this.ltSupport.setLanguage(lang);
                }
            }
        });
        autoDetectBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean selected = e.getStateChange() == 1;
                Main.this.languageBox.setEnabled(!selected);
                Main.this.ltSupport.getConfig().setAutoDetect(selected);
                if (selected) {
                    Language detected = Main.this.ltSupport.autoDetectLanguage(Main.this.textArea.getText());
                    Main.this.languageBox.selectLanguage(detected);
                }
            }
        });
        this.ltSupport.addLanguageToolListener(new LanguageToolListener(){

            @Override
            public void languageToolEventOccurred(LanguageToolEvent event) {
                if (event.getType() == LanguageToolEvent.Type.CHECKING_STARTED) {
                    String msg = org.languagetool.tools.Tools.i18n(Main.this.messages, "checkStart", new Object[0]);
                    Main.this.statusLabel.setText(msg);
                    if (event.getCaller() == Main.this.getFrame()) {
                        Main.this.setWaitCursor();
                        Main.this.checkAction.setEnabled(false);
                    }
                } else if (event.getType() == LanguageToolEvent.Type.CHECKING_FINISHED) {
                    if (event.getCaller() == Main.this.getFrame()) {
                        Main.this.checkAction.setEnabled(true);
                        Main.this.unsetWaitCursor();
                    }
                    String msg = org.languagetool.tools.Tools.i18n(Main.this.messages, "checkDone", event.getSource().getMatches().size(), event.getElapsedTime());
                    Main.this.statusLabel.setText(msg);
                } else if (event.getType() == LanguageToolEvent.Type.LANGUAGE_CHANGED) {
                    Main.this.languageBox.selectLanguage(Main.this.ltSupport.getLanguage());
                } else if (event.getType() != LanguageToolEvent.Type.RULE_ENABLED && event.getType() == LanguageToolEvent.Type.RULE_DISABLED) {
                    String msg = org.languagetool.tools.Tools.i18n(Main.this.messages, "checkDoneNoTime", event.getSource().getMatches().size());
                    Main.this.statusLabel.setText(msg);
                }
            }
        });
        this.frame.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
        Language lang = this.ltSupport.getLanguage();
        ComponentOrientation componentOrientation = ComponentOrientation.getOrientation(lang.getLocale());
        this.textArea.applyComponentOrientation(componentOrientation);
        this.resultArea.applyComponentOrientation(componentOrientation);
        ResourceBundle textLanguageMessageBundle = JLanguageTool.getMessageBundle(this.ltSupport.getLanguage());
        this.textArea.setText(textLanguageMessageBundle.getString("guiDemoText"));
        Configuration config = this.ltSupport.getConfig();
        if (config.getFontName() != null || config.getFontStyle() != -1 || config.getFontSize() != -1) {
            int fontSize;
            String fontName = config.getFontName();
            if (fontName == null) {
                fontName = this.textArea.getFont().getFamily();
            }
            if ((fontSize = config.getFontSize()) == -1) {
                fontSize = this.textArea.getFont().getSize();
            }
            Font font = new Font(fontName, config.getFontStyle(), fontSize);
            this.textArea.setFont(font);
        }
        this.frame.pack();
        this.frame.setSize(600, 550);
        this.frame.setLocationByPlatform(true);
        this.splitPane.setDividerLocation(200);
        MainWindowStateBean state = this.localStorage.loadProperty(GUI_STATE, MainWindowStateBean.class);
        if (state != null) {
            if (state.getBounds() != null) {
                this.frame.setBounds(state.getBounds());
                ResizeComponentListener.setBoundsProperty(this.frame, state.getBounds());
            }
            if (state.getDividerLocation() != null) {
                this.splitPane.setDividerLocation(state.getDividerLocation());
            }
            if (state.getState() != null) {
                this.frame.setExtendedState(state.getState());
            }
        }
        ResizeComponentListener.attachToWindow(this.frame);
        this.maybeStartServer();
    }

    private String getLabel(String key) {
        return Tools.getLabel(this.messages.getString(key));
    }

    private int getMnemonic(String key) {
        return Tools.getMnemonic(this.messages.getString(key));
    }

    private KeyStroke getMenuKeyStroke(int keyEvent) {
        return KeyStroke.getKeyStroke(keyEvent, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    }

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu(this.getLabel("guiMenuFile"));
        fileMenu.setMnemonic(this.getMnemonic("guiMenuFile"));
        JMenu editMenu = new JMenu(this.getLabel("guiMenuEdit"));
        editMenu.setMnemonic(this.getMnemonic("guiMenuEdit"));
        JMenu grammarMenu = new JMenu(this.getLabel("guiMenuGrammar"));
        grammarMenu.setMnemonic(this.getMnemonic("guiMenuGrammar"));
        JMenu helpMenu = new JMenu(this.getLabel("guiMenuHelp"));
        helpMenu.setMnemonic(this.getMnemonic("guiMenuHelp"));
        fileMenu.add(this.openAction);
        fileMenu.add(this.saveAction);
        fileMenu.add(this.saveAsAction);
        this.recentFilesMenu = new JMenu(this.getLabel("guiMenuRecentFiles"));
        this.recentFilesMenu.setMnemonic(this.getMnemonic("guiMenuRecentFiles"));
        fileMenu.add(this.recentFilesMenu);
        this.updateRecentFilesMenu();
        fileMenu.addSeparator();
        fileMenu.add(new HideAction());
        fileMenu.addSeparator();
        fileMenu.add(new QuitAction());
        grammarMenu.add(this.checkAction);
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(this.autoCheckAction);
        grammarMenu.add(item);
        JCheckBoxMenuItem showResult = new JCheckBoxMenuItem(this.showResultAction);
        grammarMenu.add(showResult);
        grammarMenu.add(new CheckClipboardAction());
        grammarMenu.add(new TagTextAction());
        grammarMenu.add(new AddRulesAction());
        grammarMenu.add(new OptionsAction());
        grammarMenu.add(new SelectFontAction());
        JMenu lafMenu = new JMenu(this.messages.getString("guiLookAndFeelMenu"));
        UIManager.LookAndFeelInfo[] lafInfo = UIManager.getInstalledLookAndFeels();
        ButtonGroup buttonGroup = new ButtonGroup();
        for (UIManager.LookAndFeelInfo laf : lafInfo) {
            if (!"Nimbus".equals(laf.getName())) continue;
            this.addLookAndFeelMenuItem(lafMenu, laf, buttonGroup);
        }
        for (UIManager.LookAndFeelInfo laf : lafInfo) {
            if ("Nimbus".equals(laf.getName())) continue;
            this.addLookAndFeelMenuItem(lafMenu, laf, buttonGroup);
        }
        grammarMenu.add(lafMenu);
        helpMenu.add(new AboutAction());
        this.undoRedo.undoAction.putValue("Name", this.getLabel("guiMenuUndo"));
        this.undoRedo.undoAction.putValue("MnemonicKey", this.getMnemonic("guiMenuUndo"));
        this.undoRedo.redoAction.putValue("Name", this.getLabel("guiMenuRedo"));
        this.undoRedo.redoAction.putValue("MnemonicKey", this.getMnemonic("guiMenuRedo"));
        editMenu.add(this.undoRedo.undoAction);
        editMenu.add(this.undoRedo.redoAction);
        editMenu.addSeparator();
        DefaultEditorKit.CutAction cutAction = new DefaultEditorKit.CutAction();
        cutAction.putValue("SmallIcon", this.getImageIcon("sc_cut.png"));
        cutAction.putValue("SwingLargeIconKey", this.getImageIcon("lc_cut.png"));
        cutAction.putValue("Name", this.getLabel("guiMenuCut"));
        cutAction.putValue("MnemonicKey", 84);
        editMenu.add(cutAction);
        DefaultEditorKit.CopyAction copyAction = new DefaultEditorKit.CopyAction();
        copyAction.putValue("SmallIcon", this.getImageIcon("sc_copy.png"));
        copyAction.putValue("SwingLargeIconKey", this.getImageIcon("lc_copy.png"));
        copyAction.putValue("Name", this.getLabel("guiMenuCopy"));
        copyAction.putValue("MnemonicKey", 67);
        editMenu.add(copyAction);
        DefaultEditorKit.PasteAction pasteAction = new DefaultEditorKit.PasteAction();
        pasteAction.putValue("SmallIcon", this.getImageIcon("sc_paste.png"));
        pasteAction.putValue("SwingLargeIconKey", this.getImageIcon("lc_paste.png"));
        pasteAction.putValue("Name", this.getLabel("guiMenuPaste"));
        pasteAction.putValue("MnemonicKey", 80);
        editMenu.add(pasteAction);
        editMenu.addSeparator();
        editMenu.add(new SelectAllAction());
        menuBar.add(fileMenu);
        menuBar.add(editMenu);
        menuBar.add(grammarMenu);
        menuBar.add(helpMenu);
        return menuBar;
    }

    private void updateRecentFilesMenu() {
        this.recentFilesMenu.removeAll();
        Object[] files = this.recentFiles.toArray(new String[0]);
        ArrayUtils.reverse(files);
        for (Object filename : files) {
            this.recentFilesMenu.add(new RecentFileAction(new File((String)filename)));
        }
    }

    private void loadRecentFiles() {
        CircularFifoQueue l = this.localStorage.loadProperty("recentFiles", CircularFifoQueue.class);
        if (l != null) {
            for (String name : l) {
                File f = new File(name);
                if (!f.exists() || !f.isFile()) continue;
                this.recentFiles.add(name);
            }
        }
    }

    private void addLookAndFeelMenuItem(JMenu lafMenu, UIManager.LookAndFeelInfo laf, ButtonGroup buttonGroup) {
        JRadioButtonMenuItem lfItem = new JRadioButtonMenuItem(new SelectLFAction(laf));
        lafMenu.add(lfItem);
        buttonGroup.add(lfItem);
        if (laf.getClassName().equals(UIManager.getLookAndFeel().getClass().getName())) {
            buttonGroup.setSelected(lfItem.getModel(), true);
        }
    }

    private void setLookAndFeel() {
        String lookAndFeelName = null;
        String className = null;
        try {
            Configuration config = new Configuration(new File(System.getProperty("user.home")), ".languagetool.cfg", null);
            if (config.getLookAndFeelName() != null) {
                lookAndFeelName = config.getLookAndFeelName();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (lookAndFeelName == null) {
            lookAndFeelName = "Nimbus";
        }
        for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
            if (!lookAndFeelName.equals(info.getName())) continue;
            className = info.getClassName();
            break;
        }
        if (className != null) {
            try {
                UIManager.setLookAndFeel(className);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private PopupMenu makePopupMenu() {
        PopupMenu popup = new PopupMenu();
        TrayActionRMBListener rmbListener = new TrayActionRMBListener();
        this.enableHttpServerItem = new CheckboxMenuItem(Tools.getLabel(this.messages.getString("tray_menu_enable_server")));
        this.enableHttpServerItem.setState(this.httpServer != null && this.httpServer.isRunning());
        this.enableHttpServerItem.addItemListener(new TrayActionItemListener());
        popup.add(this.enableHttpServerItem);
        MenuItem checkClipboardItem = new MenuItem(Tools.getLabel(this.messages.getString("guiMenuCheckClipboard")));
        checkClipboardItem.addActionListener(rmbListener);
        popup.add(checkClipboardItem);
        MenuItem restoreItem = new MenuItem(Tools.getLabel(this.messages.getString("guiMenuShowMainWindow")));
        restoreItem.addActionListener(rmbListener);
        popup.add(restoreItem);
        MenuItem exitItem = new MenuItem(Tools.getLabel(this.messages.getString("guiMenuQuit")));
        exitItem.addActionListener(rmbListener);
        popup.add(exitItem);
        return popup;
    }

    private void checkClipboardText() {
        String s = this.getClipboardText();
        this.textArea.setText(s);
    }

    private void hideToTray() {
        if (!this.isInTray) {
            SystemTray tray = SystemTray.getSystemTray();
            String iconPath = tray.getTrayIconSize().height > 16 ? TRAY_ICON : TRAY_SMALL_ICON;
            URL iconUrl = JLanguageTool.getDataBroker().getFromResourceDirAsUrl(iconPath);
            Image img = Toolkit.getDefaultToolkit().getImage(iconUrl);
            PopupMenu popup = this.makePopupMenu();
            try {
                this.trayIcon = new TrayIcon(img, TRAY_TOOLTIP, popup);
                this.trayIcon.addMouseListener(new TrayActionListener());
                this.setTrayIcon();
                tray.add(this.trayIcon);
            }
            catch (AWTException e1) {
                Tools.showError(e1);
            }
        }
        this.isInTray = true;
        this.frame.setVisible(false);
    }

    private void tagText() {
        if (StringTools.isEmpty(this.textArea.getText().trim())) {
            this.textArea.setText(this.messages.getString("enterText2"));
            return;
        }
        this.setWaitCursor();
        new Thread(){

            @Override
            public void run() {
                try {
                    Main.this.tagTextAndDisplayResults();
                }
                finally {
                    SwingUtilities.invokeLater(() -> Main.this.unsetWaitCursor());
                }
            }
        }.start();
    }

    private void quitOrHide() {
        if (this.closeHidesToTray) {
            this.hideToTray();
        } else {
            this.quit();
        }
    }

    private void quit() {
        this.stopServer();
        try {
            Configuration config = this.ltSupport.getConfig();
            config.setLanguage(this.ltSupport.getLanguage());
            config.saveConfiguration(this.ltSupport.getLanguage());
        }
        catch (IOException e) {
            Tools.showError(e);
        }
        MainWindowStateBean bean = new MainWindowStateBean();
        bean.setBounds(ResizeComponentListener.getBoundsProperty(this.frame));
        bean.setState(this.frame.getExtendedState());
        Component comp = this.mainPanel.getComponent(0);
        if (comp instanceof JSplitPane) {
            bean.setDividerLocation(((JSplitPane)comp).getDividerLocation());
        } else {
            MainWindowStateBean old = this.localStorage.loadProperty(GUI_STATE, MainWindowStateBean.class);
            bean.setDividerLocation(old.getDividerLocation());
        }
        this.localStorage.saveProperty(GUI_STATE, bean);
        this.frame.setVisible(false);
        JLanguageTool.removeTemporaryFiles();
        System.exit(0);
    }

    private void setTrayIcon() {
        if (this.trayIcon != null) {
            String iconPath;
            boolean smallTray;
            SystemTray tray = SystemTray.getSystemTray();
            boolean httpServerRunning = this.httpServer != null && this.httpServer.isRunning();
            boolean bl = smallTray = tray.getTrayIconSize().height <= 16;
            if (httpServerRunning) {
                this.trayIcon.setToolTip(this.messages.getString("tray_tooltip_server_running"));
                iconPath = smallTray ? TRAY_SMALL_SERVER_ICON : TRAY_SERVER_ICON;
            } else {
                this.trayIcon.setToolTip(TRAY_TOOLTIP);
                iconPath = smallTray ? TRAY_SMALL_ICON : TRAY_ICON;
            }
            URL iconUrl = JLanguageTool.getDataBroker().getFromResourceDirAsUrl(iconPath);
            Image img = Toolkit.getDefaultToolkit().getImage(iconUrl);
            this.trayIcon.setImage(img);
        }
    }

    private void showGUI() {
        this.frame.setVisible(true);
    }

    private void restoreFromTray() {
        this.frame.setVisible(true);
    }

    private void restoreFromTrayAndCheck() {
        String s = this.getClipboardText();
        this.restoreFromTray();
        this.textArea.setText(s);
    }

    private String getClipboardText() {
        String s;
        block16: {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemSelection();
            if (clipboard == null) {
                clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            }
            Transferable data = clipboard.getContents(this);
            try {
                if (data != null && data.isDataFlavorSupported(DataFlavor.getTextPlainUnicodeFlavor())) {
                    DataFlavor df = DataFlavor.getTextPlainUnicodeFlavor();
                    try (Reader sr = df.getReaderForText(data);){
                        s = StringTools.readerToString(sr);
                        break block16;
                    }
                }
                s = "";
            }
            catch (Exception ex) {
                s = data.toString();
            }
        }
        return s;
    }

    private boolean maybeStartServer() {
        Configuration config = this.ltSupport.getConfig();
        if (config.getRunServer()) {
            try {
                HTTPServerConfig serverConfig = new HTTPServerConfig(config.getServerPort(), false);
                serverConfig.setAllowOriginUrl("*");
                if (config.getNgramDirectory() != null) {
                    serverConfig.setLanguageModelDirectory(config.getNgramDirectory().getAbsolutePath());
                }
                this.httpServer = new HTTPServer(serverConfig, true);
                this.httpServer.run();
                if (this.enableHttpServerItem != null) {
                    this.enableHttpServerItem.setState(this.httpServer.isRunning());
                    this.setTrayIcon();
                }
            }
            catch (PortBindingException e) {
                JOptionPane.showMessageDialog(null, e.getMessage(), "Error", 0);
            }
        }
        return this.httpServer != null && this.httpServer.isRunning();
    }

    private void stopServer() {
        if (this.httpServer != null) {
            this.httpServer.stop();
            if (this.enableHttpServerItem != null) {
                this.enableHttpServerItem.setState(this.httpServer.isRunning());
                this.setTrayIcon();
            }
            this.httpServer = null;
        }
    }

    private void checkTextAndDisplayResults() {
        if (StringTools.isEmpty(this.textArea.getText().trim())) {
            this.textArea.setText(this.messages.getString("enterText2"));
            return;
        }
        this.ltSupport.checkImmediately(this.getFrame());
    }

    private String getStackTraceAsHtml(Exception e) {
        return "<br><br><b><font color=\"red\">" + org.languagetool.tools.Tools.getFullStackTrace(e).replace("\n", "<br/>") + "</font></b><br>";
    }

    private void setWaitCursor() {
        this.frame.setCursor(Cursor.getPredefinedCursor(3));
        this.textArea.setCursor(Cursor.getPredefinedCursor(3));
        this.resultArea.setCursor(Cursor.getPredefinedCursor(3));
    }

    private void unsetWaitCursor() {
        this.frame.setCursor(Cursor.getDefaultCursor());
        this.textArea.setCursor(Cursor.getDefaultCursor());
        this.resultArea.setCursor(Cursor.getDefaultCursor());
    }

    private boolean appendTagsWithDisambigLog(StringBuilder sb, AnalyzedSentence sentence, boolean odd) {
        for (AnalyzedTokenReadings t : sentence.getTokens()) {
            if (t.isWhitespace() && !t.isSentenceStart()) continue;
            odd = !odd;
            sb.append("<tr>");
            sb.append("<td bgcolor=\"");
            if (odd) {
                sb.append("#ffffff");
            } else {
                sb.append("#f1f1f1");
            }
            sb.append("\">");
            if (!t.isWhitespace()) {
                sb.append(t.getToken());
                sb.append("<font color='");
                sb.append(TAG_COLOR);
                sb.append("'>[");
            }
            Iterator<AnalyzedToken> iterator = t.iterator();
            while (iterator.hasNext()) {
                AnalyzedToken token = iterator.next();
                String posTag = token.getPOSTag();
                if (t.isSentenceStart()) {
                    sb.append(StringTools.escapeHTML("<S>"));
                    continue;
                }
                if ("SENT_END".equals(posTag)) {
                    sb.append(StringTools.escapeHTML("</S>"));
                    continue;
                }
                if ("PARA_END".equals(posTag)) {
                    sb.append(StringTools.escapeHTML("<P/>"));
                    continue;
                }
                if (t.isWhitespace()) continue;
                sb.append(token);
                if (!iterator.hasNext()) continue;
                sb.append(", ");
            }
            if (!t.isWhitespace()) {
                if (t.getChunkTags().size() > 0) {
                    sb.append(',');
                    sb.append(StringUtils.join(t.getChunkTags(), "|"));
                }
                if (t.isImmunized()) {
                    sb.append("{!}");
                }
                sb.append("]</font>");
            } else {
                sb.append(' ');
            }
            sb.append("</td>");
            sb.append("<td bgcolor=\"");
            if (odd) {
                sb.append("#ffffff");
            } else {
                sb.append("#f1f1f1");
            }
            sb.append("\">");
            if (!"".equals(t.getHistoricalAnnotations())) {
                sb.append(StringTools.escapeHTML(t.getHistoricalAnnotations()).trim().replace("\n", "<br>"));
            }
            sb.append("</td>");
            sb.append("</tr>");
        }
        return odd;
    }

    private void tagTextAndDisplayResults() {
        JLanguageTool lt = this.ltSupport.getLanguageTool();
        List<String> sentences = lt.sentenceTokenize(this.textArea.getText());
        final StringBuilder sb = new StringBuilder();
        if (this.taggerShowsDisambigLog) {
            sb.append("<table>");
            sb.append("<tr>");
            sb.append("<td><b>");
            sb.append(this.messages.getString("token"));
            sb.append("</b></td>");
            sb.append("<td><b>");
            sb.append(this.messages.getString("disambiguatorLog"));
            sb.append("</b></td>");
            sb.append("</tr>");
            boolean odd = true;
            try {
                for (String sent : sentences) {
                    AnalyzedSentence analyzed = lt.getAnalyzedSentence(sent);
                    odd = this.appendTagsWithDisambigLog(sb, analyzed, odd);
                }
            }
            catch (Exception e) {
                sb.append(this.getStackTraceAsHtml(e));
            }
            sb.append("</table>");
        } else {
            try {
                for (String sent : sentences) {
                    AnalyzedSentence analyzed = lt.getAnalyzedSentence(sent);
                    String analyzedString = StringTools.escapeHTML(analyzed.toString(",")).replace("&lt;S&gt;", "&lt;S&gt;<br>").replace("[", "<font color='#888888'>[").replace("]", "]</font><br>");
                    sb.append(analyzedString).append('\n');
                }
            }
            catch (Exception e) {
                sb.append(this.getStackTraceAsHtml(e));
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (Main.this.taggerDialog == null) {
                    Main.this.taggerDialog = new JDialog(Main.this.frame);
                    Main.this.taggerDialog.setTitle(Main.this.messages.getString("taggerWindowTitle"));
                    Main.this.taggerDialog.setDefaultCloseOperation(1);
                    Main.this.taggerDialog.setResizable(true);
                    Main.this.taggerDialog.setSize(640, 480);
                    Main.this.taggerDialog.setLocationRelativeTo(Main.this.frame);
                    KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
                    ActionListener actionListener = actionEvent -> Main.this.taggerDialog.setVisible(false);
                    Main.this.taggerDialog.getRootPane().registerKeyboardAction(actionListener, stroke, 2);
                    JPanel panel = new JPanel(new GridBagLayout());
                    Main.this.taggerDialog.add(panel);
                    Main.this.taggerArea = new JTextPane();
                    Main.this.taggerArea.setContentType("text/html");
                    Main.this.taggerArea.setEditable(false);
                    GridBagConstraints c = new GridBagConstraints();
                    c.gridx = 0;
                    c.gridwidth = 2;
                    c.gridy = 0;
                    c.weightx = 1.0;
                    c.weighty = 1.0;
                    c.insets = new Insets(8, 8, 4, 8);
                    c.fill = 1;
                    panel.add((Component)new JScrollPane(Main.this.taggerArea), c);
                    c.gridwidth = 1;
                    c.gridx = 0;
                    c.gridy = 1;
                    c.weightx = 0.0;
                    c.weighty = 0.0;
                    c.insets = new Insets(4, 8, 8, 8);
                    c.fill = 0;
                    c.anchor = 13;
                    JCheckBox showDisAmbig = new JCheckBox(Main.this.messages.getString("ShowDisambiguatorLog"));
                    showDisAmbig.setSelected(Main.this.taggerShowsDisambigLog);
                    showDisAmbig.addItemListener(e -> {
                        Main.this.taggerShowsDisambigLog = e.getStateChange() == 1;
                        Main.this.ltSupport.getConfig().setTaggerShowsDisambigLog(Main.this.taggerShowsDisambigLog);
                    });
                    panel.add((Component)showDisAmbig, c);
                    c.gridx = 1;
                    JButton closeButton = new JButton(Main.this.messages.getString("guiCloseButton"));
                    closeButton.addActionListener(actionListener);
                    panel.add((Component)closeButton, c);
                }
                Main.this.taggerDialog.applyComponentOrientation(ComponentOrientation.getOrientation(Main.this.languageBox.getSelectedLanguage().getLocale()));
                Main.this.taggerDialog.setVisible(true);
                Main.this.taggerArea.setText(Main.HTML_FONT_START + sb + Main.HTML_FONT_END);
            }
        });
    }

    private void setResultAreaVisible(boolean enable) {
        if (enable) {
            this.mainPanel.removeAll();
            this.mainPanel.add(this.splitPane);
            this.splitPane.setTopComponent(this.numberedTextAreaPane);
            this.splitPane.setDividerLocation(200);
            MainWindowStateBean state = this.localStorage.loadProperty(GUI_STATE, MainWindowStateBean.class);
            if (state != null && state.getDividerLocation() != null) {
                this.splitPane.setDividerLocation(state.getDividerLocation());
            }
            ResultAreaHelper.enable(this.resultArea);
        } else {
            MainWindowStateBean bean = new MainWindowStateBean();
            bean.setDividerLocation(this.splitPane.getDividerLocation());
            this.localStorage.saveProperty(GUI_STATE, bean);
            this.mainPanel.removeAll();
            this.splitPane.setTopComponent(null);
            this.mainPanel.add(this.numberedTextAreaPane);
            ResultAreaHelper.disable(this.resultArea);
        }
        this.mainPanel.validate();
    }

    private void setTrayMode(boolean trayMode) {
        this.closeHidesToTray = trayMode;
    }

    public static void main(final String[] args) {
        LocalStorage localStorage;
        LocaleBean bean;
        if (System.getSecurityManager() == null) {
            JnaTools.setBugWorkaroundProperty();
        }
        if ((bean = (localStorage = new LocalStorage()).loadProperty("gui.locale", LocaleBean.class)) != null) {
            Locale.setDefault(bean.asLocale());
        }
        final Main prg = new Main(localStorage);
        if (args.length == 1 && (args[0].equals("-t") || args[0].equals("--tray"))) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        prg.createGUI();
                        prg.setTrayMode(true);
                        prg.hideToTray();
                    }
                    catch (Exception e) {
                        Tools.showError(e);
                        System.exit(1);
                    }
                }
            });
        } else if (args.length == 1 && (args[0].equals("-h") || args[0].equals("--help"))) {
            Main.printUsage();
        } else if (args.length == 0 || args.length == 1) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        prg.createGUI();
                        prg.showGUI();
                        if (args.length == 1) {
                            prg.loadFile(new File(args[0]));
                        }
                    }
                    catch (Exception e) {
                        Tools.showError(e);
                    }
                }
            });
        } else {
            Main.printUsage();
            System.exit(1);
        }
    }

    private static void printUsage() {
        System.out.println("Usage: java org.languagetool.gui.Main [-t|--tray]");
        System.out.println("    or java org.languagetool.gui.Main [file]");
        System.out.println("Parameters:");
        System.out.println("    -t, --tray: dock LanguageTool to system tray on startup");
        System.out.println("    file:       a plain text file to load on startup");
    }

    private ImageIcon getImageIcon(String filename) {
        Image image = Toolkit.getDefaultToolkit().getImage(JLanguageTool.getDataBroker().getFromResourceDirAsUrl(filename));
        return new ImageIcon(image);
    }

    private ConfigurationDialog getCurrentConfigDialog() {
        ConfigurationDialog configDialog;
        Language language = this.ltSupport.getLanguage();
        if (this.configDialogs.containsKey(language)) {
            configDialog = this.configDialogs.get(language);
        } else {
            configDialog = new ConfigurationDialog(this.frame, false, this.ltSupport.getConfig());
            configDialog.addExtraPanel(new GuiLangConfigPanel(this.messages, this.localStorage));
            this.configDialogs.put(language, configDialog);
        }
        return configDialog;
    }

    public class TextLineNumber
    extends JPanel
    implements CaretListener,
    DocumentListener,
    ComponentListener,
    PropertyChangeListener {
        private static final long serialVersionUID = 1L;
        public static final float LEFT = 0.0f;
        public static final float CENTER = 0.5f;
        public static final float RIGHT = 1.0f;
        private final Border OUTER = new MatteBorder(0, 0, 0, 1, Color.GRAY);
        private final JTextComponent component;
        private int borderGap;
        private Color currentLineForeground;
        private float digitAlignment;
        private int minimumDisplayDigits;
        private int lastLine;

        public TextLineNumber(JTextComponent component, int minimumDisplayDigits) {
            this.component = component;
            this.setFont(component.getFont());
            this.setBorderGap(5);
            this.setCurrentLineForeground(Color.RED);
            this.setDigitAlignment(1.0f);
            this.setMinimumDisplayDigits(minimumDisplayDigits);
            component.getDocument().addDocumentListener(this);
            component.addCaretListener(this);
            component.addPropertyChangeListener("font", this);
            component.addComponentListener(this);
        }

        public int getBorderGap() {
            return this.borderGap;
        }

        public void setBorderGap(int borderGap) {
            this.borderGap = borderGap;
            EmptyBorder inner = new EmptyBorder(0, borderGap, 0, borderGap);
            this.setBorder(new CompoundBorder(this.OUTER, inner));
            this.setPreferredWidth();
        }

        public Color getCurrentLineForeground() {
            return this.currentLineForeground == null ? this.getForeground() : this.currentLineForeground;
        }

        public void setCurrentLineForeground(Color currentLineForeground) {
            this.currentLineForeground = currentLineForeground;
        }

        public float getDigitAlignment() {
            return this.digitAlignment;
        }

        public void setDigitAlignment(float digitAlignment) {
            this.digitAlignment = digitAlignment > 1.0f ? 1.0f : (digitAlignment < 0.0f ? -1.0f : digitAlignment);
        }

        public int getMinimumDisplayDigits() {
            return this.minimumDisplayDigits;
        }

        public void setMinimumDisplayDigits(int minimumDisplayDigits) {
            this.minimumDisplayDigits = minimumDisplayDigits;
            this.setPreferredWidth();
        }

        private void setPreferredWidth() {
            Element root = this.component.getDocument().getDefaultRootElement();
            int lines = root.getElementCount();
            int digits = Math.max(String.valueOf(lines).length(), this.minimumDisplayDigits);
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int width = fontMetrics.charWidth('0') * digits;
            Insets insets = this.getInsets();
            int preferredWidth = insets.left + insets.right + width;
            Dimension d = this.getPreferredSize();
            d.setSize(preferredWidth, this.component.getHeight());
            this.setPreferredSize(d);
            this.setSize(d);
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            FontMetrics fontMetrics = this.component.getFontMetrics(this.component.getFont());
            Insets insets = this.getInsets();
            int availableWidth = this.getSize().width - insets.left - insets.right;
            Rectangle clip = g.getClipBounds();
            int rowStartOffset = this.component.viewToModel(new Point(0, clip.y));
            int endOffset = this.component.viewToModel(new Point(0, clip.y + clip.height));
            while (rowStartOffset <= endOffset) {
                try {
                    if (this.isCurrentLine(rowStartOffset)) {
                        g.setColor(this.getCurrentLineForeground());
                    } else {
                        g.setColor(this.getForeground());
                    }
                    String lineNumber = this.getTextLineNumber(rowStartOffset);
                    if (!lineNumber.isEmpty()) {
                        int stringWidth = fontMetrics.stringWidth(lineNumber);
                        int x = this.getOffsetX(availableWidth, stringWidth) + insets.left;
                        int y = this.getOffsetY(rowStartOffset, fontMetrics);
                        g.drawString(lineNumber, x, y);
                    }
                    rowStartOffset = Utilities.getRowEnd(this.component, rowStartOffset) + 1;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
        }

        private boolean isCurrentLine(int rowStartOffset) {
            int caretPosition = this.component.getCaretPosition();
            Element root = this.component.getDocument().getDefaultRootElement();
            return root.getElementIndex(rowStartOffset) == root.getElementIndex(caretPosition);
        }

        protected String getTextLineNumber(int rowStartOffset) {
            int index;
            Element root = this.component.getDocument().getDefaultRootElement();
            Element line = root.getElement(index = root.getElementIndex(rowStartOffset));
            if (line.getStartOffset() == rowStartOffset) {
                return String.valueOf(index + 1);
            }
            return "";
        }

        private int getOffsetX(int availableWidth, int stringWidth) {
            return (int)((float)(availableWidth - stringWidth) * this.digitAlignment);
        }

        private int getOffsetY(int rowStartOffset, FontMetrics fontMetrics) throws BadLocationException {
            Rectangle r = this.component.modelToView(rowStartOffset);
            int y = r.y + r.height;
            return y - fontMetrics.getDescent();
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            int caretPosition = this.component.getCaretPosition();
            Element root = this.component.getDocument().getDefaultRootElement();
            int currentLine = root.getElementIndex(caretPosition);
            if (this.lastLine != currentLine) {
                this.setPreferredWidth();
                this.documentChanged();
                this.lastLine = currentLine;
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.setPreferredWidth();
            this.documentChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.documentChanged();
        }

        private void documentChanged() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TextLineNumber.this.repaint();
                }
            });
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getNewValue() instanceof Font) {
                Font newFont = (Font)evt.getNewValue();
                this.setFont(newFont);
                this.setPreferredWidth();
                this.documentChanged();
            }
        }

        @Override
        public void componentResized(ComponentEvent e) {
            this.setPreferredWidth();
            this.documentChanged();
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
            this.setPreferredWidth();
            this.documentChanged();
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }
    }

    class ShowResultAction
    extends AbstractAction {
        private boolean enable;

        ShowResultAction(boolean initial) {
            super(Main.this.getLabel("guiShowResultArea"));
            this.putValue("ShortDescription", Main.this.messages.getString("guiShowResultArea"));
            this.putValue("LongDescription", Main.this.messages.getString("guiShowResultArea"));
            this.putValue("MnemonicKey", Main.this.getMnemonic("guiShowResultArea"));
            this.enable = initial;
            this.putValue("SwingSelectedKey", this.enable);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.enable = !this.enable;
            this.putValue("SwingSelectedKey", this.enable);
            Main.this.setResultAreaVisible(this.enable);
        }
    }

    class RecentFileAction
    extends AbstractAction {
        private final File file;

        RecentFileAction(File file) {
            super(file.getName());
            this.file = file;
            this.putValue("ShortDescription", file.getAbsolutePath());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.file.exists()) {
                Main.this.loadFile(this.file);
            } else {
                JOptionPane.showMessageDialog(Main.this.frame, Main.this.messages.getString("guiFileNotFound"), Main.this.messages.getString("dialogTitleError"), 0);
                Main.this.recentFiles.remove(this.file.getAbsolutePath());
                Main.this.updateRecentFilesMenu();
            }
        }
    }

    private class SelectAllAction
    extends TextAction {
        private SelectAllAction() {
            super(Main.this.getLabel("guiMenuSelectAll"));
            this.putValue("MnemonicKey", 65);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent component = this.getFocusedComponent();
            component.selectAll();
        }
    }

    class ClearTextAction
    extends AbstractAction {
        ClearTextAction() {
            super(Main.this.getLabel("clearText"));
            this.putValue("ShortDescription", Main.this.messages.getString("clearText"));
            this.putValue("SmallIcon", Main.this.getImageIcon("sc_closedoc.png"));
            this.putValue("SwingLargeIconKey", Main.this.getImageIcon("lc_closedoc.png"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Main.this.ltSupport.getTextComponent().setText("");
        }
    }

    class AutoCheckAction
    extends AbstractAction {
        private boolean enable;

        AutoCheckAction(boolean initial) {
            super(Main.this.getLabel("autoCheckText"));
            this.putValue("ShortDescription", Main.this.messages.getString("autoCheckTextShortDesc"));
            this.putValue("LongDescription", Main.this.messages.getString("autoCheckTextLongDesc"));
            this.putValue("MnemonicKey", Main.this.getMnemonic("autoCheckText"));
            this.putValue("SmallIcon", Main.this.getImageIcon("sc_spellonline.png"));
            this.putValue("SwingLargeIconKey", Main.this.getImageIcon("lc_spellonline.png"));
            this.enable = initial;
            this.putValue("SwingSelectedKey", this.enable);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.enable = !this.enable;
            this.putValue("SwingSelectedKey", this.enable);
            Main.this.ltSupport.setBackgroundCheckEnabled(this.enable);
        }
    }

    class CheckAction
    extends AbstractAction {
        CheckAction() {
            super(Main.this.getLabel("checkText"));
            this.putValue("ShortDescription", Main.this.messages.getString("checkTextShortDesc"));
            this.putValue("LongDescription", Main.this.messages.getString("checkTextLongDesc"));
            this.putValue("MnemonicKey", Main.this.getMnemonic("checkText"));
            this.putValue("SmallIcon", Main.this.getImageIcon("sc_spelldialog.png"));
            this.putValue("SwingLargeIconKey", Main.this.getImageIcon("lc_spelldialog.png"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Main.this.checkTextAndDisplayResults();
        }
    }

    class AboutAction
    extends AbstractAction {
        AboutAction() {
            super(Main.this.getLabel("guiMenuAbout"));
            this.putValue("MnemonicKey", Main.this.getMnemonic("guiMenuAbout"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AboutDialog about = new AboutDialog(Main.this.messages, Main.this.getFrame());
            about.show();
        }
    }

    class QuitAction
    extends AbstractAction {
        QuitAction() {
            super(Main.this.getLabel("guiMenuQuit"));
            this.putValue("MnemonicKey", Main.this.getMnemonic("guiMenuQuit"));
            this.putValue("AcceleratorKey", Main.this.getMenuKeyStroke(81));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Main.this.quit();
        }
    }

    class HideAction
    extends AbstractAction {
        HideAction() {
            super(Main.this.getLabel("guiMenuHide"));
            this.putValue("MnemonicKey", Main.this.getMnemonic("guiMenuHide"));
            this.putValue("AcceleratorKey", Main.this.getMenuKeyStroke(68));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Main.this.hideToTray();
        }
    }

    class SelectLFAction
    extends AbstractAction {
        private final UIManager.LookAndFeelInfo lf;

        SelectLFAction(UIManager.LookAndFeelInfo lf) {
            super(lf.getName());
            this.lf = lf;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                UIManager.setLookAndFeel(this.lf.getClassName());
                SwingUtilities.updateComponentTreeUI(Main.this.frame);
                Main.this.frame.pack();
                Main.this.ltSupport.getConfig().setLookAndFeelName(this.lf.getName());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
                Tools.showError(ex);
            }
        }
    }

    class SelectFontAction
    extends AbstractAction {
        SelectFontAction() {
            super(Main.this.getLabel("guiSelectFont"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Main.this.showSelectFontDialog();
        }
    }

    class OptionsAction
    extends AbstractAction {
        OptionsAction() {
            super(Main.this.getLabel("guiMenuOptions"));
            this.putValue("MnemonicKey", Main.this.getMnemonic("guiMenuOptions"));
            this.putValue("AcceleratorKey", Main.this.getMenuKeyStroke(83));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Main.this.showOptions();
        }
    }

    class AddRulesAction
    extends AbstractAction {
        AddRulesAction() {
            super(Main.this.getLabel("guiMenuAddRules"));
            this.putValue("MnemonicKey", Main.this.getMnemonic("guiMenuAddRules"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                Main.this.addLanguage();
            }
            catch (Exception ex) {
                Tools.showError(ex);
            }
        }
    }

    class TagTextAction
    extends AbstractAction {
        TagTextAction() {
            super(Main.this.getLabel("guiTagText"));
            this.putValue("MnemonicKey", Main.this.getMnemonic("guiTagText"));
            this.putValue("AcceleratorKey", Main.this.getMenuKeyStroke(84));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Main.this.tagText();
        }
    }

    class CheckClipboardAction
    extends AbstractAction {
        CheckClipboardAction() {
            super(Main.this.getLabel("guiMenuCheckClipboard"));
            this.putValue("MnemonicKey", Main.this.getMnemonic("guiMenuCheckClipboard"));
            this.putValue("AcceleratorKey", Main.this.getMenuKeyStroke(89));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Main.this.checkClipboardText();
        }
    }

    class SaveAsAction
    extends AbstractAction {
        SaveAsAction() {
            super(Main.this.getLabel("guiMenuSaveAs"));
            this.putValue("ShortDescription", Main.this.messages.getString("guiMenuSaveAsShortDesc"));
            this.putValue("LongDescription", Main.this.messages.getString("guiMenuSaveAsLongDesc"));
            this.putValue("MnemonicKey", Main.this.getMnemonic("guiMenuSaveAs"));
            this.putValue("SmallIcon", Main.this.getImageIcon("sc_saveas.png"));
            this.putValue("SwingLargeIconKey", Main.this.getImageIcon("lc_saveas.png"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Main.this.saveFile(true);
        }
    }

    class SaveAction
    extends AbstractAction {
        SaveAction() {
            super(Main.this.getLabel("guiMenuSave"));
            this.putValue("ShortDescription", Main.this.messages.getString("guiMenuSaveShortDesc"));
            this.putValue("LongDescription", Main.this.messages.getString("guiMenuSaveLongDesc"));
            this.putValue("MnemonicKey", Main.this.getMnemonic("guiMenuSave"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.putValue("SmallIcon", Main.this.getImageIcon("sc_save.png"));
            this.putValue("SwingLargeIconKey", Main.this.getImageIcon("lc_save.png"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Main.this.saveFile(false);
        }
    }

    class OpenAction
    extends AbstractAction {
        OpenAction() {
            super(Main.this.getLabel("guiMenuOpen"));
            this.putValue("ShortDescription", Main.this.messages.getString("guiMenuOpenShortDesc"));
            this.putValue("LongDescription", Main.this.messages.getString("guiMenuOpenLongDesc"));
            this.putValue("MnemonicKey", Main.this.getMnemonic("guiMenuOpen"));
            this.putValue("AcceleratorKey", Main.this.getMenuKeyStroke(79));
            this.putValue("SmallIcon", Main.this.getImageIcon("sc_open.png"));
            this.putValue("SwingLargeIconKey", Main.this.getImageIcon("lc_open.png"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Main.this.loadFile();
        }
    }

    static class PlainTextFileFilter
    extends FileFilter {
        PlainTextFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            boolean isTextFile = f.getName().toLowerCase().endsWith(".txt");
            return isTextFile || f.isDirectory();
        }

        @Override
        public String getDescription() {
            return "*.txt";
        }
    }

    class CloseListener
    extends WindowAdapter {
        CloseListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            Main.this.quitOrHide();
        }
    }

    class TrayActionListener
    extends MouseAdapter {
        TrayActionListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (Main.this.frame.isVisible() && Main.this.frame.isActive()) {
                Main.this.frame.setVisible(false);
            } else if (Main.this.frame.isVisible() && !Main.this.frame.isActive()) {
                Main.this.frame.toFront();
                Main.this.restoreFromTrayAndCheck();
            } else {
                Main.this.restoreFromTrayAndCheck();
            }
        }
    }

    class TrayActionRMBListener
    implements ActionListener {
        TrayActionRMBListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.isCommand(e, "guiMenuCheckClipboard")) {
                Main.this.restoreFromTrayAndCheck();
            } else if (this.isCommand(e, "guiMenuShowMainWindow")) {
                Main.this.restoreFromTray();
            } else if (this.isCommand(e, "guiMenuQuit")) {
                Main.this.quit();
            } else {
                JOptionPane.showMessageDialog(null, "Unknown action: " + e.getActionCommand(), "Error", 0);
            }
        }

        private boolean isCommand(ActionEvent e, String label) {
            return e.getActionCommand().equalsIgnoreCase(Tools.getLabel(Main.this.messages.getString(label)));
        }
    }

    class TrayActionItemListener
    implements ItemListener {
        TrayActionItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            try {
                Configuration config = Main.this.ltSupport.getConfig();
                if (e.getStateChange() == 1) {
                    config.setRunServer(true);
                    boolean serverStarted = Main.this.maybeStartServer();
                    Main.this.enableHttpServerItem.setState(serverStarted);
                    config.setRunServer(serverStarted);
                    config.saveConfiguration(Main.this.ltSupport.getLanguage());
                } else if (e.getStateChange() == 2) {
                    config.setRunServer(false);
                    config.saveConfiguration(Main.this.ltSupport.getLanguage());
                    Main.this.stopServer();
                }
            }
            catch (IOException ex) {
                Tools.showError(ex);
            }
        }
    }

    private class ControlReturnTextCheckingListener
    extends KeyAdapter {
        private ControlReturnTextCheckingListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10 && (e.getModifiersEx() & 0x80) == 128) {
                Main.this.checkTextAndDisplayResults();
            }
        }
    }
}

