/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.event.connection;

import io.lettuce.core.event.connection.ConnectionEvent;
import io.lettuce.core.internal.LettuceAssert;
import java.net.SocketAddress;

abstract class ConnectionEventSupport
implements ConnectionEvent {
    private final SocketAddress local;
    private final SocketAddress remote;

    ConnectionEventSupport(SocketAddress local, SocketAddress remote) {
        LettuceAssert.notNull((Object)local, "Local must not be null");
        LettuceAssert.notNull((Object)remote, "Remote must not be null");
        this.local = local;
        this.remote = remote;
    }

    @Override
    public SocketAddress localAddress() {
        return this.local;
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.remote;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [");
        sb.append(this.local);
        sb.append(" -> ").append(this.remote);
        sb.append(']');
        return sb.toString();
    }
}

