/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dependency.perceptron.transition.parser;

import com.hankcs.hanlp.dependency.perceptron.accessories.Pair;
import com.hankcs.hanlp.dependency.perceptron.learning.AveragedPerceptron;
import com.hankcs.hanlp.dependency.perceptron.structures.Sentence;
import com.hankcs.hanlp.dependency.perceptron.transition.configuration.BeamElement;
import com.hankcs.hanlp.dependency.perceptron.transition.configuration.Configuration;
import com.hankcs.hanlp.dependency.perceptron.transition.configuration.Instance;
import com.hankcs.hanlp.dependency.perceptron.transition.configuration.State;
import com.hankcs.hanlp.dependency.perceptron.transition.features.FeatureExtractor;
import com.hankcs.hanlp.dependency.perceptron.transition.parser.Action;
import com.hankcs.hanlp.dependency.perceptron.transition.parser.ArcEager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import java.util.concurrent.Callable;

public class ParseThread
implements Callable<Pair<Configuration, Integer>> {
    AveragedPerceptron classifier;
    ArrayList<Integer> dependencyRelations;
    int featureLength;
    Sentence sentence;
    boolean rootFirst;
    int beamWidth;
    Instance instance;
    boolean partial;
    int id;

    public ParseThread(int id, AveragedPerceptron classifier, ArrayList<Integer> dependencyRelations, int featureLength, Sentence sentence, boolean rootFirst, int beamWidth, Instance instance, boolean partial) {
        this.id = id;
        this.classifier = classifier;
        this.dependencyRelations = dependencyRelations;
        this.featureLength = featureLength;
        this.sentence = sentence;
        this.rootFirst = rootFirst;
        this.beamWidth = beamWidth;
        this.instance = instance;
        this.partial = partial;
    }

    @Override
    public Pair<Configuration, Integer> call() throws Exception {
        if (!this.partial) {
            return this.parse();
        }
        return new Pair<Configuration, Integer>(this.parsePartial(), this.id);
    }

    Pair<Configuration, Integer> parse() throws Exception {
        Configuration initialConfiguration = new Configuration(this.sentence, this.rootFirst);
        ArrayList<Configuration> beam = new ArrayList<Configuration>(this.beamWidth);
        beam.add(initialConfiguration);
        while (!ArcEager.isTerminal(beam)) {
            float score;
            float score2;
            if (this.beamWidth != 1) {
                TreeSet<BeamElement> beamPreserver = new TreeSet<BeamElement>();
                ParseThread.sortBeam(beam, beamPreserver, false, null, this.beamWidth, this.rootFirst, this.featureLength, this.classifier, this.dependencyRelations);
                ArrayList<Configuration> repBeam = new ArrayList<Configuration>(this.beamWidth);
                for (BeamElement beamElement : beamPreserver.descendingSet()) {
                    if (repBeam.size() >= this.beamWidth) break;
                    int b = beamElement.index;
                    int action = beamElement.action;
                    int label = beamElement.label;
                    float score3 = beamElement.score;
                    Configuration newConfig = beam.get(b).clone();
                    if (action == 0) {
                        ArcEager.shift(newConfig.state);
                        newConfig.addAction(0);
                    } else if (action == 1) {
                        ArcEager.reduce(newConfig.state);
                        newConfig.addAction(1);
                    } else if (action == 2) {
                        ArcEager.rightArc(newConfig.state, label);
                        newConfig.addAction(3 + label);
                    } else if (action == 3) {
                        ArcEager.leftArc(newConfig.state, label);
                        newConfig.addAction(3 + this.dependencyRelations.size() + label);
                    } else if (action == 4) {
                        ArcEager.unShift(newConfig.state);
                        newConfig.addAction(2);
                    }
                    newConfig.setScore(score3);
                    repBeam.add(newConfig);
                }
                beam = repBeam;
                continue;
            }
            Configuration configuration = beam.get(0);
            State currentState = configuration.state;
            Object[] features = FeatureExtractor.extractAllParseFeatures(configuration, this.featureLength);
            float bestScore = Float.NEGATIVE_INFINITY;
            int bestAction = -1;
            boolean canShift = ArcEager.canDo(Action.Shift, currentState);
            boolean canReduce = ArcEager.canDo(Action.Reduce, currentState);
            boolean canRightArc = ArcEager.canDo(Action.RightArc, currentState);
            boolean canLeftArc = ArcEager.canDo(Action.LeftArc, currentState);
            if (!(canShift || canReduce || canRightArc || canLeftArc)) {
                if (!currentState.stackEmpty()) {
                    ArcEager.unShift(currentState);
                    configuration.addAction(2);
                } else if (!currentState.bufferEmpty() && currentState.stackEmpty()) {
                    ArcEager.shift(currentState);
                    configuration.addAction(0);
                }
            }
            if (canShift && (score2 = this.classifier.shiftScore(features, true)) > bestScore) {
                bestScore = score2;
                bestAction = 0;
            }
            if (canReduce && (score2 = this.classifier.reduceScore(features, true)) > bestScore) {
                bestScore = score2;
                bestAction = 1;
            }
            if (canRightArc) {
                float[] rightArcScores = this.classifier.rightArcScores(features, true);
                for (int dependency : this.dependencyRelations) {
                    score = rightArcScores[dependency];
                    if (!(score > bestScore)) continue;
                    bestScore = score;
                    bestAction = 3 + dependency;
                }
            }
            if (ArcEager.canDo(Action.LeftArc, currentState)) {
                float[] leftArcScores = this.classifier.leftArcScores(features, true);
                for (int dependency : this.dependencyRelations) {
                    score = leftArcScores[dependency];
                    if (!(score > bestScore)) continue;
                    bestScore = score;
                    bestAction = 3 + this.dependencyRelations.size() + dependency;
                }
            }
            if (bestAction != -1) {
                if (bestAction == 0) {
                    ArcEager.shift(configuration.state);
                } else if (bestAction == 1) {
                    ArcEager.reduce(configuration.state);
                } else if (bestAction >= 3 + this.dependencyRelations.size()) {
                    int label = bestAction - (3 + this.dependencyRelations.size());
                    ArcEager.leftArc(configuration.state, label);
                } else {
                    int label = bestAction - 3;
                    ArcEager.rightArc(configuration.state, label);
                }
                configuration.addScore(bestScore);
                configuration.addAction(bestAction);
            }
            if (beam.size() != 0) continue;
            System.out.println("WHY BEAM SIZE ZERO?");
        }
        Configuration bestConfiguration = null;
        float bestScore = Float.NEGATIVE_INFINITY;
        for (Configuration configuration : beam) {
            if (!(configuration.getScore(true) > bestScore)) continue;
            bestScore = configuration.getScore(true);
            bestConfiguration = configuration;
        }
        return new Pair<Object, Integer>(bestConfiguration, this.id);
    }

    public static void sortBeam(ArrayList<Configuration> beam, TreeSet<BeamElement> beamPreserver, Boolean isNonProjective, Instance instance, int beamWidth, boolean rootFirst, int featureLength, AveragedPerceptron classifier, Collection<Integer> dependencyRelations) {
        for (int b = 0; b < beam.size(); ++b) {
            float addedScore;
            float score;
            float addedScore2;
            float score2;
            Configuration configuration = beam.get(b);
            State currentState = configuration.state;
            float prevScore = configuration.score;
            boolean canShift = ArcEager.canDo(Action.Shift, currentState);
            boolean canReduce = ArcEager.canDo(Action.Reduce, currentState);
            boolean canRightArc = ArcEager.canDo(Action.RightArc, currentState);
            boolean canLeftArc = ArcEager.canDo(Action.LeftArc, currentState);
            Object[] features = FeatureExtractor.extractAllParseFeatures(configuration, featureLength);
            if (!(canShift || canReduce || canRightArc || canLeftArc)) {
                beamPreserver.add(new BeamElement(prevScore, b, 4, -1));
                if (beamPreserver.size() > beamWidth) {
                    beamPreserver.pollFirst();
                }
            }
            if (canShift) {
                score2 = classifier.shiftScore(features, true);
                addedScore2 = score2 + prevScore;
                beamPreserver.add(new BeamElement(addedScore2, b, 0, -1));
                if (beamPreserver.size() > beamWidth) {
                    beamPreserver.pollFirst();
                }
            }
            if (canReduce) {
                score2 = classifier.reduceScore(features, true);
                addedScore2 = score2 + prevScore;
                beamPreserver.add(new BeamElement(addedScore2, b, 1, -1));
                if (beamPreserver.size() > beamWidth) {
                    beamPreserver.pollFirst();
                }
            }
            if (canRightArc) {
                float[] rightArcScores = classifier.rightArcScores(features, true);
                for (int dependency : dependencyRelations) {
                    score = rightArcScores[dependency];
                    addedScore = score + prevScore;
                    beamPreserver.add(new BeamElement(addedScore, b, 2, dependency));
                    if (beamPreserver.size() <= beamWidth) continue;
                    beamPreserver.pollFirst();
                }
            }
            if (!canLeftArc) continue;
            float[] leftArcScores = classifier.leftArcScores(features, true);
            for (int dependency : dependencyRelations) {
                score = leftArcScores[dependency];
                addedScore = score + prevScore;
                beamPreserver.add(new BeamElement(addedScore, b, 3, dependency));
                if (beamPreserver.size() <= beamWidth) continue;
                beamPreserver.pollFirst();
            }
        }
    }

    public Configuration parsePartial() throws Exception {
        Configuration initialConfiguration = new Configuration(this.sentence, this.rootFirst);
        boolean isNonProjective = false;
        if (this.instance.isNonprojective()) {
            isNonProjective = true;
        }
        ArrayList<Configuration> beam = new ArrayList<Configuration>(this.beamWidth);
        beam.add(initialConfiguration);
        while (!ArcEager.isTerminal(beam)) {
            TreeSet<BeamElement> beamPreserver = new TreeSet<BeamElement>();
            ParseThread.sortBeam(beam, beamPreserver, isNonProjective, this.instance, this.beamWidth, this.rootFirst, this.featureLength, this.classifier, this.dependencyRelations);
            ArrayList<Configuration> repBeam = new ArrayList<Configuration>(this.beamWidth);
            for (BeamElement beamElement : beamPreserver.descendingSet()) {
                if (repBeam.size() >= this.beamWidth) break;
                int b = beamElement.index;
                int action = beamElement.action;
                int label = beamElement.label;
                float score = beamElement.score;
                Configuration newConfig = beam.get(b).clone();
                if (action == 0) {
                    ArcEager.shift(newConfig.state);
                    newConfig.addAction(0);
                } else if (action == 1) {
                    ArcEager.reduce(newConfig.state);
                    newConfig.addAction(1);
                } else if (action == 2) {
                    ArcEager.rightArc(newConfig.state, label);
                    newConfig.addAction(3 + label);
                } else if (action == 3) {
                    ArcEager.leftArc(newConfig.state, label);
                    newConfig.addAction(3 + this.dependencyRelations.size() + label);
                } else if (action == 4) {
                    ArcEager.unShift(newConfig.state);
                    newConfig.addAction(2);
                }
                newConfig.setScore(score);
                repBeam.add(newConfig);
            }
            beam = repBeam;
        }
        Configuration bestConfiguration = null;
        float bestScore = Float.NEGATIVE_INFINITY;
        for (Configuration configuration : beam) {
            if (!(configuration.getScore(true) > bestScore)) continue;
            bestScore = configuration.getScore(true);
            bestConfiguration = configuration;
        }
        return bestConfiguration;
    }
}

