/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.languagetool.AnalyzedSentence;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.language.Demo;
import org.languagetool.rules.RemoteRule;
import org.languagetool.rules.RemoteRuleConfig;
import org.languagetool.rules.RemoteRuleResult;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;

public class RemoteRuleTest {
    protected static String sentence;
    private static JLanguageTool lt;
    private static RemoteRule rule;
    private static final RemoteRuleConfig config;
    private static long waitTime;
    private static boolean fail;
    private static int calls;

    @BeforeClass
    public static void setUp() throws IOException {
        lt = new JLanguageTool((Language)new Demo());
        lt.getAllActiveRules().forEach(r -> lt.disableRule(r.getId()));
        rule = new TestRemoteRule(config);
        sentence = "This is a test.";
        lt.addRule((Rule)rule);
    }

    @After
    public void tearDown() {
        rule.circuitBreaker().reset();
        waitTime = 0L;
        calls = 0;
        fail = false;
    }

    private void assertMatches(String msg, int expected) throws IOException {
        List matches = lt.check(sentence);
        Assert.assertEquals((String)msg, (long)expected, (long)matches.size());
    }

    @Test
    public void testMatch() throws IOException {
        lt.disableRule(rule.getId());
        this.assertMatches("no matches before - sanity check", 0);
        lt.enableRule(rule.getId());
        this.assertMatches("test rule creates match", 1);
    }

    @Test
    public void testTimeout() throws IOException, InterruptedException {
        waitTime = RemoteRuleTest.config.baseTimeoutMilliseconds * 2L;
        this.assertMatches("timeouts work", 0);
    }

    @Test
    @Ignore(value="Unstable in CI because of reliance on timings, for local testing only")
    public void testCircuitbreaker() throws IOException, InterruptedException {
        waitTime = RemoteRuleTest.config.baseTimeoutMilliseconds * 2L;
        this.assertMatches("timeouts work", 0);
        this.assertMatches("timeouts work", 0);
        waitTime = 0L;
        int callsBefore = calls;
        this.assertMatches("No matches when circuitbreaker open", 0);
        Assert.assertEquals((String)"No calls when circuitbreaker open", (long)callsBefore, (long)calls);
        Thread.sleep(RemoteRuleTest.config.downMilliseconds);
        this.assertMatches("matches when circuitbreaker half-open", 1);
        Assert.assertEquals((String)"calls when circuitbreaker half-open", (long)(callsBefore + 1), (long)calls);
    }

    @Test
    public void testFailedRequests() throws IOException {
        fail = true;
        this.assertMatches("no matches for failing requests", 0);
    }

    static {
        fail = false;
        config = new RemoteRuleConfig();
        RemoteRuleTest.config.ruleId = "TEST_REMOTE_RULE";
        RemoteRuleTest.config.baseTimeoutMilliseconds = 50L;
        RemoteRuleTest.config.minimumNumberOfCalls = 2;
        RemoteRuleTest.config.failureRateThreshold = 50.0f;
        RemoteRuleTest.config.downMilliseconds = 200L;
        RemoteRuleTest.config.slidingWindowSize = 2;
        RemoteRuleTest.config.slidingWindowType = CircuitBreakerConfig.SlidingWindowType.COUNT_BASED.name();
    }

    static class TestRemoteRule
    extends RemoteRule {
        static final String ID = "TEST_REMOTE_RULE";

        TestRemoteRule(RemoteRuleConfig config) {
            super((Language)new Demo(), JLanguageTool.getMessageBundle(), config, false);
        }

        protected RemoteRule.RemoteRequest prepareRequest(List<AnalyzedSentence> sentences, Long textSessionId) {
            return new TestRemoteRequest(sentences);
        }

        private RuleMatch testMatch(AnalyzedSentence s) {
            return new RuleMatch((Rule)this, s, 0, 1, "Test match");
        }

        protected Callable<RemoteRuleResult> executeRequest(RemoteRule.RemoteRequest request, long timeoutMilliseconds) throws TimeoutException {
            return () -> {
                calls++;
                if (fail) {
                    throw new RuntimeException("Failing for testing purposes");
                }
                TestRemoteRequest req = (TestRemoteRequest)request;
                long deadline = System.currentTimeMillis() + waitTime;
                while (System.currentTimeMillis() < deadline) {
                }
                List matches = req.sentences.stream().map(this::testMatch).collect(Collectors.toList());
                return new RemoteRuleResult(true, true, matches, req.sentences);
            };
        }

        protected RemoteRuleResult fallbackResults(RemoteRule.RemoteRequest request) {
            TestRemoteRequest req = (TestRemoteRequest)request;
            System.out.println("Fallback matches");
            return new RemoteRuleResult(false, false, Collections.emptyList(), req.sentences);
        }

        public String getDescription() {
            return "TEST REMOTE RULE";
        }

        class TestRemoteRequest
        extends RemoteRule.RemoteRequest {
            private final List<AnalyzedSentence> sentences;

            TestRemoteRequest(List<AnalyzedSentence> sentences) {
                this.sentences = sentences;
            }
        }
    }
}

