/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model.perceptron.instance;

import com.hankcs.hanlp.corpus.document.sentence.Sentence;
import com.hankcs.hanlp.model.perceptron.feature.FeatureMap;
import com.hankcs.hanlp.model.perceptron.instance.Instance;
import com.hankcs.hanlp.model.perceptron.tagset.NERTagSet;
import com.hankcs.hanlp.model.perceptron.utility.Utility;
import java.util.ArrayList;
import java.util.List;

public class NERInstance
extends Instance {
    public NERInstance(String[] wordArray, String[] posArray, String[] nerArray, NERTagSet tagSet, FeatureMap featureMap) {
        this(wordArray, posArray, featureMap);
        this.tagArray = new int[wordArray.length];
        for (int i = 0; i < wordArray.length; ++i) {
            this.tagArray[i] = tagSet.add(nerArray[i]);
        }
    }

    public NERInstance(String[][] tuples, NERTagSet tagSet, FeatureMap featureMap) {
        this(tuples[0], tuples[1], tuples[2], tagSet, featureMap);
    }

    public NERInstance(String[] wordArray, String[] posArray, FeatureMap featureMap) {
        this.initFeatureMatrix(wordArray, posArray, featureMap);
    }

    private void initFeatureMatrix(String[] wordArray, String[] posArray, FeatureMap featureMap) {
        this.featureMatrix = new int[wordArray.length][];
        for (int i = 0; i < this.featureMatrix.length; ++i) {
            this.featureMatrix[i] = this.extractFeature(wordArray, posArray, featureMap, i);
        }
    }

    protected int[] extractFeature(String[] wordArray, String[] posArray, FeatureMap featureMap, int position) {
        ArrayList<Integer> featVec = new ArrayList<Integer>();
        String pre2Word = position >= 2 ? wordArray[position - 2] : "_B_";
        String preWord = position >= 1 ? wordArray[position - 1] : "_B_";
        String curWord = wordArray[position];
        String nextWord = position <= wordArray.length - 2 ? wordArray[position + 1] : "_E_";
        String next2Word = position <= wordArray.length - 3 ? wordArray[position + 2] : "_E_";
        String pre2Pos = position >= 2 ? posArray[position - 2] : "_B_";
        String prePos = position >= 1 ? posArray[position - 1] : "_B_";
        String curPos = posArray[position];
        String nextPos = position <= posArray.length - 2 ? posArray[position + 1] : "_E_";
        String next2Pos = position <= posArray.length - 3 ? posArray[position + 2] : "_E_";
        StringBuilder sb = new StringBuilder();
        NERInstance.addFeatureThenClear(sb.append(pre2Word).append('1'), featVec, featureMap);
        NERInstance.addFeatureThenClear(sb.append(preWord).append('2'), featVec, featureMap);
        NERInstance.addFeatureThenClear(sb.append(curWord).append('3'), featVec, featureMap);
        NERInstance.addFeatureThenClear(sb.append(nextWord).append('4'), featVec, featureMap);
        NERInstance.addFeatureThenClear(sb.append(next2Word).append('5'), featVec, featureMap);
        NERInstance.addFeatureThenClear(sb.append(pre2Pos).append('A'), featVec, featureMap);
        NERInstance.addFeatureThenClear(sb.append(prePos).append('B'), featVec, featureMap);
        NERInstance.addFeatureThenClear(sb.append(curPos).append('C'), featVec, featureMap);
        NERInstance.addFeatureThenClear(sb.append(nextPos).append('D'), featVec, featureMap);
        NERInstance.addFeatureThenClear(sb.append(next2Pos).append('E'), featVec, featureMap);
        NERInstance.addFeatureThenClear(sb.append(pre2Pos).append(prePos).append('F'), featVec, featureMap);
        NERInstance.addFeatureThenClear(sb.append(prePos).append(curPos).append('G'), featVec, featureMap);
        NERInstance.addFeatureThenClear(sb.append(curPos).append(nextPos).append('H'), featVec, featureMap);
        NERInstance.addFeatureThenClear(sb.append(nextPos).append(next2Pos).append('I'), featVec, featureMap);
        return NERInstance.toFeatureArray(featVec);
    }

    public NERInstance(String segmentedTaggedNERSentence, FeatureMap featureMap) {
        this(Sentence.create(segmentedTaggedNERSentence), featureMap);
    }

    public NERInstance(Sentence sentence, FeatureMap featureMap) {
        this(NERInstance.convertSentenceToArray(sentence, featureMap), (NERTagSet)featureMap.tagSet, featureMap);
    }

    private static String[][] convertSentenceToArray(Sentence sentence, FeatureMap featureMap) {
        NERTagSet tagSet = (NERTagSet)featureMap.tagSet;
        List<String[]> collector = Utility.convertSentenceToNER(sentence, tagSet);
        String[][] tuples = new String[3][collector.size()];
        String[] wordArray = tuples[0];
        String[] posArray = tuples[1];
        String[] tagArray = tuples[2];
        Utility.reshapeNER(collector, wordArray, posArray, tagArray);
        return tuples;
    }
}

