/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.patterns.RuleFilterEvaluator;

public class RuleFilterEvaluatorTest {
    private final RuleFilterEvaluator eval = new RuleFilterEvaluator(null);

    @Test
    public void testGetResolvedArguments() throws Exception {
        AnalyzedTokenReadings[] readingsList = new AnalyzedTokenReadings[]{new AnalyzedTokenReadings(new AnalyzedToken("fake1", "pos", null), 0), new AnalyzedTokenReadings(new AnalyzedToken("fake2", "pos", null), 0)};
        Map map = this.eval.getResolvedArguments("year:\\1 month:\\2", readingsList, -1, Arrays.asList(1, 1));
        Assert.assertThat((Object)((String)map.get("year")), (Matcher)CoreMatchers.is((Object)"fake1"));
        Assert.assertThat((Object)((String)map.get("month")), (Matcher)CoreMatchers.is((Object)"fake2"));
        Assert.assertThat((Object)map.size(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void testGetResolvedArgumentsWithColon() throws Exception {
        AnalyzedTokenReadings[] readingsList = new AnalyzedTokenReadings[]{new AnalyzedTokenReadings(new AnalyzedToken("fake1", "pos", null), 0)};
        Map map = this.eval.getResolvedArguments("regex:(?:foo[xyz])bar", readingsList, -1, Arrays.asList(1, 1));
        Assert.assertThat((Object)((String)map.get("regex")), (Matcher)CoreMatchers.is((Object)"(?:foo[xyz])bar"));
        Assert.assertThat((Object)map.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test(expected=RuntimeException.class)
    public void testDuplicateKey() throws Exception {
        AnalyzedTokenReadings[] readingsList = new AnalyzedTokenReadings[]{new AnalyzedTokenReadings(new AnalyzedToken("fake1", "SENT_START", null), 0), new AnalyzedTokenReadings(new AnalyzedToken("fake1", "pos", null), 0), new AnalyzedTokenReadings(new AnalyzedToken("fake2", "pos", null), 0)};
        this.eval.getResolvedArguments("year:\\1 year:\\2", readingsList, -1, Arrays.asList(1, 2));
    }

    @Test
    public void testNoBackReference() throws Exception {
        Map args = this.eval.getResolvedArguments("year:2 foo:bar", null, -1, Collections.emptyList());
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("year", "2");
        expected.put("foo", "bar");
        Assert.assertThat((Object)args, (Matcher)CoreMatchers.is(expected));
    }

    @Test(expected=RuntimeException.class)
    public void testTooLargeBackRef() throws Exception {
        this.eval.getResolvedArguments("year:\\1 month:\\2 day:\\3 weekDay:\\4", null, -1, Collections.emptyList());
    }
}

