/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.jakartaee.db;

import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.payara.jakartaee.db.JDBCConnectionPool;
import org.netbeans.modules.payara.tooling.utils.StringPrefixTree;

public class JDBCResource
implements Datasource {
    private String jndiName;
    private String objectType;
    private String poolName;
    private boolean enabled;
    private int deploymentOrder;
    private JDBCConnectionPool pool;

    public JDBCResource() {
        this.jndiName = null;
        this.objectType = null;
        this.poolName = null;
        this.enabled = false;
        this.deploymentOrder = -1;
        this.pool = null;
    }

    public JDBCResource(String jndiName, String objectType, String poolName, boolean enabled, int deploymentOrder, JDBCConnectionPool pool) {
        this.jndiName = jndiName;
        this.objectType = objectType;
        this.poolName = poolName;
        this.enabled = enabled;
        this.deploymentOrder = deploymentOrder;
        this.pool = pool;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public String getDisplayName() {
        return this.jndiName;
    }

    public String getUrl() {
        return this.pool != null ? this.pool.getUrl() : null;
    }

    public String getUsername() {
        return this.pool != null ? this.pool.getUser() : null;
    }

    public String getPassword() {
        return this.pool != null ? this.pool.getPassword() : null;
    }

    public String getDriverClassName() {
        return this.pool != null ? this.pool.getDriverClass() : null;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getDeploymentOrder() {
        return this.deploymentOrder;
    }

    public JDBCConnectionPool getPool() {
        return this.pool;
    }

    public void setPool(JDBCConnectionPool pool) {
        this.pool = pool;
    }

    public boolean setProperty(AttrType type, String value) {
        switch (type) {
            case JNDI_NAME: {
                this.jndiName = value;
                return true;
            }
            case OBJECT_TYPE: {
                this.objectType = value;
                return true;
            }
            case POOL_NAME: {
                this.poolName = value;
                return true;
            }
            case ENABLED: {
                this.enabled = Boolean.parseBoolean(value);
                return true;
            }
            case DEPLOYMENT_ORDER: {
                try {
                    this.deploymentOrder = Integer.parseInt(value);
                    return true;
                }
                catch (NumberFormatException nfe) {
                    this.deploymentOrder = -1;
                    return false;
                }
            }
        }
        return false;
    }

    public JDBCResource copy(String jndiName) {
        return new JDBCResource(jndiName, this.objectType, this.poolName, this.enabled, this.deploymentOrder, this.pool);
    }

    public static enum AttrType {
        UNKNOWN,
        JNDI_NAME,
        OBJECT_TYPE,
        POOL_NAME,
        ENABLED,
        DEPLOYMENT_ORDER;

        private static final String UNKNOWN_STR = "UNKNOWN";
        private static final String JNDI_NAME_STR = "jndi-name";
        private static final String OBJECT_TYPE_STR = "object-type";
        private static final String POOL_NAME_STR = "pool-name";
        private static final String ENABLED_STR = "enabled";
        private static final String DEPLOYMENT_ORDER_STR = "deployment-order";
        private static final StringPrefixTree<AttrType> stringValues;

        public static AttrType toValue(String name) {
            if (name != null) {
                AttrType type = (AttrType)((Object)stringValues.match((CharSequence)name.toLowerCase()));
                return type != null ? type : UNKNOWN;
            }
            return null;
        }

        public String toString() {
            switch (this) {
                case UNKNOWN: {
                    return UNKNOWN_STR;
                }
                case JNDI_NAME: {
                    return JNDI_NAME_STR;
                }
                case OBJECT_TYPE: {
                    return OBJECT_TYPE_STR;
                }
                case POOL_NAME: {
                    return POOL_NAME_STR;
                }
                case ENABLED: {
                    return ENABLED_STR;
                }
                case DEPLOYMENT_ORDER: {
                    return DEPLOYMENT_ORDER_STR;
                }
            }
            throw new IllegalStateException("Invalid ResourceType value");
        }

        static {
            stringValues = new StringPrefixTree(false);
            stringValues.add(JNDI_NAME.toString(), (Object)JNDI_NAME);
            stringValues.add(OBJECT_TYPE.toString(), (Object)OBJECT_TYPE);
            stringValues.add(POOL_NAME.toString(), (Object)POOL_NAME);
            stringValues.add(ENABLED.toString(), (Object)ENABLED);
            stringValues.add(DEPLOYMENT_ORDER.toString(), (Object)DEPLOYMENT_ORDER);
        }
    }
}

