/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.spiimpl.refactoring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.java.hints.providers.spi.HintDescription;
import org.netbeans.modules.java.hints.providers.spi.HintMetadata;
import org.netbeans.modules.java.hints.spiimpl.MessageImpl;
import org.netbeans.modules.java.hints.spiimpl.batch.BatchSearch;
import org.netbeans.modules.java.hints.spiimpl.batch.ProgressHandleWrapper;
import org.netbeans.modules.java.hints.spiimpl.options.HintsSettings;
import org.netbeans.modules.java.hints.spiimpl.refactoring.AbstractApplyHintsRefactoringPlugin;
import org.netbeans.modules.java.hints.spiimpl.refactoring.Bundle;
import org.netbeans.modules.java.hints.spiimpl.refactoring.FindDuplicatesRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.spi.java.hints.Hint;
import org.netbeans.spi.java.hints.HintContext;

public class FindDuplicatesRefactoringPlugin
extends AbstractApplyHintsRefactoringPlugin {
    private final FindDuplicatesRefactoring refactoring;

    public FindDuplicatesRefactoringPlugin(FindDuplicatesRefactoring refactoring) {
        super(refactoring);
        this.refactoring = refactoring;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public Problem fastCheckParameters() {
        return null;
    }

    public Problem prepare(RefactoringElementsBag refactoringElements) {
        this.cancel.set(false);
        List<MessageImpl> problems = this.performSearchForPattern(refactoringElements);
        problems.addAll(this.performApplyPattern(refactoringElements));
        Problem current = null;
        for (MessageImpl problem : problems) {
            Problem p = new Problem(problem.kind == HintContext.MessageKind.ERROR, problem.text);
            if (current != null) {
                p.setNext(current);
            }
            current = p;
        }
        return current;
    }

    private List<MessageImpl> performSearchForPattern(RefactoringElementsBag refactoringElements) {
        ProgressHandleWrapper w = new ProgressHandleWrapper((ProgressHandleWrapper.ProgressHandleAbstraction)this, new int[]{10, 90});
        Iterable<? extends HintDescription> queries = this.filterQueries(this.refactoring.getPattern(), true);
        BatchSearch.BatchResult candidates = BatchSearch.findOccurrences(queries, (BatchSearch.Scope)this.refactoring.getScope(), (ProgressHandleWrapper)w, (HintsSettings)HintsSettings.getGlobalSettings());
        LinkedList<MessageImpl> problems = new LinkedList<MessageImpl>(candidates.problems);
        if (queries.iterator().hasNext()) {
            problems.add(new MessageImpl(HintContext.MessageKind.WARNING, Bundle.WARN_HasQueries()));
        }
        this.prepareElements(candidates, w, refactoringElements, this.refactoring.isVerify(), problems);
        w.finish();
        return problems;
    }

    private Collection<MessageImpl> performApplyPattern(RefactoringElementsBag refactoringElements) {
        return this.performApplyPattern(this.filterQueries(this.refactoring.getPattern(), false), this.refactoring.getScope(), refactoringElements);
    }

    private Iterable<? extends HintDescription> filterQueries(Iterable<? extends HintDescription> hints, boolean positive) {
        ArrayList<HintDescription> result = new ArrayList<HintDescription>();
        for (HintDescription hintDescription : hints) {
            if (hintDescription.getMetadata().options.contains(HintMetadata.Options.NO_BATCH) || hintDescription.getMetadata().kind != Hint.Kind.INSPECTION || !(positive ^ (!hintDescription.getMetadata().options.contains(HintMetadata.Options.QUERY) && !hintDescription.getOptions().contains(HintMetadata.Options.QUERY)))) continue;
            result.add(hintDescription);
        }
        return result;
    }
}

