/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.nodejs.exec;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.base.input.InputProcessor;
import org.netbeans.api.extexecution.base.input.InputProcessors;
import org.netbeans.api.extexecution.base.input.LineProcessor;
import org.netbeans.api.extexecution.print.ConvertedLine;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.extexecution.startup.StartupExtender;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.nodejs.exec.Bundle;
import org.netbeans.modules.javascript.nodejs.file.PackageJson;
import org.netbeans.modules.javascript.nodejs.options.NodeJsOptions;
import org.netbeans.modules.javascript.nodejs.options.NodeJsOptionsValidator;
import org.netbeans.modules.javascript.nodejs.platform.NodeJsSupport;
import org.netbeans.modules.javascript.nodejs.preferences.NodeJsPreferences;
import org.netbeans.modules.javascript.nodejs.preferences.NodeJsPreferencesValidator;
import org.netbeans.modules.javascript.nodejs.ui.customizer.NodeJsCustomizerProvider;
import org.netbeans.modules.javascript.nodejs.util.FileUtils;
import org.netbeans.modules.javascript.nodejs.util.NodeJsUtils;
import org.netbeans.modules.javascript.nodejs.util.StringUtils;
import org.netbeans.modules.javascript.nodejs.util.ValidationUtils;
import org.netbeans.modules.javascript.v8debug.api.Connector;
import org.netbeans.modules.javascript.v8debug.api.DebuggerOptions;
import org.netbeans.modules.web.common.api.ValidationResult;
import org.netbeans.modules.web.common.api.Version;
import org.netbeans.modules.web.common.ui.api.ExternalExecutable;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public class NodeExecutable {
    static final Logger LOGGER = Logger.getLogger(NodeExecutable.class.getName());
    @SuppressWarnings(value={"MS_MUTABLE_ARRAY"}, justification="Just internal usage")
    public static final String[] NODE_NAMES;
    public static final int DEFAULT_DEBUG_PORT = 9292;
    private static final String IO_NAME;
    private static final String DEBUG_BRK_COMMAND = "--debug-brk=%d";
    private static final String DEBUG_COMMAND = "--debug=%d";
    private static final String VERSION_PARAM = "--version";
    private static final ConcurrentMap<String, Version> VERSIONS;
    private static final Version UNKNOWN_VERSION;
    protected final Project project;
    protected final String nodePath;

    NodeExecutable(String nodePath, @NullAllowed Project project) {
        assert (nodePath != null);
        this.nodePath = nodePath;
        this.project = project;
    }

    @CheckForNull
    public static NodeExecutable getDefault(@NullAllowed Project project, boolean showOptions) {
        ValidationResult result = new NodeJsOptionsValidator().validateNode(false).getResult();
        if (NodeExecutable.validateResult(result) != null) {
            if (showOptions) {
                OptionsDisplayer.getDefault().open("Html5/NodeJs");
            }
            return null;
        }
        return NodeExecutable.createExecutable(NodeJsOptions.getInstance().getNode(), project);
    }

    @CheckForNull
    public static NodeExecutable forProject(Project project, boolean showCustomizer) {
        assert (project != null);
        return NodeExecutable.forProjectInternal(project, showCustomizer);
    }

    @CheckForNull
    public static NodeExecutable forPath(String path) {
        ValidationResult result = new ValidationResult();
        ValidationUtils.validateNode(result, path);
        if (NodeExecutable.validateResult(result) != null) {
            return null;
        }
        return NodeExecutable.createExecutable(path, null);
    }

    @CheckForNull
    private static NodeExecutable forProjectInternal(@NullAllowed Project project, boolean showCustomizer) {
        if (project == null) {
            return NodeExecutable.getDefault(null, showCustomizer);
        }
        NodeJsPreferences preferences = NodeJsSupport.forProject(project).getPreferences();
        if (preferences.isDefaultNode()) {
            return NodeExecutable.getDefault(project, showCustomizer);
        }
        String node = preferences.getNode();
        ValidationResult result = new NodeJsPreferencesValidator().validateNode(node).getResult();
        if (NodeExecutable.validateResult(result) != null) {
            if (showCustomizer) {
                NodeJsCustomizerProvider.openCustomizer(project, result);
            }
            return null;
        }
        assert (node != null);
        return NodeExecutable.createExecutable(node, project);
    }

    private static NodeExecutable createExecutable(String node, Project project) {
        if (Utilities.isMac()) {
            return new MacNodeExecutable(node, project);
        }
        return new NodeExecutable(node, project);
    }

    public String getExecutable() {
        return new ExternalExecutable(this.nodePath).getExecutable();
    }

    String getCommand() {
        return this.nodePath;
    }

    public boolean isIojs() {
        File node = new File(new ExternalExecutable(this.nodePath).getExecutable());
        if (node.getName().equals(IO_NAME)) {
            return true;
        }
        File iojs = new File(node.getParentFile(), IO_NAME);
        return node.length() == iojs.length();
    }

    public void resetVersion() {
        VERSIONS.remove(this.nodePath);
    }

    public boolean versionDetected() {
        return VERSIONS.containsKey(this.nodePath);
    }

    @CheckForNull
    public Version getRealVersion() {
        this.detectVersion();
        Version version = (Version)VERSIONS.get(this.nodePath);
        if (version == UNKNOWN_VERSION) {
            return null;
        }
        return version;
    }

    @CheckForNull
    public Version getVersion() {
        return this.getRealVersion();
    }

    private void detectVersion() {
        if (VERSIONS.get(this.nodePath) != null) {
            return;
        }
        assert (!EventQueue.isDispatchThread());
        VersionOutputProcessorFactory versionOutputProcessorFactory = new VersionOutputProcessorFactory();
        try {
            this.getExecutable("node version").additionalParameters(this.getVersionParams()).runAndWait(NodeExecutable.getSilentDescriptor(), (ExecutionDescriptor.InputProcessorFactory2)versionOutputProcessorFactory, Bundle.NodeExecutable_version_detecting());
            String detectedVersion = versionOutputProcessorFactory.getVersion();
            if (detectedVersion != null) {
                Version version = Version.fromDottedNotationWithFallback((String)detectedVersion);
                VERSIONS.put(this.nodePath, version);
                return;
            }
            VERSIONS.put(this.nodePath, UNKNOWN_VERSION);
        }
        catch (CancellationException ex) {
            assert (false);
        }
        catch (ExecutionException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
    }

    @CheckForNull
    public AtomicReference<Future<Integer>> run(File script, String args) {
        assert (this.project != null);
        String projectName = NodeJsUtils.getProjectDisplayName(this.project);
        AtomicReference<Future<Integer>> taskRef = new AtomicReference<Future<Integer>>();
        Future task = this.getExecutable(Bundle.NodeExecutable_run(projectName)).additionalParameters(this.getRunParams(script, args)).run(this.getDescriptor(taskRef));
        assert (task != null) : this.nodePath;
        taskRef.set(task);
        return taskRef;
    }

    @CheckForNull
    public AtomicReference<Future<Integer>> debug(int port, File script, String args) {
        assert (this.project != null);
        String projectName = NodeJsUtils.getProjectDisplayName(this.project);
        AtomicReference<Future<Integer>> taskRef = new AtomicReference<Future<Integer>>();
        boolean[] useV8Debug = new boolean[]{false};
        Future task = this.getExecutable(Bundle.NodeExecutable_run(projectName)).additionalParameters(this.getDebugParams(port, script, args, useV8Debug)).run(this.getDescriptor(taskRef, useV8Debug[0] ? new DebugInfo(this.project, taskRef, port) : null));
        assert (task != null) : this.nodePath;
        taskRef.set(task);
        return taskRef;
    }

    private ExternalExecutable getExecutable(String title) {
        assert (title != null);
        return new ExternalExecutable(this.getCommand()).workDir(this.getWorkDir()).displayName(title).optionsPath("Html5/NodeJs").noOutput(false);
    }

    private ExecutionDescriptor getDescriptor(AtomicReference<Future<Integer>> taskRef) {
        return this.getDescriptor(taskRef, null);
    }

    private ExecutionDescriptor getDescriptor(final AtomicReference<Future<Integer>> taskRef, @NullAllowed DebugInfo debugInfo) {
        assert (this.project != null);
        assert (taskRef != null);
        List<URL> sourceRoots = NodeJsSupport.forProject(this.project).getSourceRoots();
        LineConvertorFactoryImpl lineConvertorFactory = new LineConvertorFactoryImpl(sourceRoots, debugInfo);
        return ExternalExecutable.DEFAULT_EXECUTION_DESCRIPTOR.frontWindowOnError(false).showSuspended(true).optionsPath("Html5/NodeJs").outLineBased(true).errLineBased(true).outConvertorFactory((ExecutionDescriptor.LineConvertorFactory)lineConvertorFactory).errConvertorFactory((ExecutionDescriptor.LineConvertorFactory)lineConvertorFactory).preExecution(lineConvertorFactory.getPreExecution()).postExecution(lineConvertorFactory.getPostExecution()).rerunCallback(new ExecutionDescriptor.RerunCallback(){

            public void performed(Future<Integer> task) {
                taskRef.set(task);
            }
        });
    }

    private static ExecutionDescriptor getSilentDescriptor() {
        return new ExecutionDescriptor().inputOutput(InputOutput.NULL).inputVisible(false).frontWindow(false).showProgress(false).charset(StandardCharsets.UTF_8);
    }

    private File getWorkDir() {
        if (this.project == null) {
            return FileUtils.TMP_DIR;
        }
        PackageJson packageJson = NodeJsSupport.forProject(this.project).getPackageJson();
        if (packageJson.exists()) {
            return new File(packageJson.getPath()).getParentFile();
        }
        File sourceRoot = NodeJsUtils.getSourceRoot(this.project);
        if (sourceRoot != null) {
            return sourceRoot;
        }
        File workDir = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
        assert (workDir != null) : this.project.getProjectDirectory();
        return workDir;
    }

    private List<String> getRunParams(File script, String args) {
        return this.getParams(this.getScriptArgsParams(script, args));
    }

    private List<String> getDebugParams(int port, File script, String args, boolean[] useV8Debug) {
        ArrayList<String> params = new ArrayList<String>();
        List extenders = StartupExtender.getExtenders((Lookup)this.project.getLookup(), (StartupExtender.StartMode)StartupExtender.StartMode.DEBUG);
        for (StartupExtender e : extenders) {
            params.addAll(e.getArguments());
        }
        if (params.isEmpty()) {
            params.add(String.format(this.getDebugCommand(), port));
            useV8Debug[0] = true;
        }
        params.addAll(this.getScriptArgsParams(script, args));
        return this.getParams(params);
    }

    private String getDebugCommand() {
        if (DebuggerOptions.getInstance().isBreakAtFirstLine()) {
            return DEBUG_BRK_COMMAND;
        }
        return DEBUG_COMMAND;
    }

    private List<String> getVersionParams() {
        return this.getParams(Collections.singletonList(VERSION_PARAM));
    }

    private List<String> getScriptArgsParams(File script, String args) {
        assert (script != null);
        ArrayList<String> params = new ArrayList<String>();
        params.add(script.getAbsolutePath());
        if (StringUtils.hasText(args)) {
            params.addAll(Arrays.asList(Utilities.parseParameters((String)args)));
        }
        return params;
    }

    List<String> getParams(List<String> params) {
        assert (params != null);
        return params;
    }

    @CheckForNull
    private static String validateResult(ValidationResult result) {
        if (result.isFaultless()) {
            return null;
        }
        if (result.hasErrors()) {
            return ((ValidationResult.Message)result.getErrors().get(0)).getMessage();
        }
        return ((ValidationResult.Message)result.getWarnings().get(0)).getMessage();
    }

    static {
        VERSIONS = new ConcurrentHashMap<String, Version>();
        UNKNOWN_VERSION = Version.fromDottedNotationWithFallback((String)"0.0");
        if (Utilities.isWindows()) {
            NODE_NAMES = new String[]{"node.exe"};
            IO_NAME = "iojs.exe";
        } else {
            NODE_NAMES = new String[]{"node", "nodejs"};
            IO_NAME = "iojs";
        }
    }

    private static final class DebugInfo {
        @NonNull
        public final Project project;
        @NonNull
        public final AtomicReference<Future<Integer>> taskRef;
        public final int port;

        public DebugInfo(Project project, AtomicReference<Future<Integer>> taskRef, int port) {
            assert (project != null);
            assert (taskRef != null);
            this.project = project;
            this.taskRef = taskRef;
            this.port = port;
        }
    }

    static final class FileLineParser {
        static final Pattern OUTPUT_FILE_LINE_PATTERN = Pattern.compile("(?:at |\\(|^)(?<FILE>[^:(]+?):(?<LINE>\\d+)(?::\\d+)?(?:\\)|$)");
        private final List<File> sourceRoots;

        public FileLineParser(List<File> sourceRoots) {
            assert (sourceRoots != null);
            this.sourceRoots = sourceRoots;
        }

        @CheckForNull
        Pair<File, Integer> getOutputFileLine(String line) {
            Pair<String, Integer> fileNameLine = FileLineParser.getOutputFileNameLine(line);
            if (fileNameLine == null) {
                return null;
            }
            String filepath = (String)fileNameLine.first();
            Integer lineNumber = (Integer)fileNameLine.second();
            File file = new File(filepath);
            if (file.isFile()) {
                return Pair.of((Object)file, (Object)lineNumber);
            }
            for (File sourceRoot : this.sourceRoots) {
                file = new File(sourceRoot, filepath);
                if (!file.isFile()) continue;
                return Pair.of((Object)file, (Object)lineNumber);
            }
            return null;
        }

        @CheckForNull
        static Pair<String, Integer> getOutputFileNameLine(String line) {
            Matcher matcher = OUTPUT_FILE_LINE_PATTERN.matcher(line.trim());
            if (!matcher.find()) {
                return null;
            }
            return Pair.of((Object)matcher.group("FILE"), (Object)Integer.valueOf(matcher.group("LINE")));
        }
    }

    private static final class FileOutputListener
    implements OutputListener {
        final File file;
        final int line;

        public FileOutputListener(File file, int line) {
            assert (file != null);
            this.file = file;
            this.line = line;
        }

        public void outputLineSelected(OutputEvent ev) {
        }

        public void outputLineAction(OutputEvent ev) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    FileUtils.openFile(file, line);
                }
            });
        }

        public void outputLineCleared(OutputEvent ev) {
        }
    }

    private static final class LineConvertorImpl
    implements LineConvertor {
        private static final RequestProcessor RP = new RequestProcessor("node.js debugger starter/connector");
        private final FileLineParser fileLineParser;
        @NullAllowed
        private final DebugInfo debugInfo;
        @NullAllowed
        final CountDownLatch debuggerCountDownLatch;
        volatile boolean debugging = false;

        public LineConvertorImpl(FileLineParser fileLineParser, @NullAllowed DebugInfo debugInfo) {
            assert (fileLineParser != null);
            this.fileLineParser = fileLineParser;
            this.debugInfo = debugInfo;
            if (debugInfo == null) {
                this.debuggerCountDownLatch = null;
            } else {
                this.debuggerCountDownLatch = new CountDownLatch(1);
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            assert (debuggerCountDownLatch != null);
                            boolean expected = debuggerCountDownLatch.await(5L, TimeUnit.SECONDS);
                            if (!expected) {
                                LOGGER.log(Level.INFO, "Connect node.js debugger timeout elapsed");
                            }
                            this.connectDebugger();
                        }
                        catch (InterruptedException ex) {
                            Thread.currentThread().interrupt();
                        }
                    }
                });
            }
        }

        public List<ConvertedLine> convert(String line) {
            if (this.debugInfo != null && !this.debugging && line.toLowerCase(Locale.US).startsWith("debugger listening on ")) {
                assert (this.debuggerCountDownLatch != null);
                this.debuggerCountDownLatch.countDown();
            }
            FileOutputListener outputListener = null;
            Pair<File, Integer> fileLine = this.fileLineParser.getOutputFileLine(line);
            if (fileLine != null) {
                outputListener = new FileOutputListener((File)fileLine.first(), (Integer)fileLine.second());
            }
            return Collections.singletonList(ConvertedLine.forText((String)line, outputListener));
        }

        void connectDebugger() {
            assert (this.debugInfo != null);
            Connector.Properties props = LineConvertorImpl.createConnectorProperties("localhost", this.debugInfo.port, this.debugInfo.project);
            try {
                Connector.connect((Connector.Properties)props, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        debugging = false;
                        assert (debugInfo != null);
                        assert (((LineConvertorImpl)this).debugInfo.project != null);
                        assert (((LineConvertorImpl)this).debugInfo.taskRef != null);
                        Future<Integer> task = ((LineConvertorImpl)this).debugInfo.taskRef.get();
                        assert (task != null) : LineConvertorImpl.access$000((LineConvertorImpl)this).project.getProjectDirectory();
                        task.cancel(true);
                    }
                });
                this.debugging = true;
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, "cannot run node.js debugger", ex);
                this.warnCannotDebug(ex);
            }
        }

        private static Connector.Properties createConnectorProperties(String host, int port, Project project) {
            List<File> sourceRoots = NodeJsUtils.getSourceRoots(project);
            List<File> siteRoots = NodeJsUtils.getSiteRoots(project);
            ArrayList<String> localPaths = new ArrayList<String>(sourceRoots.size());
            List localPathsExclusionFilter = Collections.emptyList();
            for (File src : sourceRoots) {
                localPaths.add(src.getAbsolutePath());
                for (File site : siteRoots) {
                    if (!FileUtils.isSubdirectoryOf(src, site) || src.equals(site)) continue;
                    if (localPathsExclusionFilter.isEmpty()) {
                        localPathsExclusionFilter = new ArrayList();
                    }
                    localPathsExclusionFilter.add(site.getAbsolutePath());
                }
            }
            return new Connector.Properties(host, port, localPaths, Collections.emptyList(), localPathsExclusionFilter);
        }

        protected void warnCannotDebug(IOException ex) {
            NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)Bundle.LineConvertorImpl_warn_debug(ex), 0);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)descriptor);
        }
    }

    private static final class LineConvertorFactoryImpl
    implements ExecutionDescriptor.LineConvertorFactory {
        private final List<File> files;
        private final Runnable preExecution;
        private final Runnable postExecution;
        private LineConvertorImpl executionLineConvertor;

        public LineConvertorFactoryImpl(List<URL> sourceRoots, @NullAllowed DebugInfo debugInfo) {
            assert (sourceRoots != null);
            this.files = new CopyOnWriteArrayList<File>(this.toFiles(sourceRoots));
            this.preExecution = () -> {
                this.executionLineConvertor = new LineConvertorImpl(new FileLineParser(this.files), debugInfo);
            };
            this.postExecution = () -> {
                this.executionLineConvertor = null;
            };
        }

        Runnable getPreExecution() {
            return this.preExecution;
        }

        Runnable getPostExecution() {
            return this.postExecution;
        }

        public LineConvertor newLineConvertor() {
            return this.executionLineConvertor;
        }

        private List<File> toFiles(List<URL> sourceRoots) {
            ArrayList<File> result = new ArrayList<File>(sourceRoots.size());
            for (URL sourceRoot : sourceRoots) {
                try {
                    result.add(Utilities.toFile((URI)sourceRoot.toURI()));
                }
                catch (URISyntaxException ex) {
                    LOGGER.log(Level.INFO, null, ex);
                }
            }
            return result;
        }
    }

    static class VersionOutputProcessorFactory
    implements ExecutionDescriptor.InputProcessorFactory2 {
        private static final Pattern VERSION_PATTERN = Pattern.compile("^v([\\d\\.]+)$");
        volatile String version;

        VersionOutputProcessorFactory() {
        }

        public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
            return InputProcessors.bridge((LineProcessor)new LineProcessor(){

                public void processLine(String line) {
                    assert (version == null) : version + " :: " + line;
                    version = this.parseVersion(line);
                }

                public void reset() {
                }

                public void close() {
                }
            });
        }

        @CheckForNull
        public String getVersion() {
            return this.version;
        }

        public String parseVersion(String line) {
            Matcher matcher = VERSION_PATTERN.matcher(line);
            if (matcher.matches()) {
                return matcher.group(1);
            }
            LOGGER.log(Level.INFO, "Unexpected node.js version line: {0}", line);
            return null;
        }
    }

    private static final class MacNodeExecutable
    extends NodeExecutable {
        private static final String BASH_COMMAND = "/bin/bash -lc";

        MacNodeExecutable(String nodePath, Project project) {
            super(nodePath, project);
        }

        @Override
        String getCommand() {
            return BASH_COMMAND;
        }

        @Override
        List<String> getParams(List<String> params) {
            StringBuilder sb = new StringBuilder(200);
            sb.append("\"");
            sb.append(this.nodePath);
            sb.append("\" \"");
            sb.append(StringUtils.implode(super.getParams(params), "\" \""));
            sb.append("\"");
            return Collections.singletonList(sb.toString());
        }
    }
}

