/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser.ir;

import com.oracle.js.parser.ir.Block;
import com.oracle.js.parser.ir.Expression;
import com.oracle.js.parser.ir.JoinPredecessorExpression;
import com.oracle.js.parser.ir.LexicalContext;
import com.oracle.js.parser.ir.LoopNode;
import com.oracle.js.parser.ir.Node;
import com.oracle.js.parser.ir.Symbol;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import com.oracle.js.parser.ir.visitor.TranslatorNodeVisitor;

public final class ForNode
extends LoopNode {
    private final Expression init;
    private final JoinPredecessorExpression modify;
    private Symbol iterator;
    public static final int IS_FOR_IN = 1;
    public static final int IS_FOR_EACH = 2;
    public static final int PER_ITERATION_SCOPE = 4;
    public static final int IS_FOR_OF = 8;
    private final int flags;

    public ForNode(int n, long l, int n2, Block block, int n3, Expression expression, JoinPredecessorExpression joinPredecessorExpression, JoinPredecessorExpression joinPredecessorExpression2) {
        super(n, l, n2, block, joinPredecessorExpression, false);
        this.flags = n3;
        this.init = expression;
        this.modify = joinPredecessorExpression2;
    }

    private ForNode(ForNode forNode, Expression expression, JoinPredecessorExpression joinPredecessorExpression, Block block, JoinPredecessorExpression joinPredecessorExpression2, int n, boolean bl) {
        super(forNode, joinPredecessorExpression, block, bl);
        this.init = expression;
        this.modify = joinPredecessorExpression2;
        this.flags = n;
        this.iterator = forNode.iterator;
    }

    @Override
    public Node accept(LexicalContext lexicalContext, NodeVisitor<? extends LexicalContext> nodeVisitor) {
        if (nodeVisitor.enterForNode(this)) {
            return nodeVisitor.leaveForNode(this.setInit(lexicalContext, this.init == null ? null : (Expression)this.init.accept(nodeVisitor)).setTest(lexicalContext, this.test == null ? null : (JoinPredecessorExpression)this.test.accept(nodeVisitor)).setModify(lexicalContext, this.modify == null ? null : (JoinPredecessorExpression)this.modify.accept(nodeVisitor)).setBody(lexicalContext, (Block)this.body.accept(nodeVisitor)));
        }
        return this;
    }

    @Override
    public <R> R accept(LexicalContext lexicalContext, TranslatorNodeVisitor<? extends LexicalContext, R> translatorNodeVisitor) {
        return translatorNodeVisitor.enterForNode(this);
    }

    @Override
    public void toString(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("for");
        stringBuilder.append(' ');
        if (this.isForEach()) {
            stringBuilder.append("each ");
        }
        stringBuilder.append('(');
        if (this.isForIn()) {
            this.init.toString(stringBuilder, bl);
            stringBuilder.append(" in ");
            this.modify.toString(stringBuilder, bl);
        } else if (this.isForOf()) {
            this.init.toString(stringBuilder, bl);
            stringBuilder.append(" of ");
            this.modify.toString(stringBuilder, bl);
        } else {
            if (this.init != null) {
                this.init.toString(stringBuilder, bl);
            }
            stringBuilder.append("; ");
            if (this.test != null) {
                this.test.toString(stringBuilder, bl);
            }
            stringBuilder.append("; ");
            if (this.modify != null) {
                this.modify.toString(stringBuilder, bl);
            }
        }
        stringBuilder.append(')');
    }

    @Override
    public boolean hasGoto() {
        return !this.isForInOrOf() && this.test == null;
    }

    @Override
    public boolean mustEnter() {
        if (this.isForInOrOf()) {
            return false;
        }
        return this.test == null;
    }

    public Expression getInit() {
        return this.init;
    }

    public ForNode setInit(LexicalContext lexicalContext, Expression expression) {
        if (this.init == expression) {
            return this;
        }
        return Node.replaceInLexicalContext(lexicalContext, this, new ForNode(this, expression, this.test, this.body, this.modify, this.flags, this.controlFlowEscapes));
    }

    public boolean isForIn() {
        return (this.flags & 1) != 0;
    }

    public boolean isForEach() {
        return (this.flags & 2) != 0;
    }

    public boolean isForOf() {
        return (this.flags & 8) != 0;
    }

    public boolean isForInOrOf() {
        return this.isForIn() || this.isForOf();
    }

    public Symbol getIterator() {
        return this.iterator;
    }

    public void setIterator(Symbol symbol) {
        this.iterator = symbol;
    }

    public JoinPredecessorExpression getModify() {
        return this.modify;
    }

    public ForNode setModify(LexicalContext lexicalContext, JoinPredecessorExpression joinPredecessorExpression) {
        if (this.modify == joinPredecessorExpression) {
            return this;
        }
        return Node.replaceInLexicalContext(lexicalContext, this, new ForNode(this, this.init, this.test, this.body, joinPredecessorExpression, this.flags, this.controlFlowEscapes));
    }

    @Override
    public ForNode setTest(LexicalContext lexicalContext, JoinPredecessorExpression joinPredecessorExpression) {
        if (this.test == joinPredecessorExpression) {
            return this;
        }
        return Node.replaceInLexicalContext(lexicalContext, this, new ForNode(this, this.init, joinPredecessorExpression, this.body, this.modify, this.flags, this.controlFlowEscapes));
    }

    @Override
    public Block getBody() {
        return this.body;
    }

    @Override
    public ForNode setBody(LexicalContext lexicalContext, Block block) {
        if (this.body == block) {
            return this;
        }
        return Node.replaceInLexicalContext(lexicalContext, this, new ForNode(this, this.init, this.test, block, this.modify, this.flags, this.controlFlowEscapes));
    }

    @Override
    public ForNode setControlFlowEscapes(LexicalContext lexicalContext, boolean bl) {
        if (this.controlFlowEscapes == bl) {
            return this;
        }
        return Node.replaceInLexicalContext(lexicalContext, this, new ForNode(this, this.init, this.test, this.body, this.modify, this.flags, bl));
    }

    @Override
    public boolean hasPerIterationScope() {
        return (this.flags & 4) != 0;
    }
}

