/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.execute;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.gradle.internal.UncheckedException;
import org.gradle.tooling.BuildCancelledException;
import org.gradle.tooling.BuildException;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.ConfigurableLauncher;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.gradle.GradleDaemon;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.modules.gradle.api.execute.GradleCommandLine;
import org.netbeans.modules.gradle.api.execute.RunConfig;
import org.netbeans.modules.gradle.api.execute.RunUtils;
import org.netbeans.modules.gradle.execute.AbstractGradleExecutor;
import org.netbeans.modules.gradle.execute.Bundle;
import org.netbeans.modules.gradle.execute.EscapeProcessingOutputStream;
import org.netbeans.modules.gradle.execute.GradlePlainEscapeProcessor;
import org.netbeans.modules.gradle.spi.GradleFiles;
import org.netbeans.modules.gradle.spi.GradleProgressListenerProvider;
import org.netbeans.modules.gradle.spi.GradleSettings;
import org.netbeans.spi.project.ui.support.BuildExecutionSupport;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.Pair;
import org.openide.util.io.ReaderInputStream;
import org.openide.windows.IOColorPrint;
import org.openide.windows.IOColors;
import org.openide.windows.InputOutput;

public final class GradleDaemonExecutor
extends AbstractGradleExecutor {
    private CancellationTokenSource cancelTokenSource;
    private static final Logger LOGGER = Logger.getLogger(GradleDaemonExecutor.class.getName());
    private final ProgressHandle handle;
    private InputStream inStream;
    private OutputStream outStream;
    private OutputStream errStream;
    private boolean cancelling;

    public GradleDaemonExecutor(RunConfig config) {
        super(config);
        this.handle = ProgressHandleFactory.createHandle((String)config.getTaskDisplayName(), (Cancellable)this, (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GradleDaemonExecutor.this.getInputOutput().select();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.taskSemaphore;
        synchronized (object) {
            if (this.task == null) {
                try {
                    this.taskSemaphore.wait();
                }
                catch (InterruptedException ex) {
                    LOGGER.log(Level.FINE, "interrupted", ex);
                }
            }
        }
        ProjectConnection pconn = null;
        InputOutput ioput = this.getInputOutput();
        this.actionStatesAtStart();
        this.handle.start();
        try {
            GradleBaseProject gbp;
            BuildExecutionSupport.registerRunningItem((BuildExecutionSupport.Item)this.item);
            if (GradleSettings.getDefault().isAlwaysShowOutput()) {
                ioput.select();
            }
            GradleConnector gconn = GradleConnector.newConnector();
            this.cancelTokenSource = GradleConnector.newCancellationTokenSource();
            File gradleInstall = RunUtils.evaluateGradleDistribution(this.config.getProject(), false);
            if (gradleInstall != null) {
                gconn.useInstallation(gradleInstall);
            } else {
                gconn.useBuildDistribution();
            }
            gconn.useGradleUserHomeDir(GradleSettings.getDefault().getGradleUserHome());
            File projectDir = FileUtil.toFile((FileObject)this.config.getProject().getProjectDirectory());
            pconn = gconn.forProjectDirectory(projectDir).connect();
            BuildLauncher buildLauncher = pconn.newBuild();
            GradleCommandLine cmd = this.config.getCommandLine();
            if (RunUtils.isAugmentedBuildEnabled(this.config.getProject())) {
                cmd = new GradleCommandLine(cmd);
                cmd.addParameter(GradleCommandLine.Parameter.INIT_SCRIPT, GradleDaemon.INIT_SCRIPT);
                cmd.addSystemProperty("NETBEANS_TOOLING_JAR", GradleDaemon.TOOLING_JAR);
            }
            cmd.configure((ConfigurableLauncher<?>)buildLauncher, (gbp = GradleBaseProject.get(this.config.getProject())) != null ? gbp.getRootDir() : null);
            this.printCommandLine();
            Pair<String, JavaPlatform> activePlatform = RunUtils.getActivePlatform(this.config.getProject());
            if (activePlatform.second() == null || !((JavaPlatform)activePlatform.second()).isValid()) {
                this.io.getErr().println(Bundle.NO_PLATFORM(activePlatform.first()));
                return;
            }
            if (!((JavaPlatform)activePlatform.second()).getInstallFolders().isEmpty()) {
                File javaHome = FileUtil.toFile((FileObject)((FileObject)((JavaPlatform)activePlatform.second()).getInstallFolders().iterator().next()));
                buildLauncher.setJavaHome(javaHome);
            }
            this.outStream = new EscapeProcessingOutputStream(new GradlePlainEscapeProcessor(this.io, this.config, false));
            this.errStream = new EscapeProcessingOutputStream(new GradlePlainEscapeProcessor(this.io, this.config, true));
            try {
                this.inStream = new ReaderInputStream(this.io.getIn(), "UTF-8");
                buildLauncher.setStandardInput(this.inStream);
            }
            catch (IOException javaHome) {
                // empty catch block
            }
            buildLauncher.setStandardOutput(this.outStream);
            buildLauncher.setStandardError(this.errStream);
            buildLauncher.addProgressListener(pe -> this.handle.progress(pe.getDescription()));
            buildLauncher.withCancellationToken(this.cancelTokenSource.token());
            if (this.config.getProject() != null) {
                Collection providers = this.config.getProject().getLookup().lookupAll(GradleProgressListenerProvider.class);
                for (GradleProgressListenerProvider provider : providers) {
                    buildLauncher.addProgressListener(provider.getProgressListener(), provider.getSupportedOperationTypes());
                }
            }
            buildLauncher.run();
            StatusDisplayer.getDefault().setStatusText(Bundle.BUILD_SUCCESS(this.getProjectName()));
        }
        catch (BuildCancelledException ex) {
            this.showAbort();
        }
        catch (UncheckedException | BuildException ex) {
            if (!this.cancelling) {
                StatusDisplayer.getDefault().setStatusText(Bundle.BUILD_FAILED(this.getProjectName()));
            } else {
                this.showAbort();
            }
        }
        catch (GradleConnectionException ex) {
            boolean handled = false;
            for (Throwable th = ex.getCause(); th != null && !handled; th = th.getCause()) {
                if (!(th instanceof StreamCorruptedException)) continue;
                LOGGER.log(Level.INFO, "Suspecting Gradle Serialization IO Error:", ex);
                try {
                    IOColorPrint.print((InputOutput)this.io, (CharSequence)Bundle.GRADLE_IO_ERROR(), (Color)IOColors.getColor((InputOutput)this.io, (IOColors.OutputType)IOColors.OutputType.LOG_WARNING));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                handled = true;
            }
            if (!handled) {
                throw ex;
            }
        }
        finally {
            BuildExecutionSupport.registerFinishedItem((BuildExecutionSupport.Item)this.item);
            if (pconn != null) {
                pconn.close();
            }
            this.closeInOutErr();
            this.checkForExternalModifications();
            this.handle.finish();
            this.markFreeTab();
            this.actionStatesAtFinish();
        }
    }

    private String getProjectName() {
        ProjectInformation info = ProjectUtils.getInformation((Project)this.config.getProject());
        return info.getDisplayName();
    }

    private void printCommandLine() {
        GradleBaseProject gbp;
        File dir;
        JavaPlatform activePlatform;
        StringBuilder commandLine = new StringBuilder(1024);
        String userHome = GradleSettings.getDefault().getPreferences().get("gradleUserHome", null);
        if (userHome != null) {
            commandLine.append("GRADLE_USER_HOME=\"").append(userHome).append("\"\n");
        }
        if ((activePlatform = (JavaPlatform)RunUtils.getActivePlatform(this.config.getProject()).second()) != null && activePlatform.isValid() && !activePlatform.getInstallFolders().isEmpty()) {
            File javaHome = FileUtil.toFile((FileObject)((FileObject)activePlatform.getInstallFolders().iterator().next()));
            commandLine.append("JAVA_HOME=\"").append(javaHome.getAbsolutePath()).append("\"\n");
        }
        if ((dir = FileUtil.toFile((FileObject)this.config.getProject().getProjectDirectory())) != null) {
            commandLine.append("cd ").append(dir.getAbsolutePath()).append("; ");
        }
        if ((gbp = GradleBaseProject.get(this.config.getProject())) != null && new GradleFiles(gbp.getProjectDir(), true).hasWrapper() && GradleSettings.getDefault().isWrapperPreferred()) {
            Path rootPath = gbp.getRootDir().toPath();
            Path projectPath = gbp.getProjectDir().toPath();
            String relRoot = projectPath.relativize(rootPath).toString();
            relRoot = relRoot.isEmpty() ? "." : relRoot;
            commandLine.append(relRoot).append("/gradlew");
        } else {
            File gradleDistribution = RunUtils.evaluateGradleDistribution(null, false);
            if (gradleDistribution != null) {
                File gradle = new File(gradleDistribution, "bin/gradle");
                commandLine.append(gradle.getAbsolutePath());
            }
        }
        for (String arg : this.config.getCommandLine().getSupportedCommandLine()) {
            commandLine.append(' ');
            if (arg.contains(" ") || arg.contains("*")) {
                commandLine.append('\'').append(arg).append('\'');
                continue;
            }
            commandLine.append(arg);
        }
        commandLine.append('\n');
        try {
            if (IOColorPrint.isSupported((InputOutput)this.io)) {
                IOColorPrint.print((InputOutput)this.io, (CharSequence)commandLine, (Color)IOColors.getColor((InputOutput)this.io, (IOColors.OutputType)IOColors.OutputType.INPUT));
            } else {
                this.io.getOut().print((Object)commandLine);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private synchronized void closeInOutErr() {
        if (this.inStream != null) {
            try {
                this.inStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.outStream != null) {
            try {
                this.outStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.errStream != null) {
            try {
                this.errStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void showAbort() {
        try {
            IOColorPrint.print((InputOutput)this.io, (CharSequence)Bundle.TXT_BUILD_ABORTED(), (Color)IOColors.getColor((InputOutput)this.io, (IOColors.OutputType)IOColors.OutputType.LOG_DEBUG));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean cancel() {
        if (!this.cancelling && this.cancelTokenSource != null) {
            this.handle.switchToIndeterminate();
            this.handle.setDisplayName(Bundle.LBL_ABORTING_BUILD());
            this.closeInOutErr();
            this.cancelling = true;
            this.cancelTokenSource.cancel();
            return true;
        }
        return false;
    }
}

