/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.automaton;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.tregex.automaton.IndexedState;
import com.oracle.truffle.regex.tregex.automaton.StateIndex;
import com.oracle.truffle.regex.tregex.automaton.StateSetBackingSet;
import com.oracle.truffle.regex.tregex.automaton.StateSetBackingSetFactory;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class StateSet<S extends IndexedState>
implements Set<S>,
Iterable<S> {
    private static final int SWITCH_TO_BACKING_SET_THRESHOLD = 4;
    private static final byte FLAG_HASH_COMPUTED = 1;
    private static final byte FLAG_STATE_LIST_SORTED = 2;
    private static final long SHORT_MASK = 65535L;
    private final StateIndex<? super S> stateIndex;
    private final StateSetBackingSetFactory backingSetFactory;
    private StateSetBackingSet backingSet;
    private byte flags = 0;
    private int size = 0;
    private long stateList = 0L;
    private int cachedHash;

    public StateSet(StateIndex<? super S> stateIndex, StateSetBackingSetFactory backingSetFactory) {
        this.stateIndex = stateIndex;
        this.backingSetFactory = backingSetFactory;
    }

    public StateSet(StateIndex<? super S> stateIndex) {
        this(stateIndex, StateSetBackingSetFactory.BIT_SET);
    }

    protected StateSet(StateSet<S> copy) {
        this.stateIndex = copy.stateIndex;
        this.flags = copy.flags;
        this.size = copy.size;
        this.backingSetFactory = copy.backingSetFactory;
        this.backingSet = copy.backingSet == null ? null : copy.backingSet.copy();
        this.stateList = copy.stateList;
        this.cachedHash = copy.cachedHash;
    }

    public StateSet<S> copy() {
        return new StateSet<S>(this);
    }

    public StateIndex<? super S> getStateIndex() {
        return this.stateIndex;
    }

    private void checkSwitchToBitSet(int newSize) {
        if (!this.useBackingSet() && newSize > 4) {
            this.backingSet = this.backingSetFactory.create(this.stateIndex.getNumberOfStates());
            for (int i = 0; i < this.size(); ++i) {
                this.backingSet.addBatch(StateSet.stateListElement(this.stateList));
                this.stateList >>>= 16;
            }
            this.backingSet.addBatchFinish();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    private boolean useBackingSet() {
        return this.backingSet != null;
    }

    private void setFlag(byte flag, boolean value) {
        this.flags = value ? (byte)(this.flags | flag) : (byte)(this.flags & ~flag);
    }

    private boolean isFlagSet(byte flag) {
        return (this.flags & flag) != 0;
    }

    private boolean isStateListSorted() {
        return this.isFlagSet((byte)2);
    }

    private void setStateListSorted(boolean stateListSorted) {
        this.setFlag((byte)2, stateListSorted);
    }

    private boolean isHashComputed() {
        return this.isFlagSet((byte)1);
    }

    private void setHashComputed(boolean hashComputed) {
        this.setFlag((byte)1, hashComputed);
    }

    private void increaseSize() {
        ++this.size;
        this.setHashComputed(false);
    }

    private void decreaseSize() {
        --this.size;
        this.setHashComputed(false);
    }

    private static short stateListElement(long stateList, int i) {
        return StateSet.stateListElement(stateList >>> 16 * i);
    }

    private static short stateListElement(long stateList) {
        return (short)(stateList & 0xFFFFL);
    }

    private void setStateListElement(int index, int value) {
        this.stateList = this.stateList & (65535L << 16 * index ^ 0xFFFFFFFFFFFFFFFFL) | (long)value << 16 * index;
    }

    @Override
    public boolean contains(Object state) {
        return this.contains(((IndexedState)state).getId());
    }

    private boolean contains(short id) {
        if (this.useBackingSet()) {
            return this.backingSet.contains(id);
        }
        long sl = this.stateList;
        for (int i = 0; i < this.size(); ++i) {
            if (StateSet.stateListElement(sl) == id) {
                return true;
            }
            sl >>>= 16;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (this.useBackingSet() && c instanceof StateSet && ((StateSet)c).useBackingSet()) {
            return this.backingSet.contains(((StateSet)c).backingSet);
        }
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean add(S state) {
        return this.add(state.getId());
    }

    @Override
    private boolean add(short id) {
        if (this.useBackingSet()) {
            if (this.backingSet.add(id)) {
                this.increaseSize();
                return true;
            }
            return false;
        }
        if (this.contains(id)) {
            return false;
        }
        this.checkSwitchToBitSet(this.size() + 1);
        if (this.useBackingSet()) {
            this.backingSet.add(id);
            this.increaseSize();
        } else {
            this.stateList = this.stateList << 16 | (long)id;
            this.increaseSize();
            this.setStateListSorted(false);
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends S> c) {
        this.checkSwitchToBitSet(this.size() + c.size());
        boolean ret = false;
        for (IndexedState s : c) {
            ret |= this.add((S)s);
        }
        return ret;
    }

    public void addBatch(S state) {
        assert (!this.contains(state));
        if (this.useBackingSet()) {
            this.backingSet.addBatch(state.getId());
            this.increaseSize();
        } else {
            this.add(state);
        }
    }

    public void addBatchFinish() {
        if (this.useBackingSet()) {
            this.backingSet.addBatchFinish();
        }
    }

    public void replace(S oldState, S newState) {
        assert (this.contains(oldState) && !this.contains(newState));
        if (this.useBackingSet()) {
            this.backingSet.replace(oldState.getId(), newState.getId());
            this.setHashComputed(false);
        } else {
            this.remove(oldState);
            this.add(newState);
        }
    }

    @Override
    public boolean remove(Object o) {
        return this.remove(((IndexedState)o).getId());
    }

    private boolean remove(short id) {
        if (this.useBackingSet()) {
            if (this.backingSet.remove(id)) {
                this.decreaseSize();
                return true;
            }
            return false;
        }
        long sl = this.stateList;
        for (int i = 0; i < this.size(); ++i) {
            if (StateSet.stateListElement(sl) == id) {
                this.removeStateListElement(i);
                this.decreaseSize();
                return true;
            }
            sl >>>= 16;
        }
        return false;
    }

    private void removeStateListElement(int i) {
        switch (i) {
            case 0: {
                this.stateList >>>= 16;
                break;
            }
            case 1: {
                this.stateList = this.stateList >>> 16 & 0xFFFFFFFF0000L | this.stateList & 0xFFFFL;
                break;
            }
            case 2: {
                this.stateList = this.stateList >>> 16 & 0xFFFF00000000L | this.stateList & 0xFFFFFFFFL;
                break;
            }
            case 3: {
                this.stateList &= 0xFFFFFFFFFFFFL;
                break;
            }
            default: {
                throw new IllegalArgumentException("stateList cannot be larger than 4 elements!");
            }
        }
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean ret = false;
        for (Object s : c) {
            ret |= this.remove(s);
        }
        return ret;
    }

    @Override
    public void clear() {
        if (this.useBackingSet()) {
            this.backingSet.clear();
        } else {
            this.stateList = 0L;
        }
        this.size = 0;
        this.setHashComputed(false);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    public boolean isDisjoint(StateSet<? extends S> other) {
        if (super.useBackingSet()) {
            if (this.useBackingSet()) {
                return this.backingSet.isDisjoint(other.backingSet);
            }
            long sl = this.stateList;
            for (int i = 0; i < this.size(); ++i) {
                if (super.contains(StateSet.stateListElement(sl))) {
                    return false;
                }
                sl >>>= 16;
            }
            return true;
        }
        long sl = other.stateList;
        for (int i = 0; i < other.size(); ++i) {
            if (this.contains(StateSet.stateListElement(sl))) {
                return false;
            }
            sl >>>= 16;
        }
        return true;
    }

    private void requireStateListSorted() {
        if (!this.isStateListSorted()) {
            for (int i = 1; i < this.size(); ++i) {
                short slj;
                int j;
                short sli = StateSet.stateListElement(this.stateList, i);
                for (j = i - 1; j >= 0 && (slj = StateSet.stateListElement(this.stateList, j)) > sli; --j) {
                    this.setStateListElement(j + 1, slj);
                }
                this.setStateListElement(j + 1, sli);
            }
            this.setStateListSorted(true);
        }
    }

    @Override
    public int hashCode() {
        if (!this.isHashComputed()) {
            if (this.useBackingSet()) {
                if (this.size <= 4) {
                    long hashStateList = 0L;
                    int shift = 0;
                    PrimitiveIterator.OfInt ofInt = this.backingSet.iterator();
                    while (ofInt.hasNext()) {
                        int i = (Integer)ofInt.next();
                        hashStateList |= (long)i << shift;
                        shift += 16;
                    }
                    this.cachedHash = Long.hashCode(hashStateList);
                } else {
                    this.cachedHash = this.backingSet.hashCode();
                }
            } else if (this.size == 0) {
                this.cachedHash = 0;
            } else {
                this.requireStateListSorted();
                if (this.size < 4) {
                    this.stateList &= -1L >>> 16 * (4 - this.size);
                }
                this.cachedHash = Long.hashCode(this.stateList);
            }
            this.setHashComputed(true);
        }
        return this.cachedHash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StateSet)) {
            return false;
        }
        StateSet o = (StateSet)obj;
        if (this.size() != o.size()) {
            return false;
        }
        if (this.useBackingSet() && o.useBackingSet()) {
            return this.backingSet.equals(o.backingSet);
        }
        if (this.useBackingSet() != o.useBackingSet()) {
            PrimitiveIterator.OfInt thisIterator = this.intIterator();
            PrimitiveIterator.OfInt otherIterator = o.intIterator();
            while (thisIterator.hasNext()) {
                if (thisIterator.nextInt() == otherIterator.nextInt()) continue;
                return false;
            }
            return true;
        }
        assert (!this.useBackingSet() && !o.useBackingSet());
        this.requireStateListSorted();
        o.requireStateListSorted();
        return this.stateList == o.stateList;
    }

    protected PrimitiveIterator.OfInt intIterator() {
        if (this.useBackingSet()) {
            return this.backingSet.iterator();
        }
        this.requireStateListSorted();
        return new StateListIterator();
    }

    @Override
    public Iterator<S> iterator() {
        return new StateSetIterator(this.stateIndex, this.intIterator());
    }

    @Override
    public Object[] toArray() {
        Object[] ret = new Object[this.size()];
        int i = 0;
        for (IndexedState s : this) {
            ret[i++] = s;
        }
        return ret;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        T[] r = a.length >= this.size() ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), this.size());
        int i = 0;
        for (IndexedState s : this) {
            r[i++] = s;
        }
        return r;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Stream<S> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return this.stream().map(Object::toString).collect(Collectors.joining(",", "{", "}"));
    }

    private final class StateSetIterator
    implements Iterator<S> {
        private final StateIndex<? super S> stateIndex;
        private final PrimitiveIterator.OfInt intIterator;

        private StateSetIterator(StateIndex<? super S> stateIndex, PrimitiveIterator.OfInt intIterator) {
            this.stateIndex = stateIndex;
            this.intIterator = intIterator;
        }

        @Override
        public boolean hasNext() {
            return this.intIterator.hasNext();
        }

        @Override
        public S next() {
            return (IndexedState)this.stateIndex.getState(this.intIterator.nextInt());
        }

        @Override
        public void remove() {
            this.intIterator.remove();
            StateSet.this.decreaseSize();
        }
    }

    private final class StateListIterator
    implements PrimitiveIterator.OfInt {
        private int i;

        private StateListIterator() {
        }

        @Override
        public int nextInt() {
            return StateSet.stateListElement(StateSet.this.stateList, this.i++);
        }

        @Override
        public boolean hasNext() {
            return this.i < StateSet.this.size;
        }

        @Override
        public void remove() {
            StateSet.this.removeStateListElement(--this.i);
        }
    }
}

