/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.unary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.cast.JSToInt32Node;
import com.oracle.truffle.js.nodes.unary.JSComplementNode;
import com.oracle.truffle.js.runtime.BigInt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSComplementNode.class)
public final class JSComplementNodeGen
extends JSComplementNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private int state_;
    @Node.Child
    private JSToInt32Node double_toInt32Node_;

    private JSComplementNodeGen(JavaScriptNode operand) {
        super(operand);
    }

    @Override
    public Object execute(VirtualFrame frameValue, Object operandNodeValue) {
        int state = this.state_;
        if ((state & 1) != 0 && operandNodeValue instanceof Integer) {
            int operandNodeValue_ = (Integer)operandNodeValue;
            return this.doInteger(operandNodeValue_);
        }
        if ((state & 2) != 0 && JSTypesGen.isImplicitDouble((state & 0x78) >>> 3, operandNodeValue)) {
            double operandNodeValue_ = JSTypesGen.asImplicitDouble((state & 0x78) >>> 3, operandNodeValue);
            return this.doDouble(operandNodeValue_, this.double_toInt32Node_);
        }
        if ((state & 4) != 0 && operandNodeValue instanceof BigInt) {
            BigInt operandNodeValue_ = (BigInt)operandNodeValue;
            return this.doBigInt(operandNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(operandNodeValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state = this.state_;
        if ((state & 6) == 0 && (state & 7) != 0) {
            return this.execute_int0(frameValue, state);
        }
        if ((state & 5) == 0 && (state & 7) != 0) {
            return this.execute_double1(frameValue, state);
        }
        return this.execute_generic2(frameValue, state);
    }

    private Object execute_int0(VirtualFrame frameValue, int state) {
        int operandNodeValue_;
        try {
            operandNodeValue_ = this.operandNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state & 1) != 0);
        return this.doInteger(operandNodeValue_);
    }

    private Object execute_double1(VirtualFrame frameValue, int state) {
        double operandNodeValue_;
        int operandNodeValue_int = 0;
        long operandNodeValue_long = 0L;
        try {
            if ((state & 0x70) == 0 && (state & 7) != 0) {
                operandNodeValue_long = this.operandNode.executeLong(frameValue);
                operandNodeValue_ = JSTypes.longToDouble(operandNodeValue_long);
            } else if ((state & 0x68) == 0 && (state & 7) != 0) {
                operandNodeValue_int = this.operandNode.executeInt(frameValue);
                operandNodeValue_ = JSTypes.intToDouble(operandNodeValue_int);
            } else if ((state & 0x58) == 0 && (state & 7) != 0) {
                operandNodeValue_ = this.operandNode.executeDouble(frameValue);
            } else {
                Object operandNodeValue__ = this.operandNode.execute(frameValue);
                operandNodeValue_ = JSTypesGen.expectImplicitDouble((state & 0x78) >>> 3, operandNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state & 2) != 0);
        return this.doDouble(operandNodeValue_, this.double_toInt32Node_);
    }

    private Object execute_generic2(VirtualFrame frameValue, int state) {
        Object operandNodeValue_ = this.operandNode.execute(frameValue);
        if ((state & 1) != 0 && operandNodeValue_ instanceof Integer) {
            int operandNodeValue__ = (Integer)operandNodeValue_;
            return this.doInteger(operandNodeValue__);
        }
        if ((state & 2) != 0 && JSTypesGen.isImplicitDouble((state & 0x78) >>> 3, operandNodeValue_)) {
            double operandNodeValue__ = JSTypesGen.asImplicitDouble((state & 0x78) >>> 3, operandNodeValue_);
            return this.doDouble(operandNodeValue__, this.double_toInt32Node_);
        }
        if ((state & 4) != 0 && operandNodeValue_ instanceof BigInt) {
            BigInt operandNodeValue__ = (BigInt)operandNodeValue_;
            return this.doBigInt(operandNodeValue__);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(operandNodeValue_);
    }

    @Override
    public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
        int state = this.state_;
        if ((state & 2) == 0 && (state & 3) != 0) {
            return this.executeInt_int3(frameValue, state);
        }
        if ((state & 1) == 0 && (state & 3) != 0) {
            return this.executeInt_double4(frameValue, state);
        }
        return this.executeInt_generic5(frameValue, state);
    }

    private int executeInt_int3(VirtualFrame frameValue, int state) throws UnexpectedResultException {
        int operandNodeValue_;
        try {
            operandNodeValue_ = this.operandNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return JSTypesGen.expectInteger(this.executeAndSpecialize(ex.getResult()));
        }
        assert ((state & 1) != 0);
        return this.doInteger(operandNodeValue_);
    }

    private int executeInt_double4(VirtualFrame frameValue, int state) throws UnexpectedResultException {
        double operandNodeValue_;
        int operandNodeValue_int = 0;
        long operandNodeValue_long = 0L;
        try {
            if ((state & 0x70) == 0 && (state & 7) != 0) {
                operandNodeValue_long = this.operandNode.executeLong(frameValue);
                operandNodeValue_ = JSTypes.longToDouble(operandNodeValue_long);
            } else if ((state & 0x68) == 0 && (state & 7) != 0) {
                operandNodeValue_int = this.operandNode.executeInt(frameValue);
                operandNodeValue_ = JSTypes.intToDouble(operandNodeValue_int);
            } else if ((state & 0x58) == 0 && (state & 7) != 0) {
                operandNodeValue_ = this.operandNode.executeDouble(frameValue);
            } else {
                Object operandNodeValue__ = this.operandNode.execute(frameValue);
                operandNodeValue_ = JSTypesGen.expectImplicitDouble((state & 0x78) >>> 3, operandNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            return JSTypesGen.expectInteger(this.executeAndSpecialize(ex.getResult()));
        }
        assert ((state & 2) != 0);
        return this.doDouble(operandNodeValue_, this.double_toInt32Node_);
    }

    private int executeInt_generic5(VirtualFrame frameValue, int state) throws UnexpectedResultException {
        Object operandNodeValue_ = this.operandNode.execute(frameValue);
        if ((state & 1) != 0 && operandNodeValue_ instanceof Integer) {
            int operandNodeValue__ = (Integer)operandNodeValue_;
            return this.doInteger(operandNodeValue__);
        }
        if ((state & 2) != 0 && JSTypesGen.isImplicitDouble((state & 0x78) >>> 3, operandNodeValue_)) {
            double operandNodeValue__ = JSTypesGen.asImplicitDouble((state & 0x78) >>> 3, operandNodeValue_);
            return this.doDouble(operandNodeValue__, this.double_toInt32Node_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectInteger(this.executeAndSpecialize(operandNodeValue_));
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        int state = this.state_;
        try {
            if ((state & 4) == 0 && (state & 7) != 0) {
                this.executeInt(frameValue);
                return;
            }
            this.execute(frameValue);
            return;
        }
        catch (UnexpectedResultException ex) {
            return;
        }
    }

    private Object executeAndSpecialize(Object operandNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            if (operandNodeValue instanceof Integer) {
                int operandNodeValue_ = (Integer)operandNodeValue;
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                Integer n = this.doInteger(operandNodeValue_);
                return n;
            }
            int doubleCast0 = JSTypesGen.specializeImplicitDouble(operandNodeValue);
            if (doubleCast0 != 0) {
                double operandNodeValue_ = JSTypesGen.asImplicitDouble(doubleCast0, operandNodeValue);
                this.double_toInt32Node_ = (JSToInt32Node)super.insert((Node)JSToInt32Node.create());
                state |= doubleCast0 << 3;
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                Integer n = this.doDouble(operandNodeValue_, this.double_toInt32Node_);
                return n;
            }
            if (operandNodeValue instanceof BigInt) {
                BigInt operandNodeValue_ = (BigInt)operandNodeValue;
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                BigInt bigInt = this.doBigInt(operandNodeValue_);
                return bigInt;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.operandNode}, new Object[]{operandNodeValue});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if ((state & 7) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & 7 & (state & 7) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        Object[] data = new Object[4];
        data[0] = 0;
        int state = this.state_;
        Object[] s = new Object[3];
        s[0] = "doInteger";
        s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s;
        s = new Object[3];
        s[0] = "doDouble";
        if ((state & 2) != 0) {
            s[1] = (byte)1;
            ArrayList<List<JSToInt32Node>> cached = new ArrayList<List<JSToInt32Node>>();
            cached.add(Arrays.asList(this.double_toInt32Node_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[2] = s;
        s = new Object[3];
        s[0] = "doBigInt";
        s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static JSComplementNode create(JavaScriptNode operand) {
        return new JSComplementNodeGen(operand);
    }
}

