/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.DateTimePatternGenerator;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.GregorianCalendar;
import com.ibm.icu.util.TimeZone;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSBuiltinObject;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSDate;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSUserObject;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.IntlUtil;
import com.oracle.truffle.js.runtime.util.LazyValue;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;

public final class JSDateTimeFormat
extends JSBuiltinObject
implements JSConstructorFactory.Default.WithFunctions,
PrototypeSupplier {
    public static final String CLASS_NAME = "DateTimeFormat";
    public static final String PROTOTYPE_NAME = "DateTimeFormat.prototype";
    private static final HiddenKey INTERNAL_STATE_ID = new HiddenKey("_internalState");
    private static final Property INTERNAL_STATE_PROPERTY;
    public static final JSDateTimeFormat INSTANCE;
    private static final LazyValue<UnmodifiableEconomicMap<String, String>> canonicalTimeZoneIDMap;
    private static final LazyValue<UnmodifiableEconomicMap<DateFormat.Field, String>> fieldToTypeMap;

    private JSDateTimeFormat() {
    }

    public static boolean isJSDateTimeFormat(Object obj) {
        return JSObject.isDynamicObject(obj) && JSDateTimeFormat.isJSDateTimeFormat((DynamicObject)obj);
    }

    public static boolean isJSDateTimeFormat(DynamicObject obj) {
        return JSDateTimeFormat.isInstance(obj, (JSClass)INSTANCE);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public String getClassName(DynamicObject object) {
        return this.getClassName();
    }

    @Override
    public DynamicObject createPrototype(JSRealm realm, DynamicObject ctor) {
        JSContext ctx = realm.getContext();
        DynamicObject numberFormatPrototype = JSObject.createInit(realm, realm.getObjectPrototype(), (JSClass)JSUserObject.INSTANCE);
        JSObjectUtil.putConstructorProperty(ctx, numberFormatPrototype, ctor);
        JSObjectUtil.putFunctionsFromContainer(realm, numberFormatPrototype, PROTOTYPE_NAME);
        JSObjectUtil.putConstantAccessorProperty(ctx, numberFormatPrototype, "format", JSDateTimeFormat.createFormatFunctionGetter(realm, ctx), Undefined.instance);
        JSObjectUtil.putDataProperty(ctx, numberFormatPrototype, Symbol.SYMBOL_TO_STRING_TAG, "Object", JSAttributes.configurableNotEnumerableNotWritable());
        return numberFormatPrototype;
    }

    @Override
    public Shape makeInitialShape(JSContext ctx, DynamicObject prototype) {
        Shape initialShape = JSObjectUtil.getProtoChildShape(prototype, INSTANCE, ctx);
        initialShape = initialShape.addProperty(INTERNAL_STATE_PROPERTY);
        return initialShape;
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm);
    }

    public static DynamicObject create(JSContext context) {
        InternalState state = new InternalState();
        DynamicObject result = JSObject.create(context, context.getDateTimeFormatFactory(), state);
        assert (JSDateTimeFormat.isJSDateTimeFormat(result));
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    public static void setupInternalDateTimeFormat(JSContext ctx, InternalState state, String[] locales, String weekdayOpt, String eraOpt, String yearOpt, String monthOpt, String dayOpt, String hourOpt, String hcOpt, Boolean hour12Opt, String minuteOpt, String secondOpt, String tzNameOpt, TimeZone timeZone) {
        String bestPattern;
        String selectedTag = IntlUtil.selectedLocale(ctx, locales);
        Locale selectedLocale = selectedTag != null ? Locale.forLanguageTag(selectedTag) : ctx.getLocale();
        Locale strippedLocale = selectedLocale.stripExtensions();
        String skeleton = JSDateTimeFormat.makeSkeleton(weekdayOpt, eraOpt, yearOpt, monthOpt, dayOpt, hourOpt, hcOpt, hour12Opt, minuteOpt, secondOpt, tzNameOpt);
        DateTimePatternGenerator patternGenerator = DateTimePatternGenerator.getInstance((Locale)strippedLocale);
        String baseSkeleton = patternGenerator.getBaseSkeleton(bestPattern = patternGenerator.getBestPattern(skeleton));
        if (JSDateTimeFormat.containsOneOf(baseSkeleton, "eEc")) {
            state.weekday = weekdayOpt;
        }
        if (baseSkeleton.contains("G")) {
            state.era = eraOpt;
        }
        if (JSDateTimeFormat.containsOneOf(baseSkeleton, "YyUu")) {
            state.year = yearOpt;
        }
        if (JSDateTimeFormat.containsOneOf(baseSkeleton, "ML")) {
            state.month = monthOpt;
        }
        if (JSDateTimeFormat.containsOneOf(baseSkeleton, "dDFg")) {
            state.day = dayOpt;
        }
        if (JSDateTimeFormat.containsOneOf(baseSkeleton, "hHKk")) {
            state.hour = hourOpt;
            state.hourCycle = hcOpt;
            state.hour12 = JSDateTimeFormat.containsOneOf(baseSkeleton, "hK");
        }
        if (baseSkeleton.contains("m")) {
            state.minute = minuteOpt;
        }
        if (JSDateTimeFormat.containsOneOf(baseSkeleton, "sSA")) {
            state.second = secondOpt;
        }
        state.initialized = true;
        SimpleDateFormat dateFormat = new SimpleDateFormat(bestPattern, strippedLocale);
        state.dateFormat = (DateFormat)dateFormat;
        state.locale = strippedLocale.toLanguageTag();
        state.calendar = Calendar.getInstance(strippedLocale).getCalendarType();
        if ("gregory".equals(state.calendar)) {
            com.ibm.icu.util.Calendar calendar = dateFormat.getCalendar();
            if (!(calendar instanceof GregorianCalendar)) {
                calendar = new GregorianCalendar(strippedLocale);
                dateFormat.setCalendar(calendar);
            }
            ((GregorianCalendar)calendar).setGregorianChange(new Date(Long.MIN_VALUE));
        }
        if (tzNameOpt != null && !tzNameOpt.isEmpty()) {
            state.timeZoneName = tzNameOpt;
        }
        state.dateFormat.setTimeZone(timeZone);
        state.timeZone = timeZone.getID();
    }

    private static String weekdayOptToSkeleton(String weekdayOpt) {
        if (weekdayOpt == null) {
            return "";
        }
        switch (weekdayOpt) {
            case "narrow": {
                return "eeeee";
            }
            case "short": {
                return "eee";
            }
            case "long": {
                return "eeee";
            }
        }
        return "";
    }

    private static String eraOptToSkeleton(String eraOpt) {
        if (eraOpt == null) {
            return "";
        }
        switch (eraOpt) {
            case "narrow": {
                return "GGGGG";
            }
            case "short": {
                return "GGG";
            }
            case "long": {
                return "GGGG";
            }
        }
        return "";
    }

    private static String yearOptToSkeleton(String yearOpt) {
        if (yearOpt == null) {
            return "";
        }
        switch (yearOpt) {
            case "2-digit": {
                return "yy";
            }
            case "numeric": {
                return "y";
            }
        }
        return "";
    }

    private static String monthOptToSkeleton(String monthOpt) {
        if (monthOpt == null) {
            return "";
        }
        switch (monthOpt) {
            case "2-digit": {
                return "MM";
            }
            case "numeric": {
                return "M";
            }
            case "narrow": {
                return "MMMMM";
            }
            case "short": {
                return "MMM";
            }
            case "long": {
                return "MMMM";
            }
        }
        return "";
    }

    private static String dayOptToSkeleton(String dayOpt) {
        if (dayOpt == null) {
            return "";
        }
        switch (dayOpt) {
            case "2-digit": {
                return "dd";
            }
            case "numeric": {
                return "d";
            }
        }
        return "";
    }

    private static String hourOptToSkeleton(String hourOpt, String hcOpt, Boolean hour12Opt) {
        if (hourOpt == null) {
            return "";
        }
        switch (hourOpt) {
            case "2-digit": {
                if (hcOpt == null) {
                    if (hour12Opt != null) {
                        if (hour12Opt.booleanValue()) {
                            return "KK";
                        }
                        return "HH";
                    }
                    return "jj";
                }
                switch (hcOpt) {
                    case "h11": {
                        return "KK";
                    }
                    case "h12": {
                        return "hh";
                    }
                    case "h23": {
                        return "HH";
                    }
                    case "h24": {
                        return "kk";
                    }
                }
                break;
            }
            case "numeric": {
                if (hcOpt == null) {
                    if (hour12Opt != null) {
                        if (hour12Opt.booleanValue()) {
                            return "K";
                        }
                        return "H";
                    }
                    return "j";
                }
                switch (hcOpt) {
                    case "h11": {
                        return "K";
                    }
                    case "h12": {
                        return "h";
                    }
                    case "h23": {
                        return "H";
                    }
                    case "h24": {
                        return "k";
                    }
                }
            }
        }
        return "";
    }

    private static String minuteOptToSkeleton(String minuteOpt) {
        if (minuteOpt == null) {
            return "";
        }
        switch (minuteOpt) {
            case "2-digit": {
                return "mm";
            }
            case "numeric": {
                return "m";
            }
        }
        return "";
    }

    private static String secondOptToSkeleton(String secondOpt) {
        if (secondOpt == null) {
            return "";
        }
        switch (secondOpt) {
            case "2-digit": {
                return "ss";
            }
            case "numeric": {
                return "s";
            }
        }
        return "";
    }

    private static String timeZoneNameOptToSkeleton(String timeZoneNameOpt) {
        if (timeZoneNameOpt == null) {
            return "";
        }
        switch (timeZoneNameOpt) {
            case "short": {
                return "v";
            }
            case "long": {
                return "vvvv";
            }
        }
        return "";
    }

    private static String makeSkeleton(String weekdayOpt, String eraOpt, String yearOpt, String monthOpt, String dayOpt, String hourOpt, String hcOpt, Boolean hour12Opt, String minuteOpt, String secondOpt, String timeZoneNameOpt) {
        return JSDateTimeFormat.weekdayOptToSkeleton(weekdayOpt) + JSDateTimeFormat.eraOptToSkeleton(eraOpt) + JSDateTimeFormat.yearOptToSkeleton(yearOpt) + JSDateTimeFormat.monthOptToSkeleton(monthOpt) + JSDateTimeFormat.dayOptToSkeleton(dayOpt) + JSDateTimeFormat.hourOptToSkeleton(hourOpt, hcOpt, hour12Opt) + JSDateTimeFormat.minuteOptToSkeleton(minuteOpt) + JSDateTimeFormat.secondOptToSkeleton(secondOpt) + JSDateTimeFormat.timeZoneNameOptToSkeleton(timeZoneNameOpt);
    }

    private static UnmodifiableEconomicMap<String, String> initCanonicalTimeZoneIDMap() {
        CompilerAsserts.neverPartOfCompilation();
        EconomicMap map = EconomicMap.create();
        for (String available : TimeZone.getAvailableIDs()) {
            map.put((Object)IntlUtil.toUpperCase(available), (Object)TimeZone.getCanonicalID((String)available));
        }
        return map;
    }

    @CompilerDirectives.TruffleBoundary
    public static TimeZone toTimeZone(Object tzVal) {
        if (tzVal != Undefined.instance) {
            String tzId = JSDateTimeFormat.canonicalizeTimeZone(JSRuntime.toString(tzVal));
            if (tzId != null) {
                return TimeZone.getTimeZone((String)tzId);
            }
            throw Errors.createRangeError(String.format("Invalid time zone %s", tzVal));
        }
        return TimeZone.getDefault();
    }

    @CompilerDirectives.TruffleBoundary
    private static String canonicalizeTimeZone(String tzId) {
        String ucTzId = IntlUtil.toUpperCase(tzId);
        String canTzId = (String)canonicalTimeZoneIDMap.get().get((Object)ucTzId);
        if (canTzId == null) {
            return null;
        }
        if (canTzId.equals("Etc/UTC") || canTzId.equals("Etc/GMT")) {
            return "UTC";
        }
        return canTzId;
    }

    private static boolean containsOneOf(String suspect, String containees) {
        for (byte c : containees.getBytes()) {
            if (suspect.indexOf(c) <= -1) continue;
            return true;
        }
        return false;
    }

    public static DateFormat getDateFormatProperty(DynamicObject obj) {
        return JSDateTimeFormat.getInternalState(obj).dateFormat;
    }

    @CompilerDirectives.TruffleBoundary
    public static String format(JSContext context, DynamicObject numberFormatObj, Object n) {
        DateFormat dateFormat = JSDateTimeFormat.getDateFormatProperty(numberFormatObj);
        return dateFormat.format((Object)JSDateTimeFormat.timeClip(context, n));
    }

    private static double timeClip(JSContext context, Object n) {
        double x;
        if (n == Undefined.instance) {
            x = context.getRealm().currentTimeMillis();
        } else {
            x = JSDate.timeClip(JSRuntime.toDouble(n));
            if (Double.isNaN(x)) {
                JSDateTimeFormat.throwDateOutOfRange();
            }
        }
        return x;
    }

    private static void throwDateOutOfRange() throws JSException {
        throw Errors.createRangeError("Provided date is not in valid range.");
    }

    private static UnmodifiableEconomicMap<DateFormat.Field, String> initializeFieldToTypeMap() {
        CompilerAsserts.neverPartOfCompilation();
        EconomicMap map = EconomicMap.create((int)14);
        map.put((Object)DateFormat.Field.AM_PM, (Object)"dayPeriod");
        map.put((Object)DateFormat.Field.ERA, (Object)"era");
        map.put((Object)DateFormat.Field.YEAR, (Object)"year");
        map.put((Object)DateFormat.Field.MONTH, (Object)"month");
        map.put((Object)DateFormat.Field.DOW_LOCAL, (Object)"weekday");
        map.put((Object)DateFormat.Field.DAY_OF_WEEK, (Object)"weekday");
        map.put((Object)DateFormat.Field.DAY_OF_MONTH, (Object)"day");
        map.put((Object)DateFormat.Field.HOUR0, (Object)"hour");
        map.put((Object)DateFormat.Field.HOUR1, (Object)"hour");
        map.put((Object)DateFormat.Field.HOUR_OF_DAY0, (Object)"hour");
        map.put((Object)DateFormat.Field.HOUR_OF_DAY1, (Object)"hour");
        map.put((Object)DateFormat.Field.MINUTE, (Object)"minute");
        map.put((Object)DateFormat.Field.SECOND, (Object)"second");
        map.put((Object)DateFormat.Field.TIME_ZONE, (Object)"timeZoneName");
        return map;
    }

    private static String fieldToType(DateFormat.Field field) {
        return (String)fieldToTypeMap.get().get((Object)field);
    }

    @CompilerDirectives.TruffleBoundary
    public static DynamicObject formatToParts(JSContext context, DynamicObject numberFormatObj, Object n) {
        DateFormat dateFormat = JSDateTimeFormat.getDateFormatProperty(numberFormatObj);
        double x = JSDateTimeFormat.timeClip(context, n);
        ArrayList<Object> resultParts = new ArrayList<Object>();
        AttributedCharacterIterator fit = dateFormat.formatToCharacterIterator((Object)x);
        String formatted = dateFormat.format((Object)x);
        int i = fit.getBeginIndex();
        while (i < fit.getEndIndex()) {
            fit.setIndex(i);
            Map<AttributedCharacterIterator.Attribute, Object> attributes = fit.getAttributes();
            Set<AttributedCharacterIterator.Attribute> attKeySet = attributes.keySet();
            if (!attKeySet.isEmpty()) {
                Iterator<AttributedCharacterIterator.Attribute> iterator = attKeySet.iterator();
                if (!iterator.hasNext()) continue;
                AttributedCharacterIterator.Attribute a = iterator.next();
                if (a instanceof DateFormat.Field) {
                    String value = formatted.substring(fit.getRunStart(), fit.getRunLimit());
                    String type = JSDateTimeFormat.fieldToType((DateFormat.Field)a);
                    assert (type != null) : a;
                    resultParts.add(JSDateTimeFormat.makePart(context, type, value));
                    i = fit.getRunLimit();
                    continue;
                }
                throw Errors.shouldNotReachHere();
            }
            String value = formatted.substring(fit.getRunStart(), fit.getRunLimit());
            resultParts.add(JSDateTimeFormat.makePart(context, "literal", value));
            i = fit.getRunLimit();
        }
        return JSArray.createConstant(context, resultParts.toArray());
    }

    private static Object makePart(JSContext context, String type, String value) {
        DynamicObject p = JSUserObject.create(context);
        JSObject.set(p, "type", (Object)type);
        JSObject.set(p, "value", (Object)value);
        return p;
    }

    @CompilerDirectives.TruffleBoundary
    public static DynamicObject resolvedOptions(JSContext context, DynamicObject numberFormatObj) {
        InternalState state = JSDateTimeFormat.getInternalState(numberFormatObj);
        return state.toResolvedOptionsObject(context);
    }

    public static InternalState getInternalState(DynamicObject numberFormatObj) {
        return (InternalState)INTERNAL_STATE_PROPERTY.get(numberFormatObj, JSDateTimeFormat.isJSDateTimeFormat(numberFormatObj));
    }

    private static CallTarget createGetFormatCallTarget(final JSContext context) {
        return Truffle.getRuntime().createCallTarget((RootNode)new JavaScriptRootNode(context.getLanguage(), null, null){
            private final ConditionProfile isAsyncProfile;
            private final ConditionProfile setProtoProfile;
            private final BranchProfile errorBranch;
            @CompilerDirectives.CompilationFinal
            private TruffleLanguage.ContextReference<JSRealm> realmRef;
            {
                super(lang, sourceSection, frameDescriptor);
                this.isAsyncProfile = ConditionProfile.createBinaryProfile();
                this.setProtoProfile = ConditionProfile.createBinaryProfile();
                this.errorBranch = BranchProfile.create();
            }

            public Object execute(VirtualFrame frame) {
                Object[] frameArgs = frame.getArguments();
                Object numberFormatObj = JSArguments.getThisObject(frameArgs);
                if (JSDateTimeFormat.isJSDateTimeFormat(numberFormatObj)) {
                    InternalState state = JSDateTimeFormat.getInternalState((DynamicObject)numberFormatObj);
                    if (state == null || !state.initialized) {
                        this.errorBranch.enter();
                        throw Errors.createTypeErrorMethodCalledOnNonObjectOrWrongType("format");
                    }
                    if (state.boundFormatFunction == null) {
                        if (this.realmRef == null) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            this.realmRef = this.lookupContextReference(JavaScriptLanguage.class);
                        }
                        JSFunctionData formatFunctionData = context.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.DateTimeFormatFormat, c -> JSDateTimeFormat.createFormatFunctionData(c));
                        DynamicObject formatFn = JSFunction.create((JSRealm)this.realmRef.get(), formatFunctionData);
                        DynamicObject boundFn = JSFunction.boundFunctionCreate(context, formatFn, numberFormatObj, new Object[0], JSObject.getPrototype(formatFn), true, this.isAsyncProfile, this.setProtoProfile);
                        state.boundFormatFunction = boundFn;
                    }
                    return state.boundFormatFunction;
                }
                this.errorBranch.enter();
                throw Errors.createTypeErrorTypeXExpected(JSDateTimeFormat.CLASS_NAME);
            }
        });
    }

    private static JSFunctionData createFormatFunctionData(final JSContext context) {
        return JSFunctionData.createCallOnly(context, (CallTarget)Truffle.getRuntime().createCallTarget((RootNode)new JavaScriptRootNode(context.getLanguage(), null, null){

            public Object execute(VirtualFrame frame) {
                Object[] arguments = frame.getArguments();
                DynamicObject thisObj = (DynamicObject)JSArguments.getThisObject(arguments);
                DynamicObject n = JSArguments.getUserArgumentCount(arguments) > 0 ? JSArguments.getUserArgument(arguments, 0) : Undefined.instance;
                return JSDateTimeFormat.format(context, thisObj, n);
            }
        }), 1, "format");
    }

    private static DynamicObject createFormatFunctionGetter(JSRealm realm, JSContext context) {
        JSFunctionData fd = realm.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.DateTimeFormatGetFormat, c -> {
            CallTarget ct = JSDateTimeFormat.createGetFormatCallTarget(context);
            return JSFunctionData.create(context, ct, ct, 0, "get format", false, false, false, true);
        });
        return JSFunction.create(realm, fd);
    }

    @Override
    public DynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getDateTimeFormatPrototype();
    }

    static {
        INSTANCE = new JSDateTimeFormat();
        canonicalTimeZoneIDMap = new LazyValue<UnmodifiableEconomicMap>(JSDateTimeFormat::initCanonicalTimeZoneIDMap);
        Shape.Allocator allocator = JSShape.makeAllocator(JSObject.LAYOUT);
        INTERNAL_STATE_PROPERTY = JSObjectUtil.makeHiddenProperty(INTERNAL_STATE_ID, allocator.locationForType(InternalState.class, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)));
        fieldToTypeMap = new LazyValue<UnmodifiableEconomicMap>(JSDateTimeFormat::initializeFieldToTypeMap);
    }

    public static class InternalState {
        private boolean initialized = false;
        private DateFormat dateFormat;
        private DynamicObject boundFormatFunction = null;
        private String locale;
        private String calendar;
        private String numberingSystem = "latn";
        private String weekday;
        private String era;
        private String year;
        private String month;
        private String day;
        private String hour;
        private String minute;
        private String second;
        private Boolean hour12;
        private String hourCycle;
        private String timeZoneName;
        private String timeZone;

        DynamicObject toResolvedOptionsObject(JSContext context) {
            DynamicObject result = JSUserObject.create(context);
            JSObjectUtil.defineDataProperty(result, "locale", this.locale, JSAttributes.getDefault());
            if (this.calendar != null) {
                JSObjectUtil.defineDataProperty(result, "calendar", this.calendar, JSAttributes.getDefault());
            }
            JSObjectUtil.defineDataProperty(result, "numberingSystem", this.numberingSystem, JSAttributes.getDefault());
            if (this.timeZone != null) {
                JSObjectUtil.defineDataProperty(result, "timeZone", this.timeZone, JSAttributes.getDefault());
            }
            if (this.hourCycle != null) {
                JSObjectUtil.defineDataProperty(result, "hourCycle", this.hourCycle, JSAttributes.getDefault());
            }
            if (this.hour12 != null) {
                JSObjectUtil.defineDataProperty(result, "hour12", this.hour12, JSAttributes.getDefault());
            }
            if (this.weekday != null) {
                JSObjectUtil.defineDataProperty(result, "weekday", this.weekday, JSAttributes.getDefault());
            }
            if (this.era != null) {
                JSObjectUtil.defineDataProperty(result, "era", this.era, JSAttributes.getDefault());
            }
            if (this.year != null) {
                JSObjectUtil.defineDataProperty(result, "year", this.year, JSAttributes.getDefault());
            }
            if (this.month != null) {
                JSObjectUtil.defineDataProperty(result, "month", this.month, JSAttributes.getDefault());
            }
            if (this.day != null) {
                JSObjectUtil.defineDataProperty(result, "day", this.day, JSAttributes.getDefault());
            }
            if (this.hour != null) {
                JSObjectUtil.defineDataProperty(result, "hour", this.hour, JSAttributes.getDefault());
            }
            if (this.minute != null) {
                JSObjectUtil.defineDataProperty(result, "minute", this.minute, JSAttributes.getDefault());
            }
            if (this.second != null) {
                JSObjectUtil.defineDataProperty(result, "second", this.second, JSAttributes.getDefault());
            }
            if (this.timeZoneName != null) {
                JSObjectUtil.defineDataProperty(result, "timeZoneName", this.timeZoneName, JSAttributes.getDefault());
            }
            return result;
        }
    }
}

