/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ArrowFunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceName;
import org.netbeans.modules.php.editor.parser.astnodes.NullableType;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.netbeans.modules.php.editor.verification.UnhandledErrorRule;
import org.netbeans.modules.php.editor.verification.VerificationError;
import org.openide.filesystems.FileObject;

public class UnusableTypesUnhandledError
extends UnhandledErrorRule {
    public String getDisplayName() {
        return Bundle.UnusableTypesUnhandledError_displayName();
    }

    @Override
    public void invoke(PHPRuleContext context, List<Error> result) {
        FileObject fileObject;
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() != null && (fileObject = phpParseResult.getSnapshot().getSource().getFileObject()) != null) {
            CheckVisitor checkVisitor = new CheckVisitor(fileObject);
            phpParseResult.getProgram().accept(checkVisitor);
            result.addAll(checkVisitor.getErrors());
        }
    }

    private static final class UnusableType
    extends VerificationError {
        private static final String KEY = "Php.Unusable.Type";
        private final String type;
        private final String context;

        private UnusableType(FileObject fileObject, int startOffset, int endOffset, String type, String context) {
            super(fileObject, startOffset, endOffset);
            this.type = type;
            this.context = context;
        }

        public String getDisplayName() {
            return Bundle.UnusableType_displayName(this.type, this.context);
        }

        public String getDescription() {
            return Bundle.UnusableType_description(this.type, this.context);
        }

        public String getKey() {
            return KEY;
        }
    }

    private static final class CheckVisitor
    extends DefaultVisitor {
        private final List<VerificationError> errors = new ArrayList<VerificationError>();
        private final FileObject fileObject;

        private CheckVisitor(FileObject fileObject) {
            assert (fileObject != null);
            this.fileObject = fileObject;
        }

        private List<VerificationError> getErrors() {
            return Collections.unmodifiableList(this.errors);
        }

        @Override
        public void visit(FieldsDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            Expression fieldType = node.getFieldType();
            if (fieldType != null) {
                this.checkFieldType(fieldType);
            }
            super.visit(node);
        }

        @Override
        public void visit(FormalParameter node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            Expression parameterType = node.getParameterType();
            if (parameterType != null) {
                this.checkParameterType(parameterType);
            }
            super.visit(node);
        }

        @Override
        public void visit(ArrowFunctionDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            Expression returnType = node.getReturnType();
            if (returnType != null) {
                this.checkArrowFunctionReturnType(returnType);
            }
            super.visit(node);
        }

        private void checkFieldType(Expression fieldType) {
            Expression type = fieldType;
            if (fieldType instanceof NullableType) {
                type = ((NullableType)fieldType).getType();
            }
            if (type == null) {
                return;
            }
            if (type instanceof Identifier) {
                if (CheckVisitor.isCallableType((Identifier)type)) {
                    this.createError(type, "callable", "property");
                }
            } else if (type instanceof NamespaceName && CheckVisitor.isVoidType((NamespaceName)type)) {
                this.createError(type, "void", "property");
            }
        }

        private void checkParameterType(Expression parameterType) {
            if (parameterType instanceof NamespaceName && CheckVisitor.isVoidType((NamespaceName)parameterType)) {
                this.createError(parameterType, "void", "parameter");
            }
        }

        private void checkArrowFunctionReturnType(Expression returnType) {
            if (returnType instanceof NamespaceName && CheckVisitor.isVoidType((NamespaceName)returnType)) {
                this.createError(returnType, "void", "return");
            }
        }

        private void createError(ASTNode node, String type, String context) {
            this.createError(node.getStartOffset(), node.getEndOffset(), type, context);
        }

        private void createError(int startOffset, int endOffset, String type, String context) {
            this.errors.add(new UnusableType(this.fileObject, startOffset, endOffset, type, context));
        }

        private static boolean isCallableType(Identifier identifier) {
            return !identifier.isKeyword() && "callable".equals(identifier.getName().toLowerCase());
        }

        private static boolean isVoidType(NamespaceName namespaceName) {
            return "void".equals(CodeUtils.extractUnqualifiedName(namespaceName));
        }
    }
}

