/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.karma.coverage;

import java.awt.EventQueue;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.javascript.karma.coverage.Bundle;
import org.netbeans.modules.javascript.karma.coverage.CloverLogParser;
import org.netbeans.modules.web.clientproject.api.jstesting.Coverage;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public final class CoverageProcessor {
    private static final Logger LOGGER = Logger.getLogger(CoverageProcessor.class.getName());
    private static volatile boolean debugCoverageWarningShown = false;
    private final Coverage coverage;
    private final File sourceDir;
    private final File logFile;

    public CoverageProcessor(Coverage coverage, File sourceDir, File logFile) {
        assert (coverage != null);
        assert (sourceDir.isDirectory()) : sourceDir;
        assert (logFile.isFile()) : logFile;
        this.coverage = coverage;
        this.sourceDir = sourceDir;
        this.logFile = logFile;
    }

    public static void warnDebugCoverage() {
        if (debugCoverageWarningShown) {
            return;
        }
        debugCoverageWarningShown = true;
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.CoverageProcessor_warn_debugCoverage()));
    }

    public void process() {
        BufferedReader reader;
        assert (this.coverage.isEnabled());
        assert (!EventQueue.isDispatchThread());
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.logFile), StandardCharsets.UTF_8));
        }
        catch (FileNotFoundException ex) {
            LOGGER.log(Level.WARNING, null, ex);
            return;
        }
        List<Coverage.File> files = CloverLogParser.parse(reader, this.sourceDir);
        if (files == null) {
            LOGGER.info("Parsed coverage data expected but some error occured");
            return;
        }
        this.coverage.setFiles(files);
    }
}

