/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.frame.FrameSlotTypeException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.instrumentation.EventContext;
import com.oracle.truffle.api.instrumentation.ExecutionEventNode;
import com.oracle.truffle.api.instrumentation.ExecutionEventNodeFactory;
import com.oracle.truffle.api.instrumentation.Instrumenter;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.HostException;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotImpl;
import java.lang.management.ManagementFactory;
import java.lang.ref.WeakReference;
import java.time.Duration;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.graalvm.polyglot.ResourceLimitEvent;

final class PolyglotLimits {
    final long statementLimit;
    final Predicate<org.graalvm.polyglot.Source> statementLimitSourcePredicate;
    final Duration timeLimit;
    final Duration timeAccuracy;
    final Consumer<ResourceLimitEvent> onEvent;
    static final Object CACHED_CONTEXT = new Object(){

        public String toString() {
            return "$$$cached_context$$$";
        }
    };

    PolyglotLimits(long statementLimit, Predicate<org.graalvm.polyglot.Source> statementLimitSourcePredicate, Duration timeLimit, Duration timeAccuracy, Consumer<ResourceLimitEvent> onEvent) {
        this.statementLimit = statementLimit;
        this.statementLimitSourcePredicate = statementLimitSourcePredicate;
        this.timeLimit = timeLimit;
        this.timeAccuracy = timeAccuracy;
        this.onEvent = onEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reset(PolyglotContextImpl context) {
        PolyglotContextImpl polyglotContextImpl = context;
        synchronized (polyglotContextImpl) {
            PolyglotLimits limits = context.config.limits;
            if (limits != null && limits.timeLimit != null) {
                context.resetTiming();
            }
            context.statementCounter = context.statementLimit;
            context.volatileStatementCounter.set(context.statementLimit);
        }
    }

    static final class EngineLimits {
        private static volatile ScheduledThreadPoolExecutor limitExecutor;
        private static volatile ThreadPoolExecutor cancelExecutor;
        private static final Predicate<org.graalvm.polyglot.Source> NO_PREDICATE;
        final PolyglotEngineImpl engine;
        @CompilerDirectives.CompilationFinal
        boolean timeLimitEnabled;
        @CompilerDirectives.CompilationFinal
        long statementLimit = -1L;
        @CompilerDirectives.CompilationFinal
        Assumption sameStatementLimit;
        @CompilerDirectives.CompilationFinal
        Predicate<org.graalvm.polyglot.Source> statementLimitSourcePredicate;
        EventBinding<?> statementLimitBinding;

        EngineLimits(PolyglotEngineImpl engine) {
            this.engine = engine;
        }

        void validate(PolyglotLimits limits) {
            Predicate<org.graalvm.polyglot.Source> newPredicate;
            Predicate<org.graalvm.polyglot.Source> predicate = newPredicate = limits != null ? limits.statementLimitSourcePredicate : null;
            if (newPredicate == null) {
                newPredicate = NO_PREDICATE;
            }
            if (this.statementLimitSourcePredicate != null && newPredicate != this.statementLimitSourcePredicate) {
                throw new IllegalArgumentException("Using multiple source predicates per engine is not supported. The same statement limit source predicate must be used for all polyglot contexts that are assigned to the same engine. Resolve this by using the same predicate instance when constructing the limits object with ResourceLimits.Builder.statementLimit(long, Predicate).");
            }
            if (limits != null && limits.timeLimit != null) {
                long time = -1L;
                UnsupportedOperationException cause = null;
                if (!TruffleOptions.AOT) {
                    try {
                        ManagementFactory.getThreadMXBean().setThreadCpuTimeEnabled(true);
                        time = ManagementFactory.getThreadMXBean().getCurrentThreadCpuTime();
                    }
                    catch (UnsupportedOperationException e) {
                        cause = e;
                    }
                }
                if (time == -1L) {
                    throw new UnsupportedOperationException("ThreadMXBean.getCurrentThreadCpuTime() is not supported or enabled by the host VM but required for time limits.", cause);
                }
            }
        }

        void initialize(PolyglotLimits limits, PolyglotContextImpl context) {
            assert (Thread.holdsLock(this.engine));
            Predicate<org.graalvm.polyglot.Source> newPredicate = limits.statementLimitSourcePredicate;
            if (newPredicate == null) {
                newPredicate = NO_PREDICATE;
            }
            if (this.statementLimitSourcePredicate == null) {
                this.statementLimitSourcePredicate = newPredicate;
            }
            assert (this.statementLimitSourcePredicate == newPredicate);
            if (limits.statementLimit != 0L) {
                Assumption sameLimit = this.sameStatementLimit;
                if (sameLimit != null && sameLimit.isValid() && limits.statementLimit != this.statementLimit) {
                    sameLimit.invalidate();
                } else if (sameLimit == null) {
                    this.sameStatementLimit = Truffle.getRuntime().createAssumption("Same statement limit.");
                    this.statementLimit = limits.statementLimit;
                }
                if (this.statementLimitBinding == null) {
                    Instrumenter instrumenter = (Instrumenter)EngineAccessor.INSTRUMENT.getEngineInstrumenter(this.engine.instrumentationHandler);
                    SourceSectionFilter.Builder filter = SourceSectionFilter.newBuilder().tagIs(StandardTags.StatementTag.class);
                    if (this.statementLimitSourcePredicate != null) {
                        filter.sourceIs(new SourceSectionFilter.SourcePredicate(){

                            @Override
                            public boolean test(Source s) {
                                try {
                                    return statementLimitSourcePredicate.test(engine.getImpl().getPolyglotSource(s));
                                }
                                catch (Throwable e) {
                                    throw new HostException(e);
                                }
                            }
                        });
                    }
                    this.statementLimitBinding = instrumenter.attachExecutionEventFactory(filter.build(), new ExecutionEventNodeFactory(){

                        @Override
                        public ExecutionEventNode create(EventContext eventContext) {
                            return new StatementIncrementNode(eventContext, this);
                        }
                    });
                }
            }
            if (limits.timeLimit != null) {
                this.engine.noThreadTimingNeeded.invalidate();
                long timeLimitMillis = limits.timeLimit.toMillis();
                assert (timeLimitMillis > 0L);
                TimeLimitChecker task = new TimeLimitChecker(context, this);
                long accuracy = Math.max(10L, limits.timeAccuracy.toMillis());
                EngineLimits.getLimitTimer().scheduleAtFixedRate(task, accuracy, accuracy, TimeUnit.MILLISECONDS);
            }
            PolyglotLimits.reset(context);
        }

        long getStatementLimit() {
            return this.statementLimit;
        }

        RuntimeException notifyEvent(PolyglotContextImpl context) {
            PolyglotLimits limits = context.config.limits;
            if (limits == null) {
                return null;
            }
            Consumer<ResourceLimitEvent> onEvent = limits.onEvent;
            if (onEvent == null) {
                return null;
            }
            try {
                onEvent.accept(this.engine.getImpl().getAPIAccess().newResourceLimitsEvent((Object)context.creatorApi));
            }
            catch (Throwable t) {
                return PolyglotImpl.wrapHostException(context, t);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static ExecutorService getCancelExecutor() {
            ThreadPoolExecutor executor = cancelExecutor;
            if (executor != null) return executor;
            Class<EngineLimits> clazz = EngineLimits.class;
            synchronized (EngineLimits.class) {
                executor = cancelExecutor;
                if (executor != null) return executor;
                cancelExecutor = executor = (ThreadPoolExecutor)Executors.newCachedThreadPool(new HighPriorityThreadFactory("Polyglot Cancel Thread"));
                executor.setKeepAliveTime(1L, TimeUnit.SECONDS);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return executor;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static ScheduledExecutorService getLimitTimer() {
            ScheduledThreadPoolExecutor executor = limitExecutor;
            if (executor != null) return executor;
            Class<EngineLimits> clazz = EngineLimits.class;
            synchronized (EngineLimits.class) {
                executor = limitExecutor;
                if (executor != null) return executor;
                executor = new ScheduledThreadPoolExecutor(0, new HighPriorityThreadFactory("Polyglot Limit Timer"));
                executor.setKeepAliveTime(1L, TimeUnit.SECONDS);
                limitExecutor = executor;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return executor;
            }
        }

        static {
            NO_PREDICATE = new Predicate<org.graalvm.polyglot.Source>(){

                @Override
                public boolean test(org.graalvm.polyglot.Source t) {
                    return true;
                }
            };
        }

        static final class HighPriorityThreadFactory
        implements ThreadFactory {
            private final AtomicLong threadCounter = new AtomicLong();
            private final String baseName;

            HighPriorityThreadFactory(String baseName) {
                this.baseName = baseName;
            }

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName(this.baseName + "-" + this.threadCounter.incrementAndGet());
                t.setPriority(10);
                return t;
            }
        }
    }

    static final class TimeLimitChecker
    extends TimerTask {
        private final WeakReference<PolyglotContextImpl> context;
        private final long timeLimitNS;
        private final EngineLimits limits;
        private FutureTask<?> cancelResult;

        TimeLimitChecker(PolyglotContextImpl context, EngineLimits limits) {
            this.context = new WeakReference<PolyglotContextImpl>(context);
            this.timeLimitNS = context.config.limits.timeLimit.toNanos();
            this.limits = limits;
        }

        @Override
        public void run() {
            String message;
            boolean invalidated;
            final PolyglotContextImpl c = (PolyglotContextImpl)this.context.get();
            if (this.cancelResult != null) {
                if (this.cancelResult.isDone()) {
                    this.cancel();
                    try {
                        this.cancelResult.get();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return;
            }
            if (c == null || c.closed) {
                this.cancel();
                return;
            }
            long timeActiveNS = c.getTimeActive();
            if (timeActiveNS > this.timeLimitNS && !c.invalid && (invalidated = c.invalidate(message = String.format("Time resource limit of %sms exceeded. Time executed %sms.", c.config.limits.timeLimit.toMillis(), Duration.ofNanos(timeActiveNS).toMillis())))) {
                this.limits.notifyEvent(c);
                this.cancelResult = (FutureTask)EngineLimits.getCancelExecutor().submit(new Runnable(){

                    @Override
                    public void run() {
                        if (!c.closed) {
                            c.close(c.creatorApi, true);
                        }
                    }
                });
            }
        }
    }

    static final class StatementIncrementNode
    extends ExecutionEventNode {
        final EngineLimits limits;
        final EventContext eventContext;
        final PolyglotEngineImpl engine;
        final FrameSlot readContext;
        final ConditionProfile needsLookup = ConditionProfile.createBinaryProfile();
        final FrameDescriptor descriptor;
        @CompilerDirectives.CompilationFinal
        private boolean seenInnerContext;

        StatementIncrementNode(EventContext context, EngineLimits limits) {
            this.limits = limits;
            this.eventContext = context;
            this.engine = limits.engine;
            if (!this.engine.singleThreadPerContext.isValid() || !this.engine.singleContext.isValid()) {
                this.descriptor = context.getInstrumentedNode().getRootNode().getFrameDescriptor();
                this.readContext = this.descriptor.findOrAddFrameSlot(CACHED_CONTEXT, FrameSlotKind.Object);
            } else {
                this.readContext = null;
                this.descriptor = null;
            }
        }

        @Override
        protected void onEnter(VirtualFrame frame) {
            PolyglotContextImpl currentContext;
            if (this.readContext == null || frame.getFrameDescriptor() != this.descriptor) {
                currentContext = this.getLimitContext();
            } else {
                try {
                    Object readValue = frame.getObject(this.readContext);
                    if (this.needsLookup.profile(readValue == this.descriptor.getDefaultValue())) {
                        currentContext = this.getLimitContext();
                        frame.setObject(this.readContext, currentContext);
                    } else {
                        currentContext = (PolyglotContextImpl)readValue;
                    }
                }
                catch (FrameSlotTypeException e) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    currentContext = this.getLimitContext();
                    frame.setObject(this.readContext, currentContext);
                }
            }
            long count = this.engine.singleThreadPerContext.isValid() ? --currentContext.statementCounter : currentContext.volatileStatementCounter.decrementAndGet();
            if (count < 0L) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.notifyStatementLimitReached(currentContext, currentContext.statementLimit - count, currentContext.statementLimit);
            }
        }

        private PolyglotContextImpl getLimitContext() {
            PolyglotContextImpl context = PolyglotContextImpl.currentEntered(this.engine);
            if (this.engine.noInnerContexts.isValid() || context.parent == null) {
                return context;
            }
            if (!this.seenInnerContext) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.seenInnerContext = true;
            }
            while (context.parent != null) {
                context = context.parent;
            }
            return context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyStatementLimitReached(PolyglotContextImpl context, long actualCount, long limit) {
            String message;
            boolean invalidated;
            boolean limitReached = false;
            PolyglotContextImpl polyglotContextImpl = context;
            synchronized (polyglotContextImpl) {
                if (this.limits.engine.singleThreadPerContext.isValid()) {
                    if (context.statementCounter < 0L) {
                        context.statementCounter = limit;
                        limitReached = true;
                    }
                } else if (context.volatileStatementCounter.get() < 0L) {
                    context.volatileStatementCounter.set(limit);
                    limitReached = true;
                }
            }
            if (limitReached && (invalidated = context.invalidate(message = String.format("Statement count limit of %s exceeded. Statements executed %s.", limit, actualCount)))) {
                context.close(context.creatorApi, true);
                RuntimeException e = this.limits.notifyEvent(context);
                if (e != null) {
                    throw e;
                }
                throw new PolyglotEngineImpl.CancelExecution(this.eventContext, message);
            }
        }
    }
}

