/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.dialogs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Hashtable;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.web.jsf.JSFConfigDataObject;
import org.netbeans.modules.web.jsf.JSFConfigUtilities;
import org.netbeans.modules.web.jsf.api.ConfigurationUtils;
import org.netbeans.modules.web.jsf.api.facesmodel.FacesConfig;
import org.netbeans.modules.web.jsf.api.facesmodel.NavigationRule;
import org.netbeans.modules.web.jsf.dialogs.AddManagedBeanDialog;
import org.netbeans.modules.web.jsf.dialogs.BrowseFolders;
import org.netbeans.modules.web.jsf.dialogs.ValidatingPanel;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class AddNavigationRuleDialog
extends JPanel
implements ValidatingPanel {
    private JSFConfigDataObject config;
    public final String NO_FROM_VIEW_DEFINED = "nofromviewdefined";
    private Hashtable existingRules = null;
    private JButton jButtonBrowse;
    private JLabel jLabelDesc;
    private JLabel jLabelFromView;
    private JScrollPane jScrollPaneDesc;
    private JTextArea jTextAreaDesc;
    private JTextField jTextFieldFromView;

    public AddNavigationRuleDialog(JSFConfigDataObject config) {
        this.initComponents();
        this.config = config;
    }

    @Override
    public JTextComponent[] getDocumentChangeComponents() {
        return new JTextComponent[]{this.jTextFieldFromView};
    }

    @Override
    public AbstractButton[] getStateChangeComponents() {
        return new AbstractButton[0];
    }

    @Override
    public String validatePanel() {
        String fromView;
        String message = null;
        if (this.existingRules == null) {
            this.existingRules = new Hashtable();
            FacesConfig facesConfig = ConfigurationUtils.getConfigModel(this.config.getPrimaryFile(), true).getRootComponent();
            for (NavigationRule rule : facesConfig.getNavigationRules()) {
                if (rule.getFromViewId() != null) {
                    this.existingRules.put(rule.getFromViewId(), "");
                    continue;
                }
                this.existingRules.put("nofromviewdefined", "");
            }
        }
        if ((fromView = this.getFromView()) == null || fromView.length() == 0) {
            fromView = "nofromviewdefined";
        }
        if (this.existingRules.get(fromView) != null) {
            message = fromView.equals("nofromviewdefined") ? NbBundle.getMessage(AddManagedBeanDialog.class, (String)"MSG_AddNavigationRule_RuleExistWithNoFromView") : NbBundle.getMessage(AddManagedBeanDialog.class, (String)"MSG_AddNavigationRule_RuleExist");
        }
        return message;
    }

    private void initComponents() {
        this.jLabelFromView = new JLabel();
        this.jTextFieldFromView = new JTextField();
        this.jButtonBrowse = new JButton();
        this.jLabelDesc = new JLabel();
        this.jScrollPaneDesc = new JScrollPane();
        this.jTextAreaDesc = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/dialogs/Bundle").getString("ACSD_AddNavigationRuleDialog"));
        this.jLabelFromView.setDisplayedMnemonic(NbBundle.getMessage(AddNavigationRuleDialog.class, (String)"MNE_FromView").charAt(0));
        this.jLabelFromView.setLabelFor(this.jTextFieldFromView);
        this.jLabelFromView.setText(NbBundle.getMessage(AddNavigationRuleDialog.class, (String)"LBL_FromView"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 5, 12);
        this.add((Component)this.jLabelFromView, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 0, 5, 0);
        this.add((Component)this.jTextFieldFromView, gridBagConstraints);
        this.jTextFieldFromView.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/dialogs/Bundle").getString("ACSD_RuleFromFiew"));
        this.jButtonBrowse.setMnemonic(NbBundle.getMessage(AddNavigationRuleDialog.class, (String)"MNE_Browse").charAt(0));
        this.jButtonBrowse.setText(NbBundle.getMessage(AddNavigationRuleDialog.class, (String)"LBL_Browse"));
        this.jButtonBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddNavigationRuleDialog.this.jButtonBrowseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(12, 12, 5, 11);
        this.add((Component)this.jButtonBrowse, gridBagConstraints);
        this.jButtonBrowse.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/dialogs/Bundle").getString("ACSD_RuleBrowse"));
        this.jLabelDesc.setDisplayedMnemonic(NbBundle.getMessage(AddNavigationRuleDialog.class, (String)"MNE_BeanDescription").charAt(0));
        this.jLabelDesc.setLabelFor(this.jTextAreaDesc);
        this.jLabelDesc.setText(NbBundle.getMessage(AddNavigationRuleDialog.class, (String)"LBL_RuleDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 0, 12);
        this.add((Component)this.jLabelDesc, gridBagConstraints);
        this.jTextAreaDesc.setColumns(20);
        this.jTextAreaDesc.setRows(5);
        this.jScrollPaneDesc.setViewportView(this.jTextAreaDesc);
        this.jTextAreaDesc.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/dialogs/Bundle").getString("ACSD_RuleDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.add((Component)this.jScrollPaneDesc, gridBagConstraints);
    }

    private void jButtonBrowseActionPerformed(ActionEvent evt) {
        try {
            SourceGroup[] groups = JSFConfigUtilities.getDocBaseGroups(this.config.getPrimaryFile());
            FileObject fo = BrowseFolders.showDialog(groups);
            if (fo != null) {
                String res = "/" + JSFConfigUtilities.getResourcePath(groups, fo, '/', true);
                this.jTextFieldFromView.setText(res);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public String getFromView() {
        return this.jTextFieldFromView.getText().trim();
    }

    public String getDescription() {
        return this.jTextAreaDesc.getText();
    }
}

