/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.options;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.netbeans.api.io.InputOutput;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.lsp.client.options.MimeTypeInfo;
import org.netbeans.modules.lsp.client.options.ServerRestarter;
import org.netbeans.modules.lsp.client.spi.LanguageServerProvider;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class GenericLanguageServer
implements LanguageServerProvider {
    private final RequestProcessor WORKER = new RequestProcessor(GenericLanguageServer.class.getName(), Integer.MAX_VALUE, false, false);
    private static final long STARTUP_DELAY = 10000L;

    @Override
    public LanguageServerProvider.LanguageServerDescription startServer(Lookup lookup) {
        ServerRestarter restarter;
        MimeTypeInfo mti = (MimeTypeInfo)lookup.lookup(MimeTypeInfo.class);
        if (mti == null) {
            return null;
        }
        Project prj = (Project)lookup.lookup(Project.class);
        final FileObject server = FileUtil.getConfigFile((String)("Editors/" + mti.mimeType + "/org-netbeans-modules-lsp-client-options-GenericLanguageServer.instance"));
        String[] command = (String[])server.getAttribute("command");
        String name = (String)server.getAttribute("name");
        if (name == null) {
            name = command[0];
        }
        if ((restarter = (ServerRestarter)lookup.lookup(ServerRestarter.class)) != null) {
            server.addFileChangeListener(new FileChangeListener(){

                public void fileFolderCreated(FileEvent fe) {
                    this.update();
                }

                public void fileDataCreated(FileEvent fe) {
                    this.update();
                }

                public void fileChanged(FileEvent fe) {
                    this.update();
                }

                public void fileDeleted(FileEvent fe) {
                    this.update();
                }

                public void fileRenamed(FileRenameEvent fe) {
                    this.update();
                }

                public void fileAttributeChanged(FileAttributeEvent fe) {
                    this.update();
                }

                private void update() {
                    restarter.restart();
                    server.removeFileChangeListener((FileChangeListener)this);
                }
            });
        }
        try {
            InputOutput io = InputOutput.get((String)("Language Server for " + name + " for project " + (prj != null ? ProjectUtils.getInformation((Project)prj).getDisplayName() : "<unknown>")), (boolean)false);
            io.reset();
            Process process = new ProcessBuilder(command).start();
            this.WORKER.post(() -> {
                long start = System.currentTimeMillis();
                try (InputStreamReader r = new InputStreamReader(process.getErrorStream());){
                    int read;
                    while ((read = ((Reader)r).read()) != -1) {
                        io.getErr().write("" + (char)read);
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                finally {
                    io.getErr().close();
                    io.getOut().close();
                    try {
                        io.getIn().close();
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                long end = System.currentTimeMillis();
                if (!(process.isAlive() || process.exitValue() == 0 && end - start >= 10000L)) {
                    io.show();
                }
            });
            return LanguageServerProvider.LanguageServerDescription.create(process.getInputStream(), process.getOutputStream(), process);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }
}

