/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.AWTEventListener;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.Utilities;
import org.openide.util.datatransfer.ExClipboard;

public final class NbClipboard
extends ExClipboard
implements LookupListener,
FlavorListener,
AWTEventListener {
    private static final Logger log = Logger.getLogger(NbClipboard.class.getName());
    private ThreadLocal<Boolean> FIRING = new ThreadLocal();
    private Clipboard systemClipboard;
    private ExClipboard.Convertor[] convertors;
    private Lookup.Result<ExClipboard.Convertor> result;
    final boolean slowSystemClipboard;
    private Transferable last;
    private long lastWindowActivated;
    private long lastWindowDeactivated;
    private Reference<Object> lastWindowDeactivatedSource = new WeakReference<Object>(null);
    private volatile Task setContentsTask = Task.EMPTY;
    private volatile Task getContentsTask = Task.EMPTY;
    private boolean anyWindowIsActivated = true;
    private static final RequestProcessor RP = new RequestProcessor("System clipboard synchronizer");

    public NbClipboard() {
        this(Toolkit.getDefaultToolkit().getSystemClipboard());
    }

    NbClipboard(Clipboard systemClipboard) {
        super("NBClipboard");
        this.systemClipboard = systemClipboard;
        this.result = Lookup.getDefault().lookupResult(ExClipboard.Convertor.class);
        this.result.addLookupListener((LookupListener)this);
        systemClipboard.addFlavorListener(this);
        this.resultChanged(null);
        this.slowSystemClipboard = System.getProperty("netbeans.slow.system.clipboard.hack") != null ? Boolean.getBoolean("netbeans.slow.system.clipboard.hack") : !Utilities.isMac();
        if (System.getProperty("sun.awt.datatransfer.timeout") == null) {
            System.setProperty("sun.awt.datatransfer.timeout", "1000");
        }
        if (this.slowSystemClipboard) {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 64L);
        }
    }

    protected synchronized ExClipboard.Convertor[] getConvertors() {
        return this.convertors;
    }

    public synchronized void resultChanged(LookupEvent ev) {
        Collection c = this.result.allInstances();
        ExClipboard.Convertor[] temp = new ExClipboard.Convertor[c.size()];
        this.convertors = c.toArray(temp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContents(Transferable contents, ClipboardOwner owner) {
        NbClipboard nbClipboard = this;
        synchronized (nbClipboard) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "setContents called with: ");
                this.logFlavors(contents, Level.FINER, log.isLoggable(Level.FINEST));
            }
            contents = this.convert(contents);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "After conversion:");
                this.logFlavors(contents, Level.FINER, log.isLoggable(Level.FINEST));
            }
            if (this.slowSystemClipboard) {
                if (this.contents != null) {
                    NbClipboard.transferableOwnershipLost((Transferable)this.contents);
                }
                final ClipboardOwner oldOwner = this.owner;
                final Transferable oldContents = this.contents;
                this.owner = owner;
                this.contents = contents;
                if (oldOwner != null && oldOwner != owner) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            oldOwner.lostOwnership((Clipboard)((Object)NbClipboard.this), oldContents);
                        }
                    });
                }
            } else {
                if (this.last != null) {
                    NbClipboard.transferableOwnershipLost((Transferable)this.last);
                }
                this.last = contents;
            }
            this.scheduleSetContents(contents, owner, 0);
        }
        this.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transferable getContents(Object requestor) {
        try {
            Transferable prev;
            log.log(Level.FINE, "getContents, slowSystemClipboard: {0}", this.slowSystemClipboard);
            if (this.slowSystemClipboard && !RP.isRequestProcessorThread()) {
                boolean ok;
                long curr = System.currentTimeMillis();
                int waitTime = Integer.getInteger("sun.awt.datatransfer.timeout", 1000);
                if (waitTime > 0 && !Boolean.TRUE.equals(this.FIRING.get()) && !(ok = this.scheduleGetFromSystemClipboard(false).waitFinished((long)waitTime))) {
                    log.log(Level.FINE, "Time out waiting for sync with system clipboard for {0} ms", waitTime);
                }
                prev = super.getContents(requestor);
            } else {
                this.setContentsTask.waitFinished();
                this.getContentsTask.waitFinished();
                log.log(Level.FINE, "after syncTask clipboard wait");
                try {
                    prev = this.systemClipboard.getContents(requestor);
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable ex) {
                    log.log(Level.INFO, "System clipboard not available.", ex);
                    prev = null;
                }
            }
            NbClipboard ex = this;
            synchronized (ex) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "getContents by {0}", requestor);
                    this.logFlavors(prev, Level.FINE, log.isLoggable(Level.FINEST));
                }
                if (prev == null) {
                    return null;
                }
                Transferable res = this.convert(prev);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "getContents by {0}", requestor);
                    this.logFlavors(res, Level.FINE, log.isLoggable(Level.FINEST));
                    res = new LoggableTransferable(res);
                }
                return res;
            }
        }
        catch (ThreadDeath ex) {
            throw ex;
        }
        catch (InterruptedException ex) {
            Logger.getLogger(NbClipboard.class.getName()).log(Level.WARNING, null, ex);
            return null;
        }
        catch (Throwable ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public FlavorListener[] getFlavorListeners() {
        return new FlavorListener[0];
    }

    public synchronized void addFlavorListener(FlavorListener listener) {
        Boolean prev = this.FIRING.get();
        try {
            this.FIRING.set(true);
            super.addFlavorListener(listener);
        }
        finally {
            this.FIRING.set(prev);
        }
    }

    private void scheduleSetContents(Transferable cnts, ClipboardOwner ownr, int delay) {
        this.setContentsTask = RP.post((Runnable)new SetContents(cnts, ownr), delay);
    }

    private Task scheduleGetFromSystemClipboard(boolean notify) {
        this.getContentsTask = RP.post((Runnable)new GetContents(notify));
        return this.getContentsTask;
    }

    final void waitFinished() {
        this.setContentsTask.waitFinished();
        this.getContentsTask.waitFinished();
    }

    final void activateWindowHack(boolean reschedule) {
        this.lastWindowActivated = System.currentTimeMillis();
        if (reschedule) {
            this.scheduleGetFromSystemClipboard(true);
        }
    }

    private void logFlavors(Transferable trans, Level level, boolean content) {
        if (trans == null) {
            log.log(level, "  no clipboard contents");
        } else if (content) {
            DataFlavor[] arr = trans.getTransferDataFlavors();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < arr.length; ++i) {
                sb.append("  ").append(i).append(" = ").append(arr[i]);
                try {
                    sb.append(" contains: ").append(trans.getTransferData(arr[i]));
                }
                catch (UnsupportedFlavorException ex) {
                    log.log(level, "Can't convert to " + arr[i], ex);
                }
                catch (IOException ex) {
                    log.log(level, "Can't convert to " + arr[i], ex);
                }
                sb.append("\n");
            }
            log.log(level, sb.toString());
        } else {
            log.log(level, " clipboard contains data");
        }
    }

    @Override
    public void flavorsChanged(FlavorEvent e) {
        if (!this.anyWindowIsActivated) {
            return;
        }
        this.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void fireChange() {
        Boolean prev = this.FIRING.get();
        try {
            this.FIRING.set(true);
            FlavorEvent e = new FlavorEvent((Clipboard)((Object)this));
            this.fireClipboardChange();
            for (FlavorListener l : super.getFlavorListeners()) {
                l.flavorsChanged(e);
            }
        }
        finally {
            this.FIRING.set(prev);
        }
    }

    @Override
    public void eventDispatched(AWTEvent ev) {
        if (!(ev instanceof WindowEvent)) {
            return;
        }
        if (ev.getID() == 206) {
            this.lastWindowDeactivated = System.currentTimeMillis();
            this.lastWindowDeactivatedSource = new WeakReference<Object>(ev.getSource());
            this.anyWindowIsActivated = false;
            if (Utilities.isWindows()) {
                this.systemClipboard.removeFlavorListener(this);
            }
        }
        if (ev.getID() == 205) {
            if (Utilities.isWindows()) {
                this.systemClipboard.addFlavorListener(this);
            }
            this.anyWindowIsActivated = true;
            if (System.currentTimeMillis() - this.lastWindowDeactivated < 100L && ev.getSource() == this.lastWindowDeactivatedSource.get()) {
                this.activateWindowHack(false);
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "window activated scheduling update");
            }
            this.scheduleGetFromSystemClipboard(true);
        }
    }

    private synchronized void superSetContents(Transferable t, ClipboardOwner o) {
        if (this.contents != null) {
            NbClipboard.transferableOwnershipLost((Transferable)this.contents);
        }
        final ClipboardOwner oldOwner = this.owner;
        final Transferable oldContents = this.contents;
        this.owner = o;
        this.contents = t;
        if (oldOwner != null && oldOwner != this.owner) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    oldOwner.lostOwnership((Clipboard)((Object)NbClipboard.this), oldContents);
                }
            });
        }
    }

    private final class SetContents
    implements Runnable {
        private final Transferable cnts;
        private final ClipboardOwner ownr;

        SetContents(Transferable cnts, ClipboardOwner ownr) {
            this.cnts = cnts;
            this.ownr = ownr;
        }

        @Override
        public void run() {
            try {
                NbClipboard.this.systemClipboard.setContents(this.cnts, this.ownr);
            }
            catch (IllegalStateException e) {
                log.log(Level.FINE, "systemClipboard not available", e);
                NbClipboard.this.scheduleSetContents(this.cnts, this.ownr, 100);
                return;
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "systemClipboard updated:");
                NbClipboard.this.logFlavors(this.cnts, Level.FINE, log.isLoggable(Level.FINEST));
            }
        }
    }

    private final class GetContents
    implements Runnable {
        private final boolean notify;

        public GetContents(boolean notify) {
            this.notify = notify;
        }

        @Override
        public void run() {
            log.fine("Running update");
            try {
                Transferable transferable = NbClipboard.this.systemClipboard.getContents(this);
                NbClipboard.this.superSetContents(transferable, null);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "internal clipboard updated:");
                    NbClipboard.this.logFlavors(transferable, Level.FINE, log.isLoggable(Level.FINEST));
                }
                if (this.notify) {
                    NbClipboard.this.fireChange();
                }
            }
            catch (ThreadDeath ex) {
                throw ex;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private final class LoggableTransferable
    implements Transferable {
        private Transferable delegate;

        public LoggableTransferable(Transferable delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            log.log(Level.FINE, "Request for flavor: " + flavor);
            Object res = this.delegate.getTransferData(flavor);
            log.log(Level.FINE, "Returning value: " + res);
            return res;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return this.delegate.getTransferDataFlavors();
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            boolean res = this.delegate.isDataFlavorSupported(flavor);
            log.log(Level.FINE, "isDataFlavorSupported: " + flavor + " result: " + res);
            return res;
        }
    }
}

