/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.properties;

import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.modules.subversion.ui.properties.PropertiesTableModel;
import org.netbeans.modules.subversion.ui.properties.SvnPropertiesNode;
import org.netbeans.modules.versioning.util.SortedTable;
import org.netbeans.modules.versioning.util.TableSorter;
import org.openide.util.NbBundle;

public class PropertiesTable
implements AncestorListener,
TableModelListener {
    static final String[] PROPERTIES_COLUMNS = new String[]{"name", "value"};
    private PropertiesTableModel tableModel;
    private JTable table;
    private TableSorter sorter;
    private JComponent component;
    private String[] columns;
    private String[] sortByColumns;

    public PropertiesTable(JLabel label, String[] columns, String[] sortByColumns) {
        this.init(label, columns, null);
        this.sortByColumns = sortByColumns;
        this.setSortingStatus();
    }

    public PropertiesTable(JLabel label, String[] columns, TableSorter sorter) {
        this.init(label, columns, sorter);
    }

    private void init(JLabel label, String[] columns, TableSorter sorter) {
        this.tableModel = new PropertiesTableModel(columns);
        this.tableModel.addTableModelListener(this);
        if (sorter == null) {
            sorter = new TableSorter((TableModel)this.tableModel);
        }
        this.sorter = sorter;
        this.table = new SortedTable(this.sorter);
        this.table.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PropertiesTable.class, (String)"tableProperties.AccessibleContext.accessibleName"));
        this.table.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PropertiesTable.class, (String)"tableProperties.AccessibleContext.accessibleDescription"));
        this.table.getTableHeader().setReorderingAllowed(false);
        PropertiesTableCellRenderer cellRenderer = new PropertiesTableCellRenderer();
        this.table.setDefaultRenderer(String.class, cellRenderer);
        this.table.setRowHeight(Math.max(this.table.getRowHeight(), cellRenderer.getTableCellRendererComponent((JTable)this.table, (Object)"abc", (boolean)true, (boolean)true, (int)0, (int)0).getPreferredSize().height + 2));
        this.table.getTableHeader().setReorderingAllowed(true);
        this.table.setRowHeight(this.table.getRowHeight());
        this.table.addAncestorListener(this);
        this.component = new JScrollPane(this.table, 22, 30);
        this.component.setPreferredSize(new Dimension(340, 150));
        this.table.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PropertiesTable.class, (String)"ACSD_PropertiesTable"));
        label.setLabelFor(this.table);
        this.setColumns(columns);
    }

    public void setColumns(String[] clmns) {
        if (Arrays.equals(this.columns, clmns)) {
            return;
        }
        this.columns = clmns;
        this.tableModel.setColumns(clmns);
        this.setDefaultColumnSize();
    }

    public JTable getTable() {
        return this.table;
    }

    private void setDefaultColumnSize() {
        int width = this.table.getWidth();
        TableColumnModel columnModel = this.table.getColumnModel();
        if (this.columns == null || columnModel == null) {
            return;
        }
        if (columnModel.getColumnCount() != this.columns.length) {
            return;
        }
        for (int i = 0; i < this.columns.length; ++i) {
            String col = this.columns[i];
            this.sorter.setColumnComparator(i, null);
            if (col.equals("name")) {
                columnModel.getColumn(i).setPreferredWidth(width * 20 / 100);
                continue;
            }
            if (!col.equals("value")) continue;
            columnModel.getColumn(i).setPreferredWidth(width * 40 / 100);
        }
    }

    private void setSortingStatus() {
        block0: for (int i = 0; i < this.sortByColumns.length; ++i) {
            String sortByColumn = this.sortByColumns[i];
            for (int j = 0; j < this.columns.length; ++j) {
                String column = this.columns[j];
                if (!column.equals(sortByColumn)) continue;
                this.sorter.setSortingStatus(j, column.equals(sortByColumn) ? 1 : 0);
                continue block0;
            }
        }
    }

    TableModel getTableModel() {
        return this.tableModel;
    }

    void dataChanged() {
        int idx = this.table.getSelectedRow();
        this.tableModel.fireTableDataChanged();
        if (idx != -1) {
            this.table.getSelectionModel().addSelectionInterval(idx, idx);
        }
    }

    public int getModelIndex(int viewIndex) {
        return this.sorter.modelIndex(viewIndex);
    }

    public int[] getSelectedItems() {
        return this.table.getSelectedRows();
    }

    public SvnPropertiesNode[] getNodes() {
        return this.tableModel.getNodes();
    }

    public void setNodes(SvnPropertiesNode[] nodes) {
        this.tableModel.setNodes(nodes);
    }

    JComponent getComponent() {
        return this.component;
    }

    @Override
    public void ancestorAdded(AncestorEvent arg0) {
        this.setDefaultColumnSize();
    }

    @Override
    public void ancestorRemoved(AncestorEvent arg0) {
    }

    @Override
    public void ancestorMoved(AncestorEvent arg0) {
    }

    @Override
    public void tableChanged(TableModelEvent event) {
        this.table.repaint();
    }

    public class PropertiesTableCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int columnIndex) {
            int newLinePos;
            if (value instanceof String && (newLinePos = ((String)value).indexOf("\n")) > -1) {
                value = ((String)value).substring(0, newLinePos) + "...";
            }
            Component renderer = super.getTableCellRendererComponent(table, value, hasFocus, hasFocus, rowIndex, columnIndex);
            if (rowIndex < PropertiesTable.this.tableModel.getRowCount() && renderer instanceof JComponent) {
                String strValue = PropertiesTable.this.tableModel.getNode(PropertiesTable.this.sorter.modelIndex(rowIndex)).getValue();
                ((JComponent)renderer).setToolTipText(strValue.replace("\n", " "));
            } else if (value != null) {
                this.setToolTipText(value.toString());
            }
            return renderer;
        }
    }
}

