/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.impl.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.beans.CdiUtil;
import org.netbeans.modules.web.beans.api.model.BeanArchiveType;
import org.netbeans.modules.web.beans.api.model.BeansModel;
import org.netbeans.modules.web.beans.api.model.ModelUnit;
import org.netbeans.modules.web.beans.xml.Alternatives;
import org.netbeans.modules.web.beans.xml.BeanClass;
import org.netbeans.modules.web.beans.xml.BeanClassContainer;
import org.netbeans.modules.web.beans.xml.Beans;
import org.netbeans.modules.web.beans.xml.BeansAttributes;
import org.netbeans.modules.web.beans.xml.Decorators;
import org.netbeans.modules.web.beans.xml.Interceptors;
import org.netbeans.modules.web.beans.xml.Stereotype;
import org.netbeans.modules.web.beans.xml.WebBeansComponent;
import org.netbeans.modules.web.beans.xml.WebBeansModel;
import org.netbeans.modules.web.beans.xml.WebBeansModelFactory;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;

public class BeansModelImpl
implements BeansModel {
    private static final String META_INF = "META-INF";
    private static final String BEANS_XML = "beans.xml";
    private static final String WEB_INF = "WEB-INF";
    private BeanArchiveType beanArchType = null;
    private Boolean isCdi11OrLater = null;
    private ModelUnit myUnit;
    private Object myLock;
    private List<WebBeansModel> myModels;
    private Map<FileObject, List<WebBeansModel>> myCompileRootToModel = new HashMap<FileObject, List<WebBeansModel>>();
    private FileChangeListener myListener;
    private BeanArchiveType beanArchiveType;

    public BeansModelImpl(ModelUnit unit) {
        this.myUnit = unit;
        this.myLock = new Object();
        this.registerChangeListeners();
        this.initModels();
    }

    @Override
    public Set<String> getAlternativeClasses() {
        HashSet<String> result = new HashSet<String>();
        for (WebBeansModel model : this.getModels()) {
            Beans beans = model.getBeans();
            if (beans == null) continue;
            List alternatives = beans.getChildren(Alternatives.class);
            for (Alternatives alternative : alternatives) {
                List children = alternative.getChildren(BeanClass.class);
                for (BeanClass beanClass : children) {
                    result.add(beanClass.getBeanClass());
                }
            }
        }
        return result;
    }

    @Override
    public Set<String> getAlternativeStereotypes() {
        HashSet<String> result = new HashSet<String>();
        for (WebBeansModel model : this.getModels()) {
            Beans beans = model.getBeans();
            if (beans == null) continue;
            List alternatives = beans.getChildren(Alternatives.class);
            for (Alternatives alternative : alternatives) {
                List children = alternative.getChildren(Stereotype.class);
                for (Stereotype stereotype : children) {
                    result.add(stereotype.getStereotype());
                }
            }
        }
        return result;
    }

    @Override
    public LinkedHashSet<String> getDecoratorClasses() {
        return this.getBeanClasses(Decorators.class);
    }

    @Override
    public LinkedHashSet<String> getInterceptorClasses() {
        return this.getBeanClasses(Interceptors.class);
    }

    public LinkedHashSet<String> getBeanClasses(Class<? extends BeanClassContainer> clazz) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (WebBeansModel model : this.getModels()) {
            Beans beans = model.getBeans();
            if (beans == null) continue;
            List children = beans.getChildren(clazz);
            for (BeanClassContainer container : children) {
                List<BeanClass> beansClasses = container.getBeansClasses();
                for (BeanClass beanClass : beansClasses) {
                    result.add(beanClass.getBeanClass());
                }
            }
        }
        return result;
    }

    @Override
    public BeanArchiveType getBeanArchiveType() {
        if (this.beanArchType == null) {
            CdiUtil lookup;
            Project project = this.getUnit().getProject();
            this.beanArchType = project != null ? ((lookup = (CdiUtil)project.getLookup().lookup(CdiUtil.class)) == null ? (!CdiUtil.isCdiEnabled(project) ? BeanArchiveType.NONE : (!CdiUtil.isCdi11OrLater(project) ? BeanArchiveType.EXPLICIT : this.getBeansArchiveType())) : (!lookup.isCdiEnabled() ? BeanArchiveType.NONE : (!lookup.isCdi11OrLater() ? BeanArchiveType.EXPLICIT : this.getBeansArchiveType()))) : BeanArchiveType.EXPLICIT;
        }
        return this.beanArchType;
    }

    @Override
    public boolean isCdi11OrLater() {
        if (this.isCdi11OrLater == null) {
            CdiUtil lookup;
            Project project = this.getUnit().getProject();
            this.isCdi11OrLater = project != null ? ((lookup = (CdiUtil)project.getLookup().lookup(CdiUtil.class)) == null ? Boolean.valueOf(CdiUtil.isCdiEnabled(project) && CdiUtil.isCdi11OrLater(project)) : Boolean.valueOf(lookup.isCdiEnabled() && lookup.isCdi11OrLater())) : Boolean.valueOf(false);
        }
        return this.isCdi11OrLater;
    }

    private void registerChangeListeners() {
        ClassPath compile = this.getUnit().getCompilePath();
        compile.addPropertyChangeListener(new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent arg0) {
                Object object = BeansModelImpl.this.myLock;
                synchronized (object) {
                    if (BeansModelImpl.this.myModels == null) {
                        return;
                    }
                    FileObject[] roots = BeansModelImpl.this.getUnit().getCompilePath().getRoots();
                    HashSet<FileObject> rootsSet = new HashSet<FileObject>(Arrays.asList(roots));
                    HashSet oldRoots = new HashSet(BeansModelImpl.this.myCompileRootToModel.keySet());
                    HashSet<FileObject> intersection = new HashSet<FileObject>(rootsSet);
                    intersection.retainAll(oldRoots);
                    oldRoots.removeAll(rootsSet);
                    for (FileObject fileObject : oldRoots) {
                        List remove = (List)BeansModelImpl.this.myCompileRootToModel.remove(fileObject);
                        BeansModelImpl.this.myModels.removeAll(remove);
                    }
                    rootsSet.removeAll(intersection);
                    for (FileObject fileObject : rootsSet) {
                        BeansModelImpl.this.addCompileModels(fileObject, BeansModelImpl.this.myModels);
                    }
                }
            }
        });
        this.myListener = new FileChangeListener(){

            public void fileAttributeChanged(FileAttributeEvent arg0) {
            }

            public void fileChanged(FileEvent event) {
                if (!this.checkBeansFile(event.getFile())) {
                    return;
                }
                BeansModelImpl.this.beanArchType = null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void fileDataCreated(FileEvent event) {
                FileObject file = event.getFile();
                if (!this.checkBeansFile(file)) {
                    return;
                }
                ModelSource source = BeansModelImpl.this.getModelSource(file, true);
                BeansModelImpl.this.beanArchType = null;
                if (source != null) {
                    WebBeansModel model = WebBeansModelFactory.getInstance().getModel(source);
                    Object object = BeansModelImpl.this.myLock;
                    synchronized (object) {
                        if (BeansModelImpl.this.myModels == null) {
                            return;
                        }
                        BeansModelImpl.this.myModels.add(model);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void fileDeleted(FileEvent event) {
                FileObject file = event.getFile();
                if (!this.wasBeansFile(file)) {
                    return;
                }
                WebBeansModel model = null;
                BeansModelImpl.this.beanArchType = null;
                Object object = BeansModelImpl.this.myLock;
                synchronized (object) {
                    if (BeansModelImpl.this.myModels == null) {
                        return;
                    }
                    for (WebBeansModel mod : BeansModelImpl.this.myModels) {
                        FileObject fileObject = (FileObject)mod.getModelSource().getLookup().lookup(FileObject.class);
                        if (!fileObject.equals(event.getFile())) continue;
                        model = mod;
                        break;
                    }
                    if (model != null) {
                        BeansModelImpl.this.myModels.remove(model);
                    }
                }
            }

            public void fileFolderCreated(FileEvent arg0) {
            }

            public void fileRenamed(FileRenameEvent arg0) {
            }

            private boolean checkBeansFile(FileObject fileObject) {
                FileObject[] roots;
                if (fileObject == null) {
                    return false;
                }
                for (FileObject root : roots = BeansModelImpl.this.getUnit().getSourcePath().getRoots()) {
                    FileObject meta = root.getFileObject(BeansModelImpl.META_INF);
                    if (meta != null && fileObject.equals(meta.getFileObject(BeansModelImpl.BEANS_XML))) {
                        return true;
                    }
                    FileObject webInf = root.getFileObject(BeansModelImpl.WEB_INF);
                    if (webInf == null || !fileObject.equals(webInf.getFileObject(BeansModelImpl.BEANS_XML))) continue;
                    return true;
                }
                return false;
            }

            private boolean wasBeansFile(FileObject fileObject) {
                if (fileObject == null) {
                    return false;
                }
                String name = fileObject.getNameExt();
                if (name.equals(BeansModelImpl.BEANS_XML)) {
                    FileObject parent = fileObject.getParent();
                    if (!parent.getName().equals(BeansModelImpl.META_INF) && !parent.getName().equals(BeansModelImpl.WEB_INF)) {
                        return false;
                    }
                    for (FileObject root : BeansModelImpl.this.getUnit().getSourcePath().getRoots()) {
                        if (!parent.equals(root.getFileObject(BeansModelImpl.META_INF)) && !parent.equals(root.getFileObject(BeansModelImpl.WEB_INF))) continue;
                        return true;
                    }
                }
                return false;
            }
        };
        FileUtil.addFileChangeListener((FileChangeListener)this.myListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initModels() {
        Object object = this.myLock;
        synchronized (object) {
            FileObject[] compileRoots;
            FileObject[] roots;
            LinkedList<WebBeansModel> list = new LinkedList<WebBeansModel>();
            for (FileObject fileObject : roots = this.getUnit().getSourcePath().getRoots()) {
                this.addModels(fileObject, list);
            }
            for (FileObject root : compileRoots = this.getUnit().getCompilePath().getRoots()) {
                this.addCompileModels(root, list);
            }
            this.myModels = new CopyOnWriteArrayList<WebBeansModel>(list);
        }
    }

    private void addCompileModels(FileObject root, List<WebBeansModel> list) {
        FileObject beans = this.getBeansFile(root);
        if (beans != null) {
            this.addCompileModel(beans, root, list);
        }
    }

    private synchronized BeanArchiveType getBeansArchiveType() {
        FileObject beans;
        for (FileObject fileObject : this.getUnit().getSourcePath().getRoots()) {
            beans = this.getBeansFile(fileObject);
            if (beans == null) continue;
            this.beanArchiveType = this.detectArchiveType(beans);
            return this.beanArchiveType;
        }
        for (FileObject fileObject : this.getUnit().getCompilePath().getRoots()) {
            beans = this.getBeansFile(fileObject);
            if (beans == null) continue;
            this.beanArchiveType = this.detectArchiveType(beans);
            return this.beanArchiveType;
        }
        this.beanArchiveType = BeanArchiveType.IMPLICIT;
        return this.beanArchiveType;
    }

    private BeanArchiveType detectArchiveType(FileObject beans) {
        WebBeansModel model = WebBeansModelFactory.getInstance().getModel(this.getModelSource(beans, true));
        if (model == null || model.getRootComponent() == null) {
            return BeanArchiveType.IMPLICIT;
        }
        String attribute = ((WebBeansComponent)model.getRootComponent()).getAttribute(BeansAttributes.BEAN_DISCOVERY_MODE);
        if (attribute == null) {
            attribute = "all";
        }
        switch (attribute) {
            case "none": {
                return BeanArchiveType.NONE;
            }
            case "all": {
                return BeanArchiveType.EXPLICIT;
            }
        }
        return BeanArchiveType.IMPLICIT;
    }

    private FileObject getBeansFile(FileObject root) {
        FileObject beans = null;
        FileObject meta = root.getFileObject(META_INF);
        if (meta != null) {
            beans = meta.getFileObject(BEANS_XML);
        }
        if (beans != null) {
            return beans;
        }
        FileObject web = root.getFileObject(WEB_INF);
        return web != null ? web.getFileObject(BEANS_XML) : null;
    }

    void addCompileModel(FileObject fileObject, FileObject compileRoot, List<WebBeansModel> modelList) {
        WebBeansModel model = WebBeansModelFactory.getInstance().getModel(this.getModelSource(fileObject, false));
        if (model != null) {
            modelList.add(model);
            List<WebBeansModel> list = this.myCompileRootToModel.get(compileRoot);
            if (list == null) {
                list = new ArrayList<WebBeansModel>(2);
                this.myCompileRootToModel.put(compileRoot, list);
            }
            list.add(model);
        }
    }

    private void addModels(FileObject root, List<WebBeansModel> list) {
        FileObject beans = this.getBeansFile(root);
        if (beans != null) {
            this.addModel(beans, list);
        }
    }

    void addModel(FileObject beans, List<WebBeansModel> list) {
        WebBeansModel model = WebBeansModelFactory.getInstance().getModel(this.getModelSource(beans, true));
        if (model != null) {
            list.add(model);
        }
    }

    private ModelSource getModelSource(FileObject fileObject, boolean isEditable) {
        try {
            return Utilities.createModelSource((FileObject)fileObject, (boolean)isEditable);
        }
        catch (CatalogModelException ex) {
            Logger.getLogger("global").log(Level.SEVERE, ex.getMessage(), ex);
            return null;
        }
    }

    private List<WebBeansModel> getModels() {
        return this.myModels;
    }

    private ModelUnit getUnit() {
        return this.myUnit;
    }
}

