/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import org.netbeans.jellytools.JellyTestCase;
import org.netbeans.jemmy.JemmyException;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class FolderContext {
    private URL _base;

    public FolderContext(URL url) {
        FileObject[] fos = URLMapper.findFileObjects((URL)url);
        if (fos == null || fos.length == 0) {
            throw new IllegalStateException("Cannot find file object: " + url);
        }
        this._base = url;
    }

    public static FolderContext getDataFolder(JellyTestCase test) {
        URL url = ((Object)((Object)test)).getClass().getResource("data/");
        if (url == null) {
            throw new IllegalStateException("Cannot find 'data' folder for: " + ((Object)((Object)test)).getClass().getName());
        }
        return new FolderContext(url);
    }

    public static FolderContext getWorkDir(JellyTestCase test) throws IOException {
        String wd = test.getWorkDir().getAbsolutePath();
        FileSystem fs = Repository.getDefault().findFileSystem(wd);
        if (fs == null) {
            throw new IllegalStateException("Cannot mount: " + wd);
        }
        URL url = fs.getRoot().getURL();
        if (url == null) {
            throw new IllegalStateException("Cannot find work dir for: " + ((Object)((Object)test)).getClass().getName());
        }
        return new FolderContext(url);
    }

    public FileObject getFileObject(String spec) {
        Object fo = null;
        URL url = null;
        url = spec == null ? this._base : this.makeURL(spec);
        FileObject[] fos = URLMapper.findFileObjects((URL)url);
        if (fos == null || fos.length == 0) {
            return null;
        }
        return fos[0];
    }

    public DataObject createFolder(String spec) throws IOException {
        return this.createDataObject(spec, null);
    }

    public DataObject createDataObject(String spec, final String content) throws IOException {
        File file = new File(spec);
        String path = file.getParent();
        final String name = file.getName();
        final FileObject parent = this.getFileObject(path);
        if (parent == null) {
            throw new IllegalStateException("Cannot find folder: " + this.makeURL(path));
        }
        FileSystem filesystem = parent.getFileSystem();
        final FileObject[] fileObject = new FileObject[1];
        FileSystem.AtomicAction fsAction = new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                if (content == null) {
                    fileObject[0] = parent.createFolder(name);
                } else {
                    FileObject fo = parent.createData(name);
                    FileLock lock = null;
                    try {
                        lock = fo.lock();
                        OutputStream out = fo.getOutputStream(lock);
                        out = new BufferedOutputStream(out);
                        OutputStreamWriter writer = new OutputStreamWriter(out, "UTF8");
                        writer.write(content);
                        ((Writer)writer).close();
                        lock.releaseLock();
                        lock = null;
                        fileObject[0] = fo;
                    }
                    finally {
                        if (lock != null) {
                            lock.releaseLock();
                        }
                    }
                }
            }
        };
        filesystem.runAtomicAction(fsAction);
        return DataObject.find((FileObject)fileObject[0]);
    }

    public DataObject getDataObject(String spec) {
        DataObject dto = null;
        FileObject fo = this.getFileObject(spec);
        if (fo != null) {
            try {
                dto = DataObject.find((FileObject)fo);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return dto;
    }

    public void deleteDataObject(String spec) throws IOException {
        DataObject dataObject = this.getDataObject(spec);
        if (dataObject == null) {
            return;
        }
        dataObject.getNodeDelegate().destroy();
    }

    public String getTreePath(String path) {
        String tp = null;
        FileObject fo = this.getFileObject("");
        try {
            tp = fo.getFileSystem().getDisplayName() + '|' + fo.getPackageName('|') + '|' + path;
        }
        catch (FileStateInvalidException fsie) {
            throw new JemmyException("Cannot get filesystem for: " + fo.getPackageNameExt('/', '.'), (Throwable)fsie);
        }
        return tp;
    }

    private URL makeURL(String spec) {
        if (spec == null || spec.equals("")) {
            return this._base;
        }
        spec = spec.trim();
        while (spec.startsWith("/")) {
            spec = spec.substring(1);
        }
        URL url = this._base;
        try {
            url = new URL(this._base, spec);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return url;
    }
}

