/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.api.util;

import java.io.File;
import java.util.EventListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

public final class WatchedFile {
    private static final Logger LOGGER = Logger.getLogger(WatchedFile.class.getName());
    final FileObject directory;
    private final String filename;
    final FileChangeListener directoryListener = new DirectoryListener();
    private final FileChangeListener fileListener = new FileListener();
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private File file = null;

    private WatchedFile(String filename, FileObject directory) {
        FileObject testFo;
        File testFile;
        Parameters.notNull((CharSequence)"filename", (Object)filename);
        Parameters.notNull((CharSequence)"directory", (Object)directory);
        if (!directory.isFolder()) {
            throw new IllegalArgumentException("Directory must be given, got " + directory);
        }
        if (!directory.isValid() && (testFile = FileUtil.toFile((FileObject)directory)) != null && (testFo = FileUtil.toFileObject((File)testFile)) != null) {
            directory = testFo;
        }
        this.filename = filename;
        this.directory = directory;
    }

    public static WatchedFile create(String filename, FileObject directory) {
        WatchedFile watchedFile = new WatchedFile(filename, directory);
        watchedFile.directory.addFileChangeListener((FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)watchedFile.directoryListener, (Object)watchedFile.directory));
        return watchedFile;
    }

    public boolean exists() {
        return this.getWatchedFile().exists();
    }

    public File getFile() {
        return this.getWatchedFile();
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    private synchronized File getWatchedFile() {
        if (this.file == null) {
            this.file = FileUtil.normalizeFile((File)new File(FileUtil.toFile((FileObject)this.directory), this.filename));
            try {
                FileUtil.addFileChangeListener((FileChangeListener)this.fileListener, (File)this.file);
                LOGGER.log(Level.FINE, "Started listening to {0}", this.file);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.log(Level.FINE, "Already listening to {0}", this.file);
            }
        }
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear(boolean newFile) {
        if (newFile) {
            WatchedFile watchedFile = this;
            synchronized (watchedFile) {
                if (this.file != null) {
                    try {
                        FileUtil.removeFileChangeListener((FileChangeListener)this.fileListener, (File)this.file);
                        LOGGER.log(Level.FINE, "Stopped listening to {0}", this.file);
                    }
                    catch (IllegalArgumentException ex) {
                        LOGGER.log(Level.FINE, "Not listening yet to {0}", this.file);
                    }
                    LOGGER.log(Level.FINE, "Clearing cached file path {0}", this.file);
                    this.file = null;
                }
            }
        }
        this.fireChange();
    }

    public String toString() {
        return "WatchedFile{directory=" + this.directory + ", filename=" + this.filename + '}';
    }

    private final class FileListener
    extends FileChangeAdapter {
        private FileListener() {
        }

        public void fileDataCreated(FileEvent fe) {
            WatchedFile.this.clear(false);
        }

        public void fileChanged(FileEvent fe) {
            WatchedFile.this.clear(false);
        }

        public void fileDeleted(FileEvent fe) {
            WatchedFile.this.clear(false);
        }

        public void fileRenamed(FileRenameEvent fe) {
            WatchedFile.this.clear(true);
        }
    }

    private final class DirectoryListener
    extends FileChangeAdapter {
        private DirectoryListener() {
        }

        public void fileRenamed(FileRenameEvent fe) {
            WatchedFile.this.clear(true);
        }
    }
}

